/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.glassfish;

import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.impl.RegistrationLogger;
import com.sun.enterprise.registration.impl.RepositoryManager;
import com.sun.enterprise.registration.impl.ServiceTag;
import com.sun.enterprise.registration.impl.SysnetRegistrationService;
import com.sun.pkg.client.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class RegistrationUtil {
    private static final Logger logger = RegistrationLogger.getLogger();
    private static final String REGISTRATION = "registration";
    private static final String LIB = "lib";
    private static final String SERVICE_TAG_REGISTRY_BASE = "servicetag-registry";
    private static final String SERVICE_TAG_REGISTRY_NAME = "servicetag-registry.xml";
    private static final String SERVICE_TAG_REGISTRY_LINK_NAME = "servicetag-registry.lnk";
    private static final String GLASSFISH_REGISTRY_PROPERTIES = "Registration.properties";

    public static File getRegistrationHome() {
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        return RegistrationUtil.getRegistrationHome(installRoot);
    }

    public static File getRegistrationHome(String installRoot) {
        File lib = new File(installRoot, LIB);
        File registration = new File(lib, REGISTRATION);
        return registration;
    }

    public static File getServiceTagRegistry() {
        File serviceTagRegistry = new File(RegistrationUtil.getRegistrationHome(), SERVICE_TAG_REGISTRY_NAME);
        return RegistrationUtil.getServiceTagRegistry(serviceTagRegistry);
    }

    public static File getServiceTagRegistry(String installRoot) {
        File serviceTagRegistry = new File(RegistrationUtil.getRegistrationHome(installRoot), SERVICE_TAG_REGISTRY_NAME);
        return RegistrationUtil.getServiceTagRegistry(serviceTagRegistry);
    }

    private static File getServiceTagRegistry(File serviceTagRegistry) {
        File serviceTagLink;
        if (!serviceTagRegistry.exists() && (serviceTagLink = new File(RegistrationUtil.getRegistrationHome(), SERVICE_TAG_REGISTRY_LINK_NAME)).exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(serviceTagLink));
                String indirectedServiceTagRegistryName = in.readLine();
                File indirectedServiceTagRegisitryFile = new File(indirectedServiceTagRegistryName);
                if (indirectedServiceTagRegisitryFile.exists()) {
                    serviceTagRegistry = indirectedServiceTagRegisitryFile;
                }
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return serviceTagRegistry;
    }

    public static String getGFProductURN() throws RegistrationException {
        try {
            InputStream is = RegistrationUtil.class.getClassLoader().getResourceAsStream(GLASSFISH_REGISTRY_PROPERTIES);
            Properties props = new Properties();
            props.load(is);
            return props.getProperty("product_urn");
        }
        catch (Exception ex) {
            throw new RegistrationException((Throwable)ex);
        }
    }

    public static String getGFInstanceURN() throws RegistrationException {
        SysnetRegistrationService srs = new SysnetRegistrationService(RegistrationUtil.getServiceTagRegistry());
        List st = srs.getRegistrationDescriptors(RegistrationUtil.getGFProductURN());
        if (st.isEmpty()) {
            throw new RegistrationException("Instance URN for " + RegistrationUtil.getGFProductURN() + " not found");
        }
        return ((ServiceTag)st.get(0)).getInstanceURN();
    }

    public static void synchUUID() throws RegistrationException {
        boolean updated;
        String gfProductURN;
        RepositoryManager rm = new RepositoryManager(RegistrationUtil.getServiceTagRegistry());
        String gfInstanceURN = rm.getInstanceURN(gfProductURN = RegistrationUtil.getGFProductURN());
        if (!(gfInstanceURN != null && gfInstanceURN.length() != 0 || (updated = rm.setInstanceURN(gfProductURN, gfInstanceURN = ServiceTag.getNewInstanceURN())))) {
            logger.info("GlassFish instance URN not found");
            return;
        }
        RegistrationUtil.setUpdateCenterUUID(gfInstanceURN);
    }

    public static Image getUpdateCenterImage() throws Exception {
        File ucDir = new File(System.getProperty("com.sun.aas.installRoot"));
        return new Image(ucDir);
    }

    public static void setUpdateCenterUUID(String instanceURN) throws RegistrationException {
        String prefix = "urn:st:";
        try {
            Image image = RegistrationUtil.getUpdateCenterImage();
            String[] authorities = image.getAuthorityNames();
            if (instanceURN.startsWith("urn:st:")) {
                instanceURN = instanceURN.substring("urn:st:".length());
            }
            for (String authority : authorities) {
                image.setAuthority(authority, null, instanceURN);
            }
            image.saveConfig();
        }
        catch (Exception ex) {
            throw new RegistrationException((Throwable)ex);
        }
    }
}

