/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.DRDAServerStarter;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.iapi.util.CheapDateFormatter;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.drda.AppRequester;
import org.apache.derby.impl.drda.CharacterEncodings;
import org.apache.derby.impl.drda.ClientThread;
import org.apache.derby.impl.drda.CodePoint;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DDMWriter;
import org.apache.derby.impl.drda.DRDAConnThread;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.DecryptionManager;
import org.apache.derby.impl.drda.Session;
import org.apache.derby.impl.drda.memCheck;
import org.apache.derby.impl.jdbc.EmbedSQLException;
import org.apache.derby.impl.tools.sysinfo.Main;

public final class NetworkServerControlImpl {
    private static final int NO_USAGE_MSGS = 12;
    private static final String[] COMMANDS = new String[]{"start", "shutdown", "trace", "tracedirectory", "ping", "logconnections", "sysinfo", "runtimeinfo", "maxthreads", "timeslice"};
    private static final int[] COMMAND_ARGS = new int[]{0, 0, 1, 1, 0, 1, 0, 0, 1, 1};
    private static final int COMMAND_START = 0;
    private static final int COMMAND_SHUTDOWN = 1;
    private static final int COMMAND_TRACE = 2;
    private static final int COMMAND_TRACEDIRECTORY = 3;
    private static final int COMMAND_TESTCONNECTION = 4;
    private static final int COMMAND_LOGCONNECTIONS = 5;
    private static final int COMMAND_SYSINFO = 6;
    private static final int COMMAND_RUNTIME_INFO = 7;
    private static final int COMMAND_MAXTHREADS = 8;
    private static final int COMMAND_TIMESLICE = 9;
    private static final int COMMAND_PROPERTIES = 10;
    private static final int COMMAND_UNKNOWN = -1;
    private static final String[] DASHARGS = new String[]{"p", "d", "u", "ld", "ea", "ep", "b", "h", "s"};
    private static final int DASHARG_PORT = 0;
    private static final int DASHARG_DATABASE = 1;
    private static final int DASHARG_USER = 2;
    private static final int DASHARG_LOADSYSIBM = 3;
    private static final int DASHARG_ENCALG = 4;
    private static final int DASHARG_ENCPRV = 5;
    private static final int DASHARG_BOOTPASSWORD = 6;
    private static final int DASHARG_HOST = 7;
    private static final int DASHARG_SESSION = 8;
    private static final int PROTOCOL_VERSION = 1;
    private static final String COMMAND_HEADER = "CMD:";
    private static final String REPLY_HEADER = "RPY:";
    private static final int REPLY_HEADER_LENGTH = "RPY:".length();
    private static final int OK = 0;
    private static final int WARNING = 1;
    private static final int ERROR = 2;
    private static final int SQLERROR = 3;
    private static final int SQLWARNING = 4;
    private static final String DRDA_PROP_MESSAGES = "org.apache.derby.loc.drda.messages";
    private static final String DRDA_PROP_DEBUG = "derby.drda.debug";
    private static final String CLOUDSCAPE_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String UNEXPECTED_ERR = "Unexpected exception";
    private static final int MIN_MAXTHREADS = -1;
    private static final int MIN_TIMESLICE = -1;
    private static final int USE_DEFAULT = -1;
    private static final int DEFAULT_MAXTHREADS = 0;
    private static final int DEFAULT_TIMESLICE = 0;
    private static final String DEFAULT_HOST = "localhost";
    private static final String DRDA_MSG_PREFIX = "DRDA_";
    private static final String DEFAULT_LOCALE = "en";
    private static final String DEFAULT_LOCALE_COUNTRY = "US";
    private static final int SHUTDOWN_CHECK_ATTEMPTS = 20;
    private static final int SHUTDOWN_CHECK_INTERVAL = 500;
    private static final int MAXREPLY = Short.MAX_VALUE;
    protected static String att_srvclsnm;
    protected static final String ATT_SRVNAM = "NetworkServerControl";
    protected static String att_extnam;
    protected static String att_srvrlslv;
    protected static String prdId;
    protected static byte[] prdIdBytes_;
    private static String buildNumber;
    private static String versionString;
    protected static final int CCSIDSBC = 1208;
    protected static final int CCSIDMBC = 1208;
    protected static final String DEFAULT_ENCODING = "UTF8";
    protected static final int DEFAULT_CCSID = 1208;
    protected static final byte SPACE_CHAR = 32;
    protected static final int[] MGR_LEVELS;
    protected PrintWriter logWriter;
    protected PrintWriter cloudscapeLogWriter;
    private static Driver cloudscapeDriver;
    private static final int ERRTYPE_SEVERE = 1;
    private static final int ERRTYPE_USER = 2;
    private static final int ERRTYPE_INFO = 3;
    private static final int ERRTYPE_UNKNOWN = -1;
    private Vector commandArgs = new Vector();
    private String databaseArg;
    private String userArg;
    private String passwordArg;
    private String bootPasswordArg;
    private String encAlgArg;
    private String encPrvArg;
    private String hostArg = "localhost";
    private InetAddress hostAddress;
    private int sessionArg;
    private memCheck mc;
    private byte[] replyBuffer;
    private int replyBufferCount;
    private int replyBufferPos;
    private int portNumber = 1527;
    private String traceDirectory;
    private Object traceDirectorySync = new Object();
    private boolean traceAll;
    private Object traceAllSync = new Object();
    private Object serverStartSync = new Object();
    private boolean logConnections;
    private Object logConnectionsSync = new Object();
    private int minThreads;
    private int maxThreads;
    private Object threadsSync = new Object();
    private int timeSlice;
    private Object timeSliceSync = new Object();
    private boolean keepAlive = true;
    private int minPoolSize;
    private int maxPoolSize;
    private Object poolSync = new Object();
    protected boolean debugOutput = false;
    private boolean cleanupOnStart = false;
    private boolean restartFlag = false;
    protected static final int INVALID_OR_NOTSET_SECURITYMECHANISM = -1;
    private int allowOnlySecurityMechanism = -1;
    private Socket clientSocket = null;
    private InputStream clientIs = null;
    private OutputStream clientOs = null;
    private ByteArrayOutputStream byteArrayOs = new ByteArrayOutputStream();
    private DataOutputStream commandOs = new DataOutputStream(this.byteArrayOs);
    private Object shutdownSync = new Object();
    private boolean shutdown;
    private int connNum;
    private ServerSocket serverSocket;
    private NetworkServerControlImpl serverInstance;
    private LocalizedResource langUtil;
    public String clientLocale;
    ArrayList localAddresses;
    private Hashtable sessionTable = new Hashtable();
    private Session currentSession;
    private Vector threadList = new Vector();
    private Vector runQueue = new Vector();
    private int freeThreads;
    private Hashtable appRequesterTable = new Hashtable();
    private String propertyFileName;
    private Runnable acceptClients;
    private boolean shutdownDatabasesOnShutdown = false;
    private static boolean SUPPORTS_EUSRIDPWD;

    public NetworkServerControlImpl() throws Exception {
        this.init();
        this.getPropertyInfo();
    }

    public NetworkServerControlImpl(InetAddress inetAddress, int n) throws Exception {
        this.init();
        this.getPropertyInfo();
        this.hostAddress = inetAddress;
        this.portNumber = n <= 0 ? this.portNumber : n;
        this.hostArg = inetAddress.getHostAddress();
    }

    private void init() throws Exception {
        this.langUtil = new LocalizedResource(null, null, DRDA_PROP_MESSAGES);
        this.serverInstance = this;
        ProductVersionHolder productVersionHolder = this.getNetProductVersionHolder();
        att_extnam = "NetworkServerControl " + Thread.currentThread().getName();
        att_srvclsnm = productVersionHolder.getProductName();
        versionString = productVersionHolder.getVersionBuildString(true);
        String string = String.valueOf(productVersionHolder.getMajorVersion());
        String string2 = String.valueOf(productVersionHolder.getMinorVersion());
        String string3 = String.valueOf(productVersionHolder.getDrdaMaintVersion());
        prdId = "CSS";
        if (string.length() == 1) {
            prdId = prdId + "0";
        }
        prdId = prdId + string;
        if (string2.length() == 1) {
            prdId = prdId + "0";
        }
        prdId = prdId + string2;
        prdId = prdId + string3;
        att_srvrlslv = prdId + "/" + productVersionHolder.getVersionBuildString(true);
        prdIdBytes_ = prdId.getBytes(DEFAULT_ENCODING);
        buildNumber = productVersionHolder.getBuildNumber();
    }

    private PrintWriter makePrintWriter(OutputStream outputStream) {
        if (outputStream != null) {
            return new PrintWriter(outputStream, true);
        }
        return null;
    }

    protected static Driver getDriver() {
        return cloudscapeDriver;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter != null ? new PrintWriter((Writer)printWriter, true) : printWriter;
    }

    public void consoleError(String string) throws Exception {
        this.consoleMessage(string);
        throw new Exception(string);
    }

    public void consoleExceptionPrint(Exception exception) {
        if (this.debugOutput) {
            this.consoleExceptionPrintTrace(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consoleExceptionPrintTrace(Throwable throwable) {
        PrintWriter printWriter;
        this.consoleMessage(throwable.getMessage());
        if (this.logWriter != null) {
            printWriter = this.logWriter;
            synchronized (printWriter) {
                throwable.printStackTrace(this.logWriter);
            }
        } else {
            throwable.printStackTrace();
        }
        if (this.cloudscapeLogWriter != null) {
            printWriter = this.cloudscapeLogWriter;
            synchronized (printWriter) {
                throwable.printStackTrace(this.cloudscapeLogWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consoleMessage(String string) {
        PrintWriter printWriter;
        if (this.logWriter != null) {
            printWriter = this.logWriter;
            synchronized (printWriter) {
                this.logWriter.println(string);
            }
        }
        if (this.cloudscapeLogWriter != null) {
            printWriter = this.cloudscapeLogWriter;
            synchronized (printWriter) {
                Monitor.logMessage(string);
            }
        }
    }

    public void start(PrintWriter printWriter) throws Exception {
        DRDAServerStarter dRDAServerStarter = new DRDAServerStarter();
        dRDAServerStarter.setStartInfo(this.hostAddress, this.portNumber, printWriter);
        this.startNetworkServer();
        dRDAServerStarter.boot(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockingStart(PrintWriter printWriter) throws Exception {
        block28: {
            Object object;
            this.startNetworkServer();
            this.setLogWriter(printWriter);
            this.cloudscapeLogWriter = Monitor.getStream().getPrintWriter();
            try {
                this.serverSocket = (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, UnknownHostException {
                        if (NetworkServerControlImpl.this.hostAddress == null) {
                            NetworkServerControlImpl.this.hostAddress = InetAddress.getByName(NetworkServerControlImpl.this.hostArg);
                        }
                        NetworkServerControlImpl.this.buildLocalAddressList(NetworkServerControlImpl.this.hostAddress);
                        return new ServerSocket(NetworkServerControlImpl.this.portNumber, 0, NetworkServerControlImpl.this.hostAddress);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                object = privilegedActionException.getException();
                if (object instanceof IOException) {
                    this.consolePropertyMessage("DRDA_ListenPort.S", new String[]{Integer.toString(this.portNumber), this.hostArg});
                }
                if (object instanceof UnknownHostException) {
                    this.consolePropertyMessage("DRDA_UnknownHost.S", this.hostArg);
                }
                throw object;
            }
            catch (Exception exception) {
                this.throwUnexpectedException(exception);
            }
            this.consolePropertyMessage("DRDA_Ready.I", new String[]{Integer.toString(this.portNumber), att_srvclsnm, versionString, this.getFormattedTimestamp()});
            this.acceptClients = new ClientThread(this, this.serverSocket);
            Thread thread = (Thread)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Thread(NetworkServerControlImpl.this.acceptClients);
                }
            });
            thread.start();
            object = this.shutdownSync;
            synchronized (object) {
                try {
                    this.shutdownSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.shutdown = true;
                }
            }
            if (this.mc != null) {
                this.mc.interrupt();
            }
            thread.interrupt();
            object = this.sessionTable;
            synchronized (object) {
                Enumeration enumeration = this.sessionTable.elements();
                while (enumeration.hasMoreElements()) {
                    Session session = (Session)enumeration.nextElement();
                    session.close();
                }
            }
            object = this.threadList;
            synchronized (object) {
                for (int i = 0; i < this.threadList.size(); ++i) {
                    ((DRDAConnThread)this.threadList.get(i)).close();
                    ((DRDAConnThread)this.threadList.get(i)).interrupt();
                }
                this.threadList.clear();
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                this.consolePropertyMessage("DRDA_ListenerClose.S");
            }
            object = this.runQueue;
            synchronized (object) {
                this.runQueue.notifyAll();
            }
            if (this.shutdownDatabasesOnShutdown) {
                try {
                    if (cloudscapeDriver != null) {
                        cloudscapeDriver.connect("jdbc:derby:;shutdown=true", null);
                    }
                }
                catch (SQLException sQLException) {
                    String string = StandardException.getSQLStateFromIdentifier("XJ015.M");
                    if (string.equals(sQLException.getSQLState())) break block28;
                    this.consolePropertyMessage("DRDA_ShutdownWarning.I", sQLException.getMessage());
                }
            }
        }
        this.consolePropertyMessage("DRDA_ShutdownSuccess.I", new String[]{att_srvclsnm, versionString, this.getFormattedTimestamp()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startNetworkServer() throws Exception {
        boolean bl = this.restartFlag;
        Object object = this.serverStartSync;
        synchronized (object) {
            if (bl == this.restartFlag) {
                try {
                    if (this.cleanupOnStart) {
                        Vector vector = this.runQueue;
                        synchronized (vector) {
                            for (int i = 0; i < this.runQueue.size(); ++i) {
                                Session session = (Session)this.runQueue.get(i);
                                session.close();
                                this.removeFromSessionTable(session.getConnNum());
                            }
                            this.runQueue.clear();
                        }
                        cloudscapeDriver = null;
                        System.gc();
                    }
                    Class.forName(CLOUDSCAPE_DRIVER).newInstance();
                    cloudscapeDriver = DriverManager.getDriver("jdbc:derby:");
                }
                catch (Exception exception) {
                    this.consolePropertyMessage("DRDA_LoadException.S", exception.getMessage());
                }
                this.cleanupOnStart = true;
                this.restartFlag = !this.restartFlag;
            }
        }
    }

    public void shutdown() throws Exception {
        this.setUpSocket();
        this.writeCommandHeader(1);
        this.send();
        this.readResult();
        PrintWriter printWriter = this.logWriter;
        FilterOutputStream filterOutputStream = new FilterOutputStream(null){

            public void write(int n) {
            }

            public void flush() {
            }

            public void close() {
            }
        };
        this.setLogWriter(new PrintWriter(filterOutputStream));
        for (int i = 0; i < 20; ++i) {
            Thread.sleep(500L);
            try {
                this.ping();
                continue;
            }
            catch (Exception exception) {
                if (i != 20) break;
                this.consolePropertyMessage("DRDA_ShutdownError.S", new String[]{Integer.toString(this.portNumber), this.hostArg});
                break;
            }
        }
        this.logWriter = printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directShutdown() {
        this.shutdown = true;
        Object object = this.shutdownSync;
        synchronized (object) {
            this.shutdownSync.notifyAll();
        }
    }

    public boolean isServerStarted() throws Exception {
        try {
            this.ping();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void ping() throws Exception {
        String string = null;
        String string2 = null;
        String string3 = null;
        this.setUpSocket();
        this.writeCommandHeader(4);
        this.writeLDString(string);
        this.writeLDString(string2);
        this.writeLDString(string3);
        this.send();
        this.readResult();
    }

    public void trace(boolean bl) throws Exception {
        this.trace(0, bl);
    }

    public void trace(int n, boolean bl) throws Exception {
        this.setUpSocket();
        this.writeCommandHeader(2);
        this.commandOs.writeInt(n);
        this.writeByte(bl ? 1 : 0);
        this.send();
        this.readResult();
        this.consoleTraceMessage(n, bl);
    }

    private void consoleTraceMessage(int n, boolean bl) throws Exception {
        if (n == 0) {
            this.consolePropertyMessage("DRDA_TraceChangeAll.I", bl ? "DRDA_ON.I" : "DRDA_OFF.I");
        } else {
            String[] stringArray = new String[]{bl ? "DRDA_ON.I" : "DRDA_OFF.I", new Integer(n).toString()};
            this.consolePropertyMessage("DRDA_TraceChangeOne.I", stringArray);
        }
    }

    public void logConnections(boolean bl) throws Exception {
        this.setUpSocket();
        this.writeCommandHeader(5);
        this.writeByte(bl ? 1 : 0);
        this.send();
        this.readResult();
    }

    public void sendSetTraceDirectory(String string) throws Exception {
        this.setUpSocket();
        this.writeCommandHeader(3);
        this.writeLDString(string);
        this.send();
        this.readResult();
    }

    public String sysinfo() throws Exception {
        this.setUpSocket();
        this.writeCommandHeader(6);
        this.send();
        return this.readStringReply("DRDA_SysInfoError.S");
    }

    public String runtimeInfo() throws Exception {
        this.setUpSocket();
        this.writeCommandHeader(7);
        this.send();
        return this.readStringReply("DRDA_RuntimeInfoError.S");
    }

    public void usage() {
        try {
            for (int i = 1; i <= 12; ++i) {
                this.consolePropertyMessage("DRDA_Usage" + i + ".I");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void netSetMaxThreads(int n) throws Exception {
        this.setUpSocket();
        this.writeCommandHeader(8);
        this.commandOs.writeInt(n);
        this.send();
        this.readResult();
        int n2 = this.readInt();
        this.consolePropertyMessage("DRDA_MaxThreadsChange.I", new Integer(n2).toString());
    }

    public void netSetTimeSlice(int n) throws Exception {
        this.setUpSocket();
        this.writeCommandHeader(9);
        this.commandOs.writeInt(n);
        this.send();
        this.readResult();
        int n2 = this.readInt();
        this.consolePropertyMessage("DRDA_TimeSliceChange.I", new Integer(n2).toString());
    }

    public Properties getCurrentProperties() throws Exception {
        this.setUpSocket();
        this.writeCommandHeader(10);
        this.send();
        byte[] byArray = this.readBytesReply("DRDA_PropertyError.S");
        Properties properties = new Properties();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            properties.load(byteArrayInputStream);
        }
        catch (IOException iOException) {
            this.consolePropertyMessage("DRDA_IOException.S", iOException.getMessage());
        }
        return properties;
    }

    public static void setUniqueThreadName(Thread thread, String string) {
        if (thread.getName().indexOf("Thread-") == -1) {
            return;
        }
        String string2 = thread.getName();
        thread.setName(string + "_" + string2.substring(string2.indexOf("-") + 1, string2.length()));
    }

    protected void removeFromSessionTable(int n) {
        this.sessionTable.remove(new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void processCommands(DDMReader dDMReader, DDMWriter dDMWriter, Session session) throws Throwable {
        try {
            String string = dDMReader.readCmdString(4);
            String string2 = DEFAULT_LOCALE;
            String string3 = null;
            int n = dDMReader.readNetworkShort();
            if (n <= 0) throw new Throwable(this.langUtil.getTextMessage("DRDA_UnknownProtocol.S", new Integer(n).toString()));
            if (n > 1) {
                throw new Throwable(this.langUtil.getTextMessage("DRDA_UnknownProtocol.S", new Integer(n).toString()));
            }
            byte by = dDMReader.readByte();
            if (by > 0) {
                this.currentSession = session;
                string2 = dDMReader.readCmdString(by);
                session.langUtil = new LocalizedResource(string3, string2, DRDA_PROP_MESSAGES);
            }
            String string4 = null;
            byte by2 = dDMReader.readByte();
            byte by3 = dDMReader.readByte();
            if (by3 != 4) {
                try {
                    this.checkAddressIsLocal(session.clientSocket.getInetAddress());
                }
                catch (Exception exception) {
                    string4 = exception.getMessage();
                }
            }
            if (string4 != null) {
                this.sendMessage(dDMWriter, 2, string4);
                session.langUtil = null;
                this.currentSession = null;
                return;
            }
            switch (by3) {
                case 1: {
                    this.sendOK(dDMWriter);
                    this.directShutdown();
                    return;
                }
                case 2: {
                    boolean bl;
                    this.sessionArg = dDMReader.readNetworkInt();
                    boolean bl2 = bl = dDMReader.readByte() == 1;
                    if (this.setTrace(bl)) {
                        this.sendOK(dDMWriter);
                        return;
                    }
                    this.sendMessage(dDMWriter, 2, this.localizeMessage("DRDA_SessionNotFound.U", session.langUtil == null ? this.langUtil : session.langUtil, new String[]{new Integer(this.sessionArg).toString()}));
                    return;
                }
                case 3: {
                    this.setTraceDirectory(dDMReader.readCmdString());
                    this.sendOK(dDMWriter);
                    this.consolePropertyMessage("DRDA_TraceDirectoryChange.I", this.traceDirectory);
                    return;
                }
                case 4: {
                    this.databaseArg = dDMReader.readCmdString();
                    this.userArg = dDMReader.readCmdString();
                    this.passwordArg = dDMReader.readCmdString();
                    if (this.databaseArg != null) {
                        this.connectToDatabase(dDMWriter, this.databaseArg, this.userArg, this.passwordArg);
                        return;
                    }
                    this.sendOK(dDMWriter);
                    return;
                }
                case 5: {
                    boolean bl = dDMReader.readByte() == 1;
                    this.setLogConnections(bl);
                    this.sendOK(dDMWriter);
                    this.consolePropertyMessage("DRDA_LogConnectionsChange.I", bl ? "DRDA_ON.I" : "DRDA_OFF.I");
                    return;
                }
                case 6: {
                    this.sendSysInfo(dDMWriter);
                    return;
                }
                case 10: {
                    this.sendPropInfo(dDMWriter);
                    return;
                }
                case 7: {
                    this.sendRuntimeInfo(dDMWriter);
                    return;
                }
                case 8: {
                    int n2 = dDMReader.readNetworkInt();
                    try {
                        this.setMaxThreads(n2);
                    }
                    catch (Exception exception) {
                        this.sendMessage(dDMWriter, 2, exception.getMessage());
                        session.langUtil = null;
                        this.currentSession = null;
                        return;
                    }
                    int n3 = this.getMaxThreads();
                    this.sendOKInt(dDMWriter, n3);
                    this.consolePropertyMessage("DRDA_MaxThreadsChange.I", new Integer(n3).toString());
                    return;
                }
                case 9: {
                    int n4 = dDMReader.readNetworkInt();
                    try {
                        this.setTimeSlice(n4);
                    }
                    catch (Exception exception) {
                        this.sendMessage(dDMWriter, 2, exception.getMessage());
                        session.langUtil = null;
                        this.currentSession = null;
                        return;
                    }
                    int n5 = this.getTimeSlice();
                    this.sendOKInt(dDMWriter, n5);
                    this.consolePropertyMessage("DRDA_TimeSliceChange.I", new Integer(n5).toString());
                    return;
                }
            }
            return;
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            this.consoleExceptionPrintTrace(dRDAProtocolException);
            return;
        }
        catch (Exception exception) {
            this.consoleExceptionPrintTrace(exception);
            return;
        }
        finally {
            session.langUtil = null;
            this.currentSession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session getNextSession(Session session) {
        Session session2 = null;
        if (this.shutdown) {
            return session2;
        }
        Vector vector = this.runQueue;
        synchronized (vector) {
            try {
                if (this.runQueue.size() == 0) {
                    if (session == null) {
                        while (this.runQueue.size() == 0) {
                            ++this.freeThreads;
                            this.runQueue.wait();
                            if (this.shutdown) {
                                return null;
                            }
                            --this.freeThreads;
                        }
                    } else {
                        return session;
                    }
                }
                session2 = (Session)this.runQueue.elementAt(0);
                this.runQueue.removeElementAt(0);
                if (session != null) {
                    this.runQueueAdd(session);
                }
            }
            catch (InterruptedException interruptedException) {
                --this.freeThreads;
            }
        }
        return session2;
    }

    protected AppRequester getAppRequester(AppRequester appRequester) {
        AppRequester appRequester2 = null;
        if (!this.appRequesterTable.isEmpty()) {
            appRequester2 = (AppRequester)this.appRequesterTable.get(appRequester.prdid);
        }
        if (appRequester2 == null) {
            this.appRequesterTable.put(appRequester.prdid, appRequester);
            return appRequester;
        }
        if (appRequester2.equals(appRequester)) {
            return appRequester2;
        }
        return appRequester;
    }

    protected int getManagerLevel(int n) {
        int n2 = CodePoint.getManagerIndex(n);
        return MGR_LEVELS[n2];
    }

    protected boolean supportsCCSID(int n) {
        try {
            CharacterEncodings.getJavaEncoding(n);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected void consolePropertyMessage(String string) throws Exception {
        this.consolePropertyMessageWork(string, null);
    }

    protected void consolePropertyMessage(String string, String string2) throws Exception {
        this.consolePropertyMessageWork(string, new String[]{string2});
    }

    protected void consolePropertyMessage(String string, String[] stringArray) throws Exception {
        this.consolePropertyMessageWork(string, stringArray);
    }

    protected static boolean isCmd(String string) {
        return string.equals(COMMAND_HEADER);
    }

    private void writeCommandReplyHeader(DDMWriter dDMWriter) throws Exception {
        dDMWriter.setCMDProtocol();
        dDMWriter.writeString(REPLY_HEADER);
    }

    private void sendOK(DDMWriter dDMWriter) throws Exception {
        this.writeCommandReplyHeader(dDMWriter);
        dDMWriter.writeByte(0);
        dDMWriter.flush();
    }

    private void sendOKInt(DDMWriter dDMWriter, int n) throws Exception {
        this.writeCommandReplyHeader(dDMWriter);
        dDMWriter.writeByte(0);
        dDMWriter.writeNetworkInt(n);
        dDMWriter.flush();
    }

    private void sendMessage(DDMWriter dDMWriter, int n, String string) throws Exception {
        this.writeCommandReplyHeader(dDMWriter);
        dDMWriter.writeByte(n);
        dDMWriter.writeLDString(string);
        dDMWriter.flush();
    }

    private void sendSQLMessage(DDMWriter dDMWriter, SQLException sQLException, int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        while (sQLException != null) {
            if (this.currentSession != null && this.currentSession.langUtil != null && sQLException instanceof EmbedSQLException) {
                stringBuffer.append(sQLException.getSQLState() + ":" + MessageService.getLocalizedMessage(this.currentSession.langUtil.getLocale(), ((EmbedSQLException)sQLException).getMessageId(), ((EmbedSQLException)sQLException).getArguments()));
            } else {
                stringBuffer.append(sQLException.getSQLState() + ":" + sQLException.getMessage());
            }
            if ((sQLException = sQLException.getNextException()) == null) continue;
            stringBuffer.append("\n");
        }
        this.sendMessage(dDMWriter, n, stringBuffer.toString());
    }

    private void sendSysInfo(DDMWriter dDMWriter) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNetSysInfo());
        stringBuffer.append(this.getCLSSysInfo());
        try {
            this.writeCommandReplyHeader(dDMWriter);
            dDMWriter.writeByte(0);
            dDMWriter.writeLDString(stringBuffer.toString());
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            this.consolePropertyMessage("DRDA_SysInfoWriteError.S", dRDAProtocolException.getMessage());
        }
        dDMWriter.flush();
    }

    private void sendRuntimeInfo(DDMWriter dDMWriter) throws Exception {
        try {
            this.writeCommandReplyHeader(dDMWriter);
            dDMWriter.writeByte(0);
            dDMWriter.writeLDString(this.getRuntimeInfo());
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            this.consolePropertyMessage("DRDA_SysInfoWriteError.S", dRDAProtocolException.getMessage());
        }
        dDMWriter.flush();
    }

    private void sendPropInfo(DDMWriter dDMWriter) throws Exception {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Properties properties = this.getPropertyValues();
            properties.store(byteArrayOutputStream, "NetworkServerControl properties");
            try {
                this.writeCommandReplyHeader(dDMWriter);
                dDMWriter.writeByte(0);
                dDMWriter.writeLDBytes(byteArrayOutputStream.toByteArray());
            }
            catch (DRDAProtocolException dRDAProtocolException) {
                this.consolePropertyMessage("DRDA_PropInfoWriteError.S", dRDAProtocolException.getMessage());
            }
            dDMWriter.flush();
        }
        catch (Exception exception) {
            this.consoleExceptionPrintTrace(exception);
        }
    }

    private String getNetSysInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        LocalizedResource localizedResource = this.langUtil;
        if (this.currentSession != null && this.currentSession.langUtil != null) {
            localizedResource = this.currentSession.langUtil;
        }
        stringBuffer.append(localizedResource.getTextMessage("DRDA_SysInfoBanner.I") + "\n");
        stringBuffer.append(localizedResource.getTextMessage("DRDA_SysInfoVersion.I") + " " + att_srvrlslv);
        stringBuffer.append("  ");
        stringBuffer.append(localizedResource.getTextMessage("DRDA_SysInfoBuild.I") + " " + buildNumber);
        stringBuffer.append("  ");
        stringBuffer.append(localizedResource.getTextMessage("DRDA_SysInfoDrdaPRDID.I") + " " + prdId);
        stringBuffer.append("\n");
        Properties properties = this.getPropertyValues();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        properties.list(printStream);
        stringBuffer.append(byteArrayOutputStream.toString());
        return stringBuffer.toString();
    }

    private String getRuntimeInfo() {
        return this.buildRuntimeInfo(this.langUtil);
    }

    private String getCLSSysInfo() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LocalizedResource localizedResource = this.langUtil;
        if (this.currentSession != null && this.currentSession.langUtil != null) {
            localizedResource = this.currentSession.langUtil;
        }
        LocalizedOutput localizedOutput = localizedResource.getNewOutput(byteArrayOutputStream);
        Main.getMainInfo(localizedOutput, false);
        return byteArrayOutputStream.toString();
    }

    public void executeWork(String[] stringArray) throws Exception {
        this.logWriter = this.makePrintWriter(System.out);
        int n = 0;
        if (stringArray.length > 0) {
            n = this.findCommand(stringArray);
        } else {
            this.consolePropertyMessage("DRDA_NoArgs.U");
        }
        if (n == -1) {
            return;
        }
        if (this.commandArgs.size() != COMMAND_ARGS[n]) {
            this.consolePropertyMessage("DRDA_InvalidNoArgs.U", COMMANDS[n]);
        }
        switch (n) {
            case 0: {
                this.shutdownDatabasesOnShutdown = true;
                this.blockingStart(this.makePrintWriter(System.out));
                break;
            }
            case 1: {
                this.shutdown();
                this.consolePropertyMessage("DRDA_ShutdownSuccess.I", new String[]{att_srvclsnm, versionString, this.getFormattedTimestamp()});
                break;
            }
            case 2: {
                boolean bl = this.isOn((String)this.commandArgs.elementAt(0));
                this.trace(this.sessionArg, bl);
                this.consoleTraceMessage(this.sessionArg, bl);
                break;
            }
            case 3: {
                this.setTraceDirectory((String)this.commandArgs.elementAt(0));
                this.consolePropertyMessage("DRDA_TraceDirectoryChange.I", this.traceDirectory);
                break;
            }
            case 4: {
                this.ping();
                this.consolePropertyMessage("DRDA_ConnectionTested.I", new String[]{this.hostArg, new Integer(this.portNumber).toString()});
                break;
            }
            case 5: {
                boolean bl = this.isOn((String)this.commandArgs.elementAt(0));
                this.logConnections(bl);
                this.consolePropertyMessage("DRDA_LogConnectionsChange.I", bl ? "DRDA_ON.I" : "DRDA_OFF.I");
                break;
            }
            case 6: {
                String string = this.sysinfo();
                this.consoleMessage(string);
                break;
            }
            case 8: {
                int n2 = 0;
                try {
                    n2 = Integer.parseInt((String)this.commandArgs.elementAt(0));
                }
                catch (NumberFormatException numberFormatException) {
                    this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{(String)this.commandArgs.elementAt(0), "maxthreads"});
                }
                if (n2 < -1) {
                    this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{new Integer(n2).toString(), "maxthreads"});
                }
                this.netSetMaxThreads(n2);
                break;
            }
            case 7: {
                String string = this.runtimeInfo();
                this.consoleMessage(string);
                break;
            }
            case 9: {
                int n3 = 0;
                String string = (String)this.commandArgs.elementAt(0);
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{(String)this.commandArgs.elementAt(0), "timeslice"});
                }
                if (n3 < -1) {
                    this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{new Integer(n3).toString(), "timeslice"});
                }
                this.netSetTimeSlice(n3);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQueueAdd(Session session) {
        Vector vector = this.runQueue;
        synchronized (vector) {
            this.runQueue.addElement(session);
            this.runQueue.notify();
        }
    }

    private int findCommand(String[] stringArray) throws Exception {
        block7: {
            try {
                int n = 0;
                int n2 = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].startsWith("-")) {
                        n2 = this.processDashArg(n, stringArray);
                        if (n2 == n) {
                            this.commandArgs.addElement(stringArray[n++]);
                            continue;
                        }
                        n = n2;
                        continue;
                    }
                    this.commandArgs.addElement(stringArray[n++]);
                }
                if (this.commandArgs.size() > 0) {
                    for (n = 0; n < COMMANDS.length; ++n) {
                        if (!StringUtil.SQLEqualsIgnoreCase(COMMANDS[n], (String)this.commandArgs.firstElement())) continue;
                        this.commandArgs.removeElementAt(0);
                        return n;
                    }
                }
                this.consolePropertyMessage("DRDA_UnknownCommand.U", (String)this.commandArgs.firstElement());
            }
            catch (Exception exception) {
                if (!exception.getMessage().equals(UNEXPECTED_ERR)) break block7;
                throw exception;
            }
        }
        return -1;
    }

    private int processDashArg(int n, String[] stringArray) throws Exception {
        char c = stringArray[n].charAt(1);
        if (c >= '0' && c <= '9') {
            return n;
        }
        int n2 = -1;
        for (int i = 0; i < DASHARGS.length; ++i) {
            if (!DASHARGS[i].equals(stringArray[n].substring(1))) continue;
            n2 = i;
            ++n;
            break;
        }
        if (n2 == -1) {
            this.consolePropertyMessage("DRDA_UnknownArgument.U", stringArray[n]);
        }
        switch (n2) {
            case 0: {
                if (n < stringArray.length) {
                    try {
                        this.portNumber = Integer.parseInt(stringArray[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{stringArray[n], "DRDA_PortNumber.I"});
                    }
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_PortNumber.I");
                break;
            }
            case 7: {
                if (n < stringArray.length) {
                    this.hostArg = stringArray[n];
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_Host.I");
                break;
            }
            case 1: {
                if (n < stringArray.length) {
                    this.databaseArg = stringArray[n];
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_DatabaseDirectory.I");
                break;
            }
            case 2: {
                if (n < stringArray.length) {
                    this.userArg = stringArray[n++];
                    if (n < stringArray.length) {
                        this.passwordArg = stringArray[n];
                        break;
                    }
                    this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_Password.I");
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_User.I");
                break;
            }
            case 4: {
                if (n < stringArray.length) {
                    this.encAlgArg = stringArray[n];
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_EncryptionAlgorithm.I");
                break;
            }
            case 5: {
                if (n < stringArray.length) {
                    this.encPrvArg = stringArray[n];
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_EncryptionProvider.I");
                break;
            }
            case 3: {
                break;
            }
            case 8: {
                if (n < stringArray.length) {
                    try {
                        this.sessionArg = Integer.parseInt(stringArray[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{stringArray[n], "DRDA_Session.I"});
                    }
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_Session.I");
                break;
            }
        }
        return n + 1;
    }

    private boolean isOn(String string) throws Exception {
        if (StringUtil.SQLEqualsIgnoreCase(string, "on")) {
            return true;
        }
        if (!StringUtil.SQLEqualsIgnoreCase(string, "off")) {
            this.consolePropertyMessage("DRDA_OnOffValue.U", string);
        }
        return false;
    }

    private void setUpSocket() throws Exception {
        try {
            this.clientSocket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException, IOException {
                    if (NetworkServerControlImpl.this.hostAddress == null) {
                        NetworkServerControlImpl.this.hostAddress = InetAddress.getByName(NetworkServerControlImpl.this.hostArg);
                    }
                    InetAddress inetAddress = JVMInfo.JDK_ID <= 2 && NetworkServerControlImpl.this.hostAddress.getHostAddress().equals("0.0.0.0") ? InetAddress.getLocalHost() : NetworkServerControlImpl.this.hostAddress;
                    return new Socket(inetAddress, NetworkServerControlImpl.this.portNumber);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof UnknownHostException) {
                this.consolePropertyMessage("DRDA_UnknownHost.S", this.hostArg);
            } else if (exception instanceof IOException) {
                this.consolePropertyMessage("DRDA_NoIO.S", new String[]{this.hostArg, new Integer(this.portNumber).toString()});
            }
        }
        catch (Exception exception) {
            this.throwUnexpectedException(exception);
        }
        try {
            this.clientIs = this.clientSocket.getInputStream();
            this.clientOs = this.clientSocket.getOutputStream();
        }
        catch (IOException iOException) {
            this.consolePropertyMessage("DRDA_NoInputStream.I");
            throw iOException;
        }
    }

    private void checkAddressIsLocal(InetAddress inetAddress) throws UnknownHostException, Exception {
        for (int i = 0; i < this.localAddresses.size(); ++i) {
            if (!inetAddress.equals((InetAddress)this.localAddresses.get(i))) continue;
            return;
        }
        this.consolePropertyMessage("DRDA_NeedLocalHost.S", new String[]{inetAddress.getHostName(), this.serverSocket.getInetAddress().getHostName()});
    }

    private void buildLocalAddressList(InetAddress inetAddress) {
        this.localAddresses = new ArrayList(3);
        this.localAddresses.add(inetAddress);
        try {
            this.localAddresses.add(InetAddress.getLocalHost());
            this.localAddresses.add(InetAddress.getByName(DEFAULT_HOST));
        }
        catch (UnknownHostException unknownHostException) {
            try {
                this.consolePropertyMessage("DRDA_UnknownHostWarning.I", unknownHostException.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void writeCommandHeader(int n) throws Exception {
        try {
            this.writeString(COMMAND_HEADER);
            this.commandOs.writeByte(0);
            this.commandOs.writeByte(1);
            if (this.clientLocale != null && this.clientLocale != DEFAULT_LOCALE) {
                this.commandOs.writeByte(this.clientLocale.length());
                this.commandOs.writeBytes(this.clientLocale);
            } else {
                this.commandOs.writeByte(0);
            }
            this.commandOs.writeByte(0);
            this.commandOs.writeByte((byte)n);
        }
        catch (IOException iOException) {
            this.clientSocketError(iOException);
        }
    }

    private void writeLDString(String string) throws Exception {
        try {
            if (string == null) {
                this.commandOs.writeShort(0);
            } else {
                this.commandOs.writeShort(string.length());
                this.writeString(string);
            }
        }
        catch (IOException iOException) {
            this.clientSocketError(iOException);
        }
    }

    protected void writeString(String string) throws Exception {
        byte[] byArray = string.getBytes(DEFAULT_ENCODING);
        this.commandOs.write(byArray, 0, byArray.length);
    }

    private void writeShort(int n) throws Exception {
        try {
            this.commandOs.writeByte((byte)((n & 0xF0) >> 8));
            this.commandOs.writeByte((byte)(n & 0xF));
        }
        catch (IOException iOException) {
            this.clientSocketError(iOException);
        }
    }

    private void writeByte(int n) throws Exception {
        try {
            this.commandOs.writeByte((byte)(n & 0xF));
        }
        catch (IOException iOException) {
            this.clientSocketError(iOException);
        }
    }

    private void send() throws Exception {
        try {
            this.byteArrayOs.writeTo(this.clientOs);
            this.commandOs.flush();
            this.byteArrayOs.reset();
        }
        catch (IOException iOException) {
            this.clientSocketError(iOException);
        }
    }

    private void clientSocketError(IOException iOException) throws IOException {
        try {
            this.consolePropertyMessage("DRDA_ClientSocketError.S", iOException.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.consoleExceptionPrintTrace(iOException);
        throw iOException;
    }

    private void readResult() throws Exception {
        int n;
        this.fillReplyBuffer();
        this.readCommandReplyHeader();
        if (this.replyBufferPos >= this.replyBufferCount) {
            this.consolePropertyMessage("DRDA_InvalidReplyTooShort.S");
        }
        if ((n = this.replyBuffer[this.replyBufferPos++] & 0xFF) == 0) {
            return;
        }
        String string = this.readLDString();
        if (n == 3) {
            this.wrapSQLError(string);
        } else if (n == 4) {
            this.wrapSQLWarning(string);
        } else {
            this.consolePropertyMessage(string);
        }
    }

    private void ensureDataInBuffer(int n) throws Exception {
        while (this.replyBufferCount - this.replyBufferPos < n) {
            try {
                int n2 = this.clientIs.read(this.replyBuffer, this.replyBufferCount, this.replyBuffer.length - this.replyBufferCount);
                this.replyBufferCount += n2;
            }
            catch (IOException iOException) {
                this.clientSocketError(iOException);
            }
        }
    }

    private void fillReplyBuffer() throws Exception {
        if (this.replyBuffer == null) {
            this.replyBuffer = new byte[Short.MAX_VALUE];
        }
        try {
            this.replyBufferCount = this.clientIs.read(this.replyBuffer);
        }
        catch (IOException iOException) {
            this.clientSocketError(iOException);
        }
        if (this.replyBufferCount == -1) {
            this.consolePropertyMessage("DRDA_InvalidReplyTooShort.S");
        }
        this.replyBufferPos = 0;
    }

    private void readCommandReplyHeader() throws Exception {
        String string;
        this.ensureDataInBuffer(REPLY_HEADER_LENGTH);
        if (this.replyBufferCount < REPLY_HEADER_LENGTH) {
            this.consolePropertyMessage("DRDA_InvalidReplyHeader1.S", Integer.toString(this.replyBufferCount));
        }
        if (!(string = new String(this.replyBuffer, 0, REPLY_HEADER_LENGTH, DEFAULT_ENCODING)).equals(REPLY_HEADER)) {
            this.consolePropertyMessage("DRDA_InvalidReplyHeader2.S", string);
        }
        this.replyBufferPos += REPLY_HEADER_LENGTH;
    }

    private int readShort() throws Exception {
        this.ensureDataInBuffer(2);
        if (this.replyBufferPos + 2 > this.replyBufferCount) {
            this.consolePropertyMessage("DRDA_InvalidReplyTooShort.S");
        }
        return ((this.replyBuffer[this.replyBufferPos++] & 0xFF) << 8) + (this.replyBuffer[this.replyBufferPos++] & 0xFF);
    }

    private int readInt() throws Exception {
        this.ensureDataInBuffer(4);
        if (this.replyBufferPos + 4 > this.replyBufferCount) {
            this.consolePropertyMessage("DRDA_InvalidReplyTooShort.S");
        }
        return ((this.replyBuffer[this.replyBufferPos++] & 0xFF) << 24) + ((this.replyBuffer[this.replyBufferPos++] & 0xFF) << 16) + ((this.replyBuffer[this.replyBufferPos++] & 0xFF) << 8) + (this.replyBuffer[this.replyBufferPos++] & 0xFF);
    }

    private String readStringReply(String string) throws Exception {
        this.fillReplyBuffer();
        this.readCommandReplyHeader();
        if (this.replyBuffer[this.replyBufferPos++] == 0) {
            return this.readLDString();
        }
        this.consolePropertyMessage(string);
        return null;
    }

    private String readLDString() throws Exception {
        int n = this.readShort();
        this.ensureDataInBuffer(n);
        if (this.replyBufferPos + n > this.replyBufferCount) {
            this.consolePropertyMessage("DRDA_InvalidReplyTooShort.S");
        }
        String string = new String(this.replyBuffer, this.replyBufferPos, n, DEFAULT_ENCODING);
        this.replyBufferPos += n;
        return string;
    }

    private byte[] readBytesReply(String string) throws Exception {
        this.fillReplyBuffer();
        this.readCommandReplyHeader();
        if (this.replyBuffer[this.replyBufferPos++] == 0) {
            return this.readLDBytes();
        }
        this.consolePropertyMessage(string);
        return null;
    }

    private byte[] readLDBytes() throws Exception {
        int n = this.readShort();
        this.ensureDataInBuffer(n);
        if (this.replyBufferPos + n > this.replyBufferCount) {
            this.consolePropertyMessage("DRDA_InvalidReplyTooShort.S");
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.replyBuffer[this.replyBufferPos++];
        }
        return byArray;
    }

    private void getPropertyInfo() throws Exception {
        String string = PropertyUtil.getSystemProperty("derby.system.home");
        String string2 = PropertyUtil.getSystemProperty("derby.drda.logConnections");
        if (string2 != null && StringUtil.SQLEqualsIgnoreCase(string2, "true")) {
            this.setLogConnections(true);
        }
        if ((string2 = PropertyUtil.getSystemProperty("derby.drda.traceAll")) != null && StringUtil.SQLEqualsIgnoreCase(string2, "true")) {
            this.setTraceAll(true);
        }
        if ((string2 = PropertyUtil.getSystemProperty("derby.drda.traceDirectory", string)) != null) {
            if (string2.equals("")) {
                string2 = string;
            }
            this.setTraceDirectory(string2);
        }
        if ((string2 = PropertyUtil.getSystemProperty("derby.drda.minThreads")) != null) {
            if (string2.equals("")) {
                string2 = "0";
            }
            this.setMinThreads(this.getIntPropVal("derby.drda.minThreads", string2));
        }
        if ((string2 = PropertyUtil.getSystemProperty("derby.drda.maxThreads")) != null) {
            if (string2.equals("")) {
                string2 = "0";
            }
            this.setMaxThreads(this.getIntPropVal("derby.drda.maxThreads", string2));
        }
        if ((string2 = PropertyUtil.getSystemProperty("derby.drda.timeSlice")) != null) {
            if (string2.equals("")) {
                string2 = "0";
            }
            this.setTimeSlice(this.getIntPropVal("derby.drda.timeSlice", string2));
        }
        if ((string2 = PropertyUtil.getSystemProperty("derby.drda.portNumber")) != null) {
            if (string2.equals("")) {
                string2 = String.valueOf(1527);
            }
            this.portNumber = this.getIntPropVal("derby.drda.portNumber", string2);
        }
        if ((string2 = PropertyUtil.getSystemProperty("derby.drda.keepAlive")) != null && StringUtil.SQLEqualsIgnoreCase(string2, "false")) {
            this.keepAlive = false;
        }
        if ((string2 = PropertyUtil.getSystemProperty("derby.drda.host")) != null) {
            this.hostArg = string2.equals("") ? DEFAULT_HOST : string2;
        }
        if ((string2 = PropertyUtil.getSystemProperty(DRDA_PROP_DEBUG)) != null && StringUtil.SQLEqualsIgnoreCase(string2, "true")) {
            this.debugOutput = true;
        }
        if ((string2 = PropertyUtil.getSystemProperty("derby.drda.securityMechanism")) != null) {
            this.setSecurityMechanism(string2);
        }
    }

    private int getSecMecValue(String string) {
        int n = -1;
        if (StringUtil.SQLEqualsIgnoreCase(string, "USER_ONLY_SECURITY")) {
            n = 4;
        } else if (StringUtil.SQLEqualsIgnoreCase(string, "CLEAR_TEXT_PASSWORD_SECURITY")) {
            n = 3;
        } else if (StringUtil.SQLEqualsIgnoreCase(string, "ENCRYPTED_USER_AND_PASSWORD_SECURITY")) {
            n = 9;
        } else if (StringUtil.SQLEqualsIgnoreCase(string, "STRONG_PASSWORD_SUBSTITUTE_SECURITY")) {
            n = 8;
        }
        return n;
    }

    private String getStringValueForSecMec(int n) {
        switch (n) {
            case 4: {
                return "USER_ONLY_SECURITY";
            }
            case 3: {
                return "CLEAR_TEXT_PASSWORD_SECURITY";
            }
            case 9: {
                return "ENCRYPTED_USER_AND_PASSWORD_SECURITY";
            }
            case 8: {
                return "STRONG_PASSWORD_SUBSTITUTE_SECURITY";
            }
        }
        return null;
    }

    boolean supportsEUSRIDPWD() {
        return SUPPORTS_EUSRIDPWD;
    }

    private int getIntPropVal(String string, String string2) throws Exception {
        int n = 0;
        try {
            n = new Integer(string2);
        }
        catch (Exception exception) {
            this.consolePropertyMessage("DRDA_InvalidPropVal.S", new String[]{string, string2});
        }
        return n;
    }

    private void consolePropertyMessageWork(String string, String[] stringArray) throws Exception {
        String string2 = null;
        int n = this.getMessageType(string);
        string2 = n == -1 ? string : this.localizeMessage(string, this.langUtil, stringArray);
        this.consoleMessage(string2);
        if (n == 2) {
            this.usage();
        }
        if (this.currentSession != null && this.currentSession.langUtil != null && n != -1) {
            string2 = this.localizeMessage(string, this.currentSession.langUtil, stringArray);
        }
        if (n == 1 || n == 2) {
            if (string.equals("DRDA_SQLException.S")) {
                this.throwSQLException(stringArray[0]);
            } else if (string.equals("DRDA_SQLWarning.I")) {
                this.throwSQLWarning(stringArray[0]);
            } else {
                throw new Exception(string + ":" + string2);
            }
        }
        if (n == -1) {
            throw new Exception(string2);
        }
    }

    private void throwSQLException(String string) throws SQLException {
        SQLException sQLException;
        SQLException sQLException2 = null;
        SQLException sQLException3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.charAt(5) == ':') {
                if (stringBuffer.length() > 0) {
                    if (sQLException2 == null) {
                        sQLException3 = sQLException2 = new SQLException(stringBuffer.toString(), string2);
                    } else {
                        sQLException = new SQLException(stringBuffer.toString(), string2);
                        sQLException3.setNextException(sQLException);
                        sQLException3 = sQLException;
                    }
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(string3.substring(6));
                string2 = string3.substring(0, 5);
                continue;
            }
            stringBuffer.append(string3);
        }
        if (stringBuffer.length() > 0) {
            if (sQLException2 == null) {
                sQLException3 = sQLException2 = new SQLException(stringBuffer.toString(), string2);
            } else {
                sQLException = new SQLException(stringBuffer.toString(), string2);
                sQLException3.setNextException(sQLException);
                sQLException3 = sQLException;
            }
        }
        throw sQLException2;
    }

    private void throwSQLWarning(String string) throws SQLWarning {
        SQLWarning sQLWarning;
        SQLWarning sQLWarning2 = null;
        SQLWarning sQLWarning3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.charAt(5) == ':') {
                if (stringBuffer.length() > 0) {
                    if (sQLWarning2 == null) {
                        sQLWarning3 = sQLWarning2 = new SQLWarning(stringBuffer.toString(), string2);
                    } else {
                        sQLWarning = new SQLWarning(stringBuffer.toString(), string2);
                        sQLWarning3.setNextException(sQLWarning);
                        sQLWarning3 = sQLWarning;
                    }
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(string3.substring(6));
                string2 = string3.substring(0, 5);
                continue;
            }
            stringBuffer.append(string3);
        }
        if (stringBuffer.length() > 0) {
            if (sQLWarning2 == null) {
                sQLWarning3 = sQLWarning2 = new SQLWarning(stringBuffer.toString(), string2);
            } else {
                sQLWarning = new SQLWarning(stringBuffer.toString(), string2);
                sQLWarning3.setNextException(sQLWarning);
                sQLWarning3 = sQLWarning;
            }
        }
        throw sQLWarning2;
    }

    private void throwUnexpectedException(Exception exception) throws Exception {
        this.consoleExceptionPrintTrace(exception);
        throw new Exception(UNEXPECTED_ERR);
    }

    private String localizeMessage(String string, LocalizedResource localizedResource, String[] stringArray) {
        String string2 = null;
        if (stringArray != null) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = this.isMsgProperty(stringArray[i]) ? localizedResource.getTextMessage(stringArray[i]) : stringArray[i];
            }
            switch (stringArray.length) {
                case 1: {
                    string2 = localizedResource.getTextMessage(string, stringArray2[0]);
                    break;
                }
                case 2: {
                    string2 = localizedResource.getTextMessage(string, stringArray2[0], stringArray2[1]);
                    break;
                }
                case 3: {
                    string2 = localizedResource.getTextMessage(string, stringArray2[0], stringArray2[1], stringArray2[2]);
                    break;
                }
                case 4: {
                    string2 = localizedResource.getTextMessage(string, stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3]);
                    break;
                }
            }
        } else {
            string2 = localizedResource.getTextMessage(string);
        }
        return string2;
    }

    private int getMessageType(String string) {
        if (!string.startsWith(DRDA_MSG_PREFIX)) {
            return -1;
        }
        int n = string.indexOf(46) + 1;
        if (n >= string.length()) {
            return -1;
        }
        if (string.length() > n + 1) {
            return -1;
        }
        char c = string.charAt(n);
        if (c == 'S') {
            return 1;
        }
        if (c == 'U') {
            return 2;
        }
        if (c == 'I') {
            return 3;
        }
        return -1;
    }

    private boolean isMsgProperty(String string) {
        return string.startsWith(DRDA_MSG_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getLogConnections() {
        Object object = this.logConnectionsSync;
        synchronized (object) {
            return this.logConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLogConnections(boolean bl) {
        Object object = this.logConnectionsSync;
        synchronized (object) {
            this.logConnections = bl;
        }
        object = this.threadList;
        synchronized (object) {
            Enumeration enumeration = this.threadList.elements();
            while (enumeration.hasMoreElements()) {
                DRDAConnThread dRDAConnThread = (DRDAConnThread)enumeration.nextElement();
                dRDAConnThread.setLogConnections(bl);
            }
        }
    }

    private void setSecurityMechanism(String string) throws Exception {
        this.allowOnlySecurityMechanism = this.getSecMecValue(string);
        if (this.allowOnlySecurityMechanism == -1 || this.allowOnlySecurityMechanism == 9 && !SUPPORTS_EUSRIDPWD) {
            this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{string, "derby.drda.securityMechanism"});
        }
    }

    protected int getSecurityMechanism() {
        return this.allowOnlySecurityMechanism;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setTrace(boolean bl) {
        if (this.sessionArg == 0) {
            this.setTraceAll(bl);
            Hashtable hashtable = this.sessionTable;
            synchronized (hashtable) {
                Enumeration enumeration = this.sessionTable.elements();
                while (enumeration.hasMoreElements()) {
                    Session session = (Session)enumeration.nextElement();
                    if (bl) {
                        session.setTraceOn(this.traceDirectory);
                        continue;
                    }
                    session.setTraceOff();
                }
            }
        } else {
            Session session = (Session)this.sessionTable.get(new Integer(this.sessionArg));
            if (session != null) {
                if (bl) {
                    session.setTraceOn(this.traceDirectory);
                } else {
                    session.setTraceOff();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected int getTimeSlice() {
        return this.timeSlice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimeSlice(int n) throws Exception {
        if (n < -1) {
            this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{new Integer(n).toString(), "timeslice"});
        }
        if (n == -1) {
            n = 0;
        }
        Object object = this.timeSliceSync;
        synchronized (object) {
            this.timeSlice = n;
        }
    }

    protected boolean getKeepAlive() {
        return this.keepAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMinThreads() {
        Object object = this.threadsSync;
        synchronized (object) {
            return this.minThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMinThreads(int n) {
        Object object = this.threadsSync;
        synchronized (object) {
            this.minThreads = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxThreads() {
        Object object = this.threadsSync;
        synchronized (object) {
            return this.maxThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMaxThreads(int n) throws Exception {
        if (n < -1) {
            this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{new Integer(n).toString(), "maxthreads"});
        }
        if (n == -1) {
            n = 0;
        }
        Object object = this.threadsSync;
        synchronized (object) {
            this.maxThreads = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getTraceAll() {
        Object object = this.traceAllSync;
        synchronized (object) {
            return this.traceAll;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTraceAll(boolean bl) {
        Object object = this.traceAllSync;
        synchronized (object) {
            this.traceAll = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTraceDirectory() {
        Object object = this.traceDirectorySync;
        synchronized (object) {
            return this.traceDirectory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTraceDirectory(String string) {
        Object object = this.traceDirectorySync;
        synchronized (object) {
            this.traceDirectory = string;
        }
    }

    private void connectToDatabase(DDMWriter dDMWriter, String string, String string2, String string3) throws Exception {
        Properties properties = new Properties();
        if (string2 != null) {
            properties.put("user", string2);
        }
        if (string3 != null) {
            properties.put("password", string3);
        }
        try {
            Class.forName(CLOUDSCAPE_DRIVER);
        }
        catch (Exception exception) {
            this.sendMessage(dDMWriter, 2, exception.getMessage());
            return;
        }
        try {
            Connection connection = DriverManager.getConnection("jdbc:derby:" + string, properties);
            SQLWarning sQLWarning = connection.getWarnings();
            if (sQLWarning != null) {
                this.sendSQLMessage(dDMWriter, sQLWarning, 4);
            } else {
                this.sendOK(dDMWriter);
            }
            connection.close();
            return;
        }
        catch (SQLException sQLException) {
            this.sendSQLMessage(dDMWriter, sQLException, 3);
            return;
        }
    }

    private void startDatabase(DDMWriter dDMWriter, String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        Properties properties = new Properties();
        if (string2 != null) {
            properties.put("bootPassword", string2);
        }
        if (string3 != null) {
            properties.put("encryptionProvider", string3);
        }
        if (string4 != null) {
            properties.put("encryptionAlgorithm", string4);
        }
        if (string5 != null) {
            properties.put("user", string5);
        }
        if (string6 != null) {
            properties.put("password", string6);
        }
        try {
            Class.forName(CLOUDSCAPE_DRIVER);
        }
        catch (Exception exception) {
            this.sendMessage(dDMWriter, 2, exception.getMessage());
            return;
        }
        try {
            Connection connection = DriverManager.getConnection("jdbc:derby:" + string, properties);
            SQLWarning sQLWarning = connection.getWarnings();
            if (sQLWarning != null) {
                this.sendSQLMessage(dDMWriter, sQLWarning, 4);
            } else {
                this.sendOK(dDMWriter);
            }
            connection.close();
        }
        catch (SQLException sQLException) {
            this.sendSQLMessage(dDMWriter, sQLException, 3);
        }
        catch (Exception exception) {
            this.sendMessage(dDMWriter, 2, exception.getMessage());
        }
    }

    private void shutdownDatabase(DDMWriter dDMWriter, String string, String string2, String string3) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("jdbc:derby:" + string);
        if (string2 != null) {
            stringBuffer.append(";user=" + string2);
        }
        if (string3 != null) {
            stringBuffer.append(";password=" + string3);
        }
        stringBuffer.append(";shutdown=true");
        try {
            Class.forName(CLOUDSCAPE_DRIVER);
        }
        catch (Exception exception) {
            this.sendMessage(dDMWriter, 2, exception.getMessage());
            return;
        }
        try {
            Connection connection = DriverManager.getConnection(stringBuffer.toString());
            SQLWarning sQLWarning = connection.getWarnings();
            if (sQLWarning != null) {
                this.sendSQLMessage(dDMWriter, sQLWarning, 4);
            } else {
                this.sendOK(dDMWriter);
            }
            connection.close();
        }
        catch (SQLException sQLException) {
            String string4 = StandardException.getSQLStateFromIdentifier("08006.D");
            if (!string4.equals(sQLException.getSQLState())) {
                this.sendSQLMessage(dDMWriter, sQLException, 3);
                return;
            }
            this.sendOK(dDMWriter);
        }
    }

    private void wrapSQLError(String string) throws Exception {
        this.consolePropertyMessage("DRDA_SQLException.S", string);
    }

    private void wrapSQLWarning(String string) throws Exception {
        this.consolePropertyMessage("DRDA_SQLWarning.I", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getPropertyValues() {
        Properties properties = new Properties();
        properties.put("derby.drda.portNumber", new Integer(this.portNumber).toString());
        properties.put("derby.drda.host", this.hostArg);
        properties.put("derby.drda.keepAlive", new Boolean(this.keepAlive).toString());
        String string = this.getTraceDirectory();
        if (string != null) {
            properties.put("derby.drda.traceDirectory", string);
        }
        properties.put("derby.drda.traceAll", new Boolean(this.getTraceAll()).toString());
        properties.put("derby.drda.minThreads", new Integer(this.getMinThreads()).toString());
        properties.put("derby.drda.maxThreads", new Integer(this.getMaxThreads()).toString());
        properties.put("derby.drda.timeSlice", new Integer(this.getTimeSlice()).toString());
        properties.put("derby.drda.timeSlice", new Integer(this.getTimeSlice()).toString());
        properties.put("derby.drda.logConnections", new Boolean(this.getLogConnections()).toString());
        String string2 = PropertyUtil.getSystemProperty("derby.drda.startNetworkServer");
        if (string2 != null && string2.equals("")) {
            string2 = "false";
        }
        properties.put("derby.drda.startNetworkServer", string2 == null ? "false" : string2);
        if (this.getSecurityMechanism() != -1) {
            properties.put("derby.drda.securityMechanism", this.getStringValueForSecMec(this.getSecurityMechanism()));
        }
        if (!this.getTraceAll()) {
            Hashtable hashtable = this.sessionTable;
            synchronized (hashtable) {
                Enumeration enumeration = this.sessionTable.elements();
                while (enumeration.hasMoreElements()) {
                    Session session = (Session)enumeration.nextElement();
                    if (!session.isTraceOn()) continue;
                    properties.put("derby.drda.trace." + session.getConnNum(), "true");
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSession(Socket socket) throws Exception {
        boolean bl;
        int n = ++this.connNum;
        if (this.getLogConnections()) {
            this.consolePropertyMessage("DRDA_ConnNumber.I", Integer.toString(n));
        }
        Session session = new Session(n, socket, this.getTraceDirectory(), this.getTraceAll());
        this.sessionTable.put(new Integer(n), session);
        Object object = this.runQueue;
        synchronized (object) {
            bl = this.runQueue.size() < this.freeThreads;
        }
        object = null;
        if (!bl) {
            Object object2 = this.threadsSync;
            synchronized (object2) {
                if (this.maxThreads == 0 || this.threadList.size() < this.maxThreads) {
                    object = new DRDAConnThread(session, this, this.getTimeSlice(), this.getLogConnections());
                    this.threadList.add(object);
                    ((Thread)object).start();
                }
            }
        }
        if (object == null) {
            this.runQueueAdd(session);
        }
    }

    void removeThread(DRDAConnThread dRDAConnThread) {
        this.threadList.remove(dRDAConnThread);
    }

    protected Object getShutdownSync() {
        return this.shutdownSync;
    }

    protected boolean getShutdown() {
        return this.shutdown;
    }

    public String buildRuntimeInfo(LocalizedResource localizedResource) {
        int n;
        String string = localizedResource.getTextMessage("DRDA_RuntimeInfoBanner.I") + "\n";
        int n2 = 0;
        string = string + localizedResource.getTextMessage("DRDA_RuntimeInfoSessionBanner.I") + "\n";
        for (n = 0; n < this.threadList.size(); ++n) {
            String string2 = ((DRDAConnThread)this.threadList.get(n)).buildRuntimeInfo("", localizedResource);
            if (string2.equals("")) continue;
            ++n2;
            string = string + string2 + "\n";
        }
        n = 0;
        for (int i = 0; i < this.runQueue.size(); ++i) {
            string = string + ((Session)this.runQueue.get(i)).buildRuntimeInfo("", localizedResource);
            ++n;
        }
        string = string + "-------------------------------------------------------------\n";
        string = string + localizedResource.getTextMessage("DRDA_RuntimeInfoNumThreads.I") + this.threadList.size() + "\n";
        string = string + localizedResource.getTextMessage("DRDA_RuntimeInfoNumActiveSessions.I") + n2 + "\n";
        string = string + localizedResource.getTextMessage("DRDA_RuntimeInfoNumWaitingSessions.I") + n + "\n\n";
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        string = string + localizedResource.getTextMessage("DRDA_RuntimeInfoTotalMemory.I") + l + "\t";
        string = string + localizedResource.getTextMessage("DRDA_RuntimeInfoFreeMemory.I") + l2 + "\n\n";
        return string;
    }

    protected void setClientLocale(String string) {
        this.clientLocale = string;
    }

    private ProductVersionHolder getNetProductVersionHolder() throws Exception {
        ProductVersionHolder productVersionHolder = null;
        try {
            productVersionHolder = (ProductVersionHolder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException, IOException {
                    InputStream inputStream = this.getClass().getResourceAsStream("/org/apache/derby/info/net.properties");
                    return ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            this.consolePropertyMessage("DRDA_ProductVersionReadError.S", exception.getMessage());
        }
        return productVersionHolder;
    }

    private String getFormattedTimestamp() {
        long l = System.currentTimeMillis();
        return CheapDateFormatter.formatDate(l);
    }

    static {
        MGR_LEVELS = new int[]{7, 4, 0, 0, 5, 0, 7, 0, 7, 7, 0, 0, 7};
        SUPPORTS_EUSRIDPWD = false;
        try {
            new DecryptionManager();
            SUPPORTS_EUSRIDPWD = true;
        }
        catch (Exception exception) {
            SUPPORTS_EUSRIDPWD = false;
        }
    }
}

