/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.config;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.ListUtil;
import com.sun.appserv.management.util.misc.TypeCast;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.AttributeList;
import org.glassfish.admin.amx.config.AttrInfo;
import org.glassfish.admin.amx.config.ConfiguredHelper;
import org.glassfish.admin.amx.config.ConfiguredHelperRegistry;
import org.glassfish.admin.amx.config.NameMappingHelper;
import org.glassfish.admin.amx.mbean.DelegateBase;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.WriteableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegateToConfigBeanDelegate
extends DelegateBase {
    private final ConfigBean mConfigBean;
    private final NameMappingHelper mNameMappingHelper;
    private final ConfiguredHelper mConfiguredHelper;

    private static void debug(String s) {
        System.out.println(s);
    }

    public DelegateToConfigBeanDelegate(ConfigBean configBean) {
        super("DelegateToConfigBeanDelegate." + configBean.toString());
        this.mConfigBean = configBean;
        this.mNameMappingHelper = new NameMappingHelper(configBean);
        this.mConfiguredHelper = ConfiguredHelperRegistry.getInstance(configBean.getProxyType());
    }

    void initNameMapping(String[] amxAttrNames) {
        this.mNameMappingHelper.initNameMapping(amxAttrNames);
    }

    @Override
    public boolean supportsAttribute(String amxAttrName) {
        String xmlName = this.mNameMappingHelper.getXMLName(amxAttrName);
        return xmlName != null;
    }

    public AttrInfo getAttrInfo_AMX(String attrName) {
        return this.mNameMappingHelper.getAttrInfo_AMX(attrName);
    }

    public ConfigBean getConfigBean() {
        return this.mConfigBean;
    }

    @Override
    public final Object getAttribute(String amxName) {
        Object[] result = null;
        ConfiguredHelper.Info info = this.mConfiguredHelper.getInfo(amxName);
        if (info == null) {
            throw new IllegalArgumentException(amxName);
        }
        String xmlName = info.getXMLName();
        if (info instanceof ConfiguredHelper.AttributeInfo) {
            result = this.mConfigBean.rawAttribute(xmlName);
        } else if (info.isString()) {
            List leaf = this.mConfigBean.leafElements(xmlName);
            if (leaf != null) {
                try {
                    result = (String)leaf.get(0);
                }
                catch (Exception e) {}
            }
        } else if (info.getReturnType() == List.class) {
            List leaf = this.mConfigBean.leafElements(xmlName);
            if (leaf != null) {
                List elems = TypeCast.checkList((List)leaf, String.class);
                result = CollectionUtil.toArray((Collection)elems, String.class);
            }
        } else {
            throw new IllegalArgumentException("Unsupported return type: " + info.getReturnType().getName());
        }
        return result;
    }

    private Map<String, PropertyChangeEvent> makePropertyChangeEventMap(List<PropertyChangeEvent> changeEvents) {
        HashMap<String, PropertyChangeEvent> m = new HashMap<String, PropertyChangeEvent>();
        for (PropertyChangeEvent changeEvent : changeEvents) {
            if (changeEvent.getPropertyName() == null) {
                throw new IllegalArgumentException("PropertyChangeEvent property names must be specified");
            }
            m.put(changeEvent.getPropertyName(), changeEvent);
        }
        return m;
    }

    private void joinTransaction(Transaction t, WriteableView writeable) throws TransactionFailure {
        if (!writeable.join(t)) {
            t.rollback();
            throw new TransactionFailure("Cannot enlist " + writeable.getProxyType() + " in transaction", null);
        }
    }

    private static void commit(Transaction t) throws TransactionFailure {
        try {
            t.commit();
        }
        catch (RetryableException e) {
            DelegateToConfigBeanDelegate.debug("Retryable...");
            t.rollback();
            throw new TransactionFailure(e.getMessage(), (Throwable)e);
        }
        catch (TransactionFailure e) {
            DelegateToConfigBeanDelegate.debug("failure, not retryable...");
            t.rollback();
            throw e;
        }
    }

    static <T extends ConfigBeanProxy> WriteableView getWriteableView(T s, ConfigBean sourceBean) throws TransactionFailure {
        WriteableView f = new WriteableView(s);
        if (sourceBean.getLock().tryLock()) {
            return f;
        }
        throw new TransactionFailure("Config bean already locked " + sourceBean, null);
    }

    private static Type getCollectionGenericType() {
        try {
            return ConfigSupport.class.getDeclaredMethod("defaultPropertyValue", null).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException();
        }
    }

    private static boolean isCollectionCmd(String s) {
        return s != null && (s.equals("add") || s.equals("remove") || s.equals("replace"));
    }

    public String[] getAnonymousElementList(String elementName) {
        return (String[])this.getAttribute(elementName);
    }

    public String[] modifyAnonymousElementList(String elementName, String cmd, String[] values) {
        this.getAnonymousElementList(elementName);
        String xmlName = this.mNameMappingHelper.getXMLName(elementName, true);
        try {
            ModifyCollectionApplyer mca = new ModifyCollectionApplyer(this.mConfigBean, xmlName, cmd, values);
            mca.apply();
            return ListUtil.toStringArray((List)mca.mResult);
        }
        catch (TransactionFailure e) {
            throw new RuntimeException("Could not modify element collection " + elementName, e);
        }
    }

    private List<String> handleCollection(WriteableView writeable, ConfigModel.Property prop, String cmd, List<String> argValues) {
        if (!DelegateToConfigBeanDelegate.isCollectionCmd(cmd)) {
            throw new IllegalArgumentException("" + cmd);
        }
        Object o = writeable.getter(prop, DelegateToConfigBeanDelegate.getCollectionGenericType());
        List masterList = TypeCast.checkList((List)TypeCast.asList((Object)o), String.class);
        if (cmd.equals("replace")) {
            masterList.retainAll(argValues);
            for (String s : argValues) {
                if (masterList.contains(s)) continue;
                masterList.add(s);
            }
        } else if (cmd.equals("remove")) {
            masterList.removeAll(argValues);
        } else if (cmd.equals("add")) {
            ArrayList<String> temp = new ArrayList<String>(argValues);
            temp.removeAll(masterList);
            masterList.addAll(temp);
        } else {
            throw new IllegalArgumentException(cmd);
        }
        return new ArrayList<String>(masterList);
    }

    private void apply(ConfigBean cb, Map<String, Object> changes) throws TransactionFailure {
        MakeChangesApplyer mca = new MakeChangesApplyer(this.mConfigBean, changes);
        mca.apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeList setAttributes(AttributeList attrsIn, Map<String, Object> oldValues) {
        oldValues.clear();
        Map amxAttrs = JMXUtil.attributeListToValueMap((AttributeList)attrsIn);
        HashMap<String, Object> notMatched = new HashMap<String, Object>();
        Map<String, Object> xmlAttrs = this.mNameMappingHelper.mapNamesAndValues(amxAttrs, notMatched);
        if (notMatched.keySet().size() != 0) {
            DelegateToConfigBeanDelegate.debug("setAttributes: failed to map these AMX attributes: {" + CollectionUtil.toString(notMatched.keySet()) + "}");
        }
        AttributeList successfulAttrs = new AttributeList();
        if (xmlAttrs.size() != 0) {
            DelegateToConfigBeanDelegate.debug("DelegateToConfigBeanDelegate.setAttributes(): " + attrsIn.size() + " attributes: {" + CollectionUtil.toString(amxAttrs.keySet()) + "} mapped to xml names {" + CollectionUtil.toString(xmlAttrs.keySet()) + "}");
            MyTransactionListener myListener = new MyTransactionListener(this.mConfigBean);
            Transactions.get().addTransactionsListener((TransactionListener)myListener);
            try {
                MakeChangesApplyer mca = new MakeChangesApplyer(this.mConfigBean, xmlAttrs);
                mca.apply();
                successfulAttrs.addAll(attrsIn);
            }
            catch (TransactionFailure tf) {
                DelegateToConfigBeanDelegate.debug(ExceptionUtil.toString((Throwable)tf));
            }
            finally {
                Transactions.get().waitForDrain();
                Transactions.get().removeTransactionsListener((TransactionListener)myListener);
            }
        }
        return successfulAttrs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MakeChangesApplyer
    extends Applyer {
        private final Map<String, Object> mChanges;

        public MakeChangesApplyer(ConfigBean cb, Map<String, Object> changes) throws TransactionFailure {
            super(cb);
            this.mChanges = changes;
        }

        @Override
        protected void makeChanges() throws TransactionFailure {
            for (String xmlName : this.mChanges.keySet()) {
                Object value = this.mChanges.get(xmlName);
                ConfigModel.Property prop = DelegateToConfigBeanDelegate.this.mNameMappingHelper.getConfigModel_Property(xmlName);
                if (prop.isCollection()) {
                    List results = DelegateToConfigBeanDelegate.this.handleCollection(this.mWriteable, prop, "replace", ListUtil.asStringList((Object)value));
                    continue;
                }
                if (value == null || value instanceof String) {
                    this.mWriteable.setter(prop, value, String.class);
                    continue;
                }
                throw new TransactionFailure("Illegal data type for attribute " + xmlName + ": " + value.getClass().getName());
            }
        }
    }

    private final class ModifyCollectionApplyer
    extends Applyer {
        private volatile List<String> mResult;
        private final String mElementName;
        private final String mCmd;
        private final String[] mValues;

        public ModifyCollectionApplyer(ConfigBean cb, String elementName, String cmd, String[] values) throws TransactionFailure {
            super(cb);
            this.mElementName = elementName;
            this.mCmd = cmd;
            this.mValues = values;
            this.mResult = null;
        }

        protected void makeChanges() throws TransactionFailure {
            ConfigModel.Property prop = DelegateToConfigBeanDelegate.this.mNameMappingHelper.getConfigModel_Property(this.mElementName);
            this.mResult = DelegateToConfigBeanDelegate.this.handleCollection(this.mWriteable, prop, this.mCmd, ListUtil.asStringList((Object)this.mValues));
        }
    }

    private class Applyer {
        final Transaction mTransaction;
        final ConfigBean mConfigBean;
        final WriteableView mWriteable;

        public Applyer(ConfigBean cb) throws TransactionFailure {
            this(cb, new Transaction());
        }

        public Applyer(ConfigBean cb, Transaction t) throws TransactionFailure {
            this.mConfigBean = cb;
            this.mTransaction = t;
            ConfigBeanProxy readableView = cb.getProxy(cb.getProxyType());
            this.mWriteable = DelegateToConfigBeanDelegate.getWriteableView(readableView, cb);
        }

        protected void makeChanges() throws TransactionFailure {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void apply() throws TransactionFailure {
            try {
                DelegateToConfigBeanDelegate.this.joinTransaction(this.mTransaction, this.mWriteable);
                this.makeChanges();
                DelegateToConfigBeanDelegate.commit(this.mTransaction);
            }
            finally {
                this.mConfigBean.getLock().unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MyTransactionListener
    implements TransactionListener {
        private final List<PropertyChangeEvent> mChangeEvents = new ArrayList<PropertyChangeEvent>();
        private final ConfigBean mTarget;

        MyTransactionListener(ConfigBean target) {
            this.mTarget = target;
        }

        public void transactionCommited(List<PropertyChangeEvent> changes) {
            for (PropertyChangeEvent event : changes) {
                Dom dom;
                Object source = event.getSource();
                if (!(source instanceof ConfigBeanProxy) || !((dom = Dom.unwrap((ConfigBeanProxy)((ConfigBeanProxy)source))) instanceof ConfigBean) || this.mTarget != (ConfigBean)dom) continue;
                this.mChangeEvents.add(event);
            }
        }

        public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
        }

        List<PropertyChangeEvent> getChangeEvents() {
            return this.mChangeEvents;
        }
    }
}

