/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.config;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.ListUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.admin.amx.config.AttrInfo;
import org.glassfish.admin.amx.config.ConfiguredHelper;
import org.glassfish.admin.amx.config.ConfiguredHelperRegistry;
import org.glassfish.admin.amx.config.NameMapping;
import org.glassfish.admin.amx.config.NameMappingRegistry;
import org.glassfish.admin.amx.util.AMXConfigInfoResolver;
import org.glassfish.api.amx.AMXConfigInfo;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NameMappingHelper {
    private final String mJ2EEType;
    private final ConfigBean mConfigBean;

    private static void debug(String s) {
        System.out.println(s);
    }

    public NameMappingHelper(ConfigBean configBean) {
        this.mJ2EEType = NameMappingHelper.getAMXConfigInfoResolver(configBean).j2eeType();
        this.mConfigBean = configBean;
    }

    void initNameMapping(String[] amxAttrNames) {
        NameMapping mapping = NameMappingRegistry.getInstance(this.mJ2EEType);
        if (mapping == null) {
            ConfiguredHelper helper;
            String hint;
            Set xmlAttrNames = this.mConfigBean.getAttributeNames();
            Set xmlLeafNames = GSetUtil.newStringSet((String[])ConfigSupport.getElementsNames((ConfigBean)this.mConfigBean));
            HashSet<String> xmlNames = new HashSet<String>(xmlAttrNames);
            xmlNames.addAll(xmlLeafNames);
            mapping = new NameMapping(this.mJ2EEType);
            Set amxNames = GSetUtil.newStringSet((String[])amxAttrNames);
            if (amxNames.contains("Name") && (hint = (helper = ConfiguredHelperRegistry.getInstance(this.mConfigBean.getProxyType())).getNameHint()) != null && hint.length() != 0) {
                amxNames.remove("Name");
                mapping.pairNames("Name", hint);
            }
            for (String amxAttrName : amxNames) {
                String xmlName = mapping.pairNames(amxAttrName, xmlNames);
                if (xmlName == null) continue;
                xmlNames.remove(xmlName);
            }
            NameMappingRegistry.addInstance(mapping);
        }
    }

    public ConfigBean getConfigBean() {
        return this.mConfigBean;
    }

    public NameMapping getNameMapping() {
        return NameMappingRegistry.getInstance(this.mJ2EEType);
    }

    public static AMXConfigInfoResolver getAMXConfigInfoResolver(ConfigBean cb) {
        Class proxyClass = cb.getProxyType();
        AMXConfigInfo amxConfigInfo = proxyClass.getAnnotation(AMXConfigInfo.class);
        if (amxConfigInfo == null) {
            throw new IllegalArgumentException();
        }
        return new AMXConfigInfoResolver(amxConfigInfo);
    }

    public AMXConfigInfoResolver getAMXConfigInfoResolver() {
        return NameMappingHelper.getAMXConfigInfoResolver(this.mConfigBean);
    }

    protected ConfigModel.Property getConfigModel_Property(String xmlName) {
        return NameMappingHelper.getConfigModel_Property(this.mConfigBean, xmlName);
    }

    public static ConfigModel.Property getConfigModel_Property(ConfigBean cb, String xmlName) {
        ConfigModel.Property cmp = cb.model.findIgnoreCase(xmlName);
        if (cmp == null) {
            throw new IllegalArgumentException("Illegal name: " + xmlName);
        }
        return cmp;
    }

    public boolean isLeaf(String xmlName) {
        return this.getConfigModel_Property(xmlName).isLeaf();
    }

    public boolean isCollection(String xmlName) {
        return this.getConfigModel_Property(xmlName).isCollection();
    }

    public AttrInfo getAttrInfo_AMX(String amxName) {
        String xmlName = this.getXMLName(amxName, true);
        boolean isLeaf = this.isLeaf(xmlName);
        boolean isCollection = this.isCollection(xmlName);
        return new AttrInfo(amxName, xmlName, isLeaf, isCollection);
    }

    public final String getXMLName(String amxName) {
        return this.getXMLName(amxName, false);
    }

    public final String getXMLName(String amxName, boolean friendlyMatching) {
        String xmlName = this.getNameMapping().getXMLName(amxName, friendlyMatching);
        return xmlName;
    }

    public static Object asStringType(Object o) {
        Object result = o;
        if (o != null) {
            if (o == null || o instanceof String) {
                result = o;
            } else if (o instanceof Boolean || o instanceof Integer || o instanceof Long) {
                result = "" + o;
            } else if (!(o instanceof String[])) {
                throw new IllegalArgumentException("Illegal value: " + o + " of class " + o.getClass().getName());
            }
        }
        return result;
    }

    public Map<String, Object> mapNamesAndValues(Map<String, Object> amxAttrs, Map<String, Object> noMatch) {
        HashMap<String, Object> xmlAttrs = new HashMap<String, Object>();
        for (String amxAttrName : amxAttrs.keySet()) {
            Object valueIn = amxAttrs.get(amxAttrName);
            String xmlName = this.getXMLName(amxAttrName);
            if (xmlName != null) {
                Object value = NameMappingHelper.asStringType(valueIn);
                if (value != valueIn) {
                    NameMappingHelper.debug("Attribute " + amxAttrName + " auto converted from " + valueIn.getClass().getName() + " to " + value.getClass().getName());
                }
                if (valueIn == null || value instanceof String) {
                    xmlAttrs.put(xmlName, (String)value);
                } else if (this.isCollection(xmlName)) {
                    if (valueIn instanceof String[] || valueIn instanceof List) {
                        xmlAttrs.put(xmlName, ListUtil.asStringList((Object)valueIn));
                    } else {
                        noMatch.put(amxAttrName, valueIn);
                    }
                } else {
                    noMatch.put(amxAttrName, valueIn);
                }
                NameMappingHelper.debug("Attribute " + amxAttrName + "<=>" + xmlName + " is of class " + (value == null ? null : value.getClass().getName()));
                continue;
            }
            NameMappingHelper.debug("WARNING: setAttributes(): no xmlName match found for AMX attribute: " + amxAttrName);
            noMatch.put(amxAttrName, valueIn);
        }
        return xmlAttrs;
    }
}

