/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.logging.LogDomains;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.server.ServerEnvironmentImpl;

public final class ImplUtil {
    private static void debug(String s) {
        System.out.println(s);
    }

    public static Logger getLogger() {
        return LogDomains.getLogger(ServerEnvironmentImpl.class, (String)"javax.enterprise.system.tools.admin");
    }

    public static void unregisterAMXMBeans(AMX top) {
        if (top == null) {
            throw new IllegalArgumentException();
        }
        MBeanServer mbeanServer = (MBeanServer)Util.getExtra((AMX)top).getConnectionSource().getExistingMBeanServerConnection();
        if (top instanceof Container) {
            Set all = ((Container)top).getContaineeSet();
            for (AMX amx : all) {
                ImplUtil.unregisterAMXMBeans(amx);
            }
        }
        ImplUtil.unregisterOneMBean(mbeanServer, Util.getObjectName((AMX)top));
    }

    public static void unregisterAMXMBeans(MBeanServer mbs, ObjectName objectName) {
        ImplUtil.getLogger().info("Unregister MBean hierarchy for: " + objectName);
        ImplUtil.unregisterAMXMBeans(ProxyFactory.getInstance((MBeanServer)mbs).getProxy(objectName));
    }

    public static boolean unregisterOneMBean(MBeanServer mbeanServer, ObjectName objectName) {
        boolean success = false;
        try {
            ImplUtil.getLogger().fine("UNREGISTER MBEAN: " + objectName);
            if (mbeanServer.isRegistered(objectName)) {
                mbeanServer.unregisterMBean(objectName);
            }
        }
        catch (JMException e) {
            ImplUtil.debug("unregisterOneMBean: " + objectName + " FAILED: " + ExceptionUtil.toString((Throwable)e));
        }
        return success;
    }
}

