/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientJarMakerUtils {
    private static final Logger logger = DeploymentLogger.get();

    ClientJarMakerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void populateStubs(WritableArchive target, ZipItem[] stubs) throws IOException {
        HashSet<String> elements = new HashSet<String>();
        for (ZipItem item : stubs) {
            if (elements.contains(item.getName())) continue;
            elements.add(item.getName());
            OutputStream os = null;
            InputStream is = null;
            try {
                os = target.putNextEntry(item.getName());
                is = new BufferedInputStream(new FileInputStream(item.getFile()));
                ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)os);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    target.closeEntry();
                }
            }
        }
    }

    static void populateModuleJar(ReadableArchive original, ReadableArchive generated, WritableArchive target) throws IOException {
        ArrayList<String> libraries = new ArrayList<String>();
        File appArchive = new File(original.getURI().getSchemeSpecificPart());
        URI uri = appArchive.toURI();
        URI parentURI = null;
        try {
            parentURI = ClientJarMakerUtils.getParent(uri);
        }
        catch (URISyntaxException ex) {
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
        ClientJarMakerUtils.populateModuleJar(original, generated, target, libraries, parentURI, parentURI);
        ClientJarMakerUtils.addClassPathElementsFromManifestClassPaths(appArchive, libraries);
        ClientJarMakerUtils.copyLibraries(original, target, libraries);
    }

    static void populateModuleJar(ReadableArchive original, ReadableArchive generated, WritableArchive target, List<String> libraries, URI containingAppURI, URI moduleParentURI) throws IOException {
        String excludeFileName = target.getURI().getSchemeSpecificPart().substring(target.getURI().getSchemeSpecificPart().lastIndexOf(File.separatorChar) + 1);
        HashSet<String> excludeList = new HashSet<String>();
        excludeList.add(excludeFileName);
        if (generated != null) {
            ClientJarMakerUtils.copyArchive(generated, target, excludeList);
        }
        ClientJarMakerUtils.copyArchive(original, target, excludeList);
        ClientJarMakerUtils.copy(original, target, "META-INF/MANIFEST.MF");
        Manifest mf = original.getManifest();
        ClientJarMakerUtils.addClassPathElementsFromManifest(mf, containingAppURI, moduleParentURI, libraries);
    }

    static void copyDeploymentDescriptors(Archivist archivist, ReadableArchive original, ReadableArchive generated, WritableArchive target) throws IOException {
        ReadableArchive source = generated == null ? original : generated;
        ClientJarMakerUtils.copy(source, target, archivist.getStandardDDFile().getDeploymentDescriptorPath());
        ClientJarMakerUtils.copy(source, target, archivist.getConfigurationDDFile().getDeploymentDescriptorPath());
    }

    static List<String> getLibraryEntries(Application app, ReadableArchive appSource) throws IOException {
        boolean isFine = logger.isLoggable(Level.FINE);
        File appArchive = new File(appSource.getURI().getSchemeSpecificPart());
        Vector<String> libraries = new Vector<String>();
        String libraryDirectoryPath = app.getLibraryDirectory();
        File libraryDirectory = null;
        if (libraryDirectoryPath != null) {
            libraryDirectory = new File(appArchive, libraryDirectoryPath);
            ClientJarMakerUtils.addJARClassPathElementsFromDirectory(libraryDirectory, appArchive, libraries);
        }
        if (libraryDirectory == null || !libraryDirectory.equals(appArchive)) {
            ClientJarMakerUtils.addJARClassPathElementsFromDirectory(appArchive, appArchive, libraries);
        }
        if (DeploymentLogger.get().isLoggable(Level.FINEST)) {
            for (String lib : libraries) {
                DeploymentLogger.get().fine("Adding to the appclient jar, library [" + lib + "]");
            }
        }
        return libraries;
    }

    static void copyLibraries(ReadableArchive source, WritableArchive target, List<String> libraries) throws IOException {
        for (String library : libraries) {
            ClientJarMakerUtils.copy(source, target, library);
        }
    }

    private static void addJARClassPathElementsFromDirectory(File directory, File archiveRoot, Collection<String> classPathEntries) {
        boolean isFine = logger.isLoggable(Level.FINE);
        StringBuilder jarsAdded = null;
        URI relativeDirURI = null;
        String relativeDirURIPath = null;
        if (isFine) {
            jarsAdded = new StringBuilder();
            relativeDirURI = archiveRoot.toURI().relativize(directory.toURI());
            relativeDirURIPath = directory.equals(archiveRoot) ? "." : relativeDirURI.getPath();
        }
        if (directory.exists() && directory.isDirectory()) {
            for (File candidateJAR : directory.listFiles()) {
                if (!candidateJAR.getName().endsWith(".jar") || candidateJAR.isDirectory()) continue;
                URI jarRelativeURI = archiveRoot.toURI().relativize(candidateJAR.toURI());
                classPathEntries.add(jarRelativeURI.getPath());
                if (!isFine) continue;
                jarsAdded.append(relativeDirURI.relativize(jarRelativeURI)).append(" ");
            }
        }
        if (isFine) {
            logger.fine("Adding these JARs from directory " + relativeDirURIPath + " to app client JAR classpath: [" + jarsAdded.toString() + "]");
        }
    }

    static void addClassPathElementsFromManifestClassPaths(File appArchive, List<String> libraries) throws IOException {
        boolean isFine = logger.isLoggable(Level.FINE);
        URI appArchiveURI = appArchive.toURI();
        ListIterator<String> it = libraries.listIterator();
        while (it.hasNext()) {
            String entry = it.next();
            if (!entry.endsWith(".jar")) continue;
            StringBuilder elementsAdded = isFine ? new StringBuilder() : null;
            File jarFile = new File(appArchive, entry);
            if (!jarFile.exists()) {
                if (!isFine) continue;
                logger.fine("Skipping manifest Class-Path processing for non-existent library " + jarFile.getAbsolutePath());
                continue;
            }
            JarFile jar = new JarFile(jarFile);
            Manifest mf = jar.getManifest();
            List<String> classPathLibs = ClientJarMakerUtils.getClassPathElementsFromManifest(mf, appArchiveURI, appArchiveURI.resolve(jarFile.toURI()));
            for (String element : classPathLibs) {
                if (libraries.contains(element)) continue;
                it.add(element);
                if (!isFine) continue;
                elementsAdded.append(element).append(" ");
            }
            if (elementsAdded == null) continue;
            if (elementsAdded.length() > 0) {
                logger.fine("Added following entries from " + entry + " Class-Path to client JAR classpath: [ " + elementsAdded.toString() + "]");
                continue;
            }
            logger.fine("No Class-Path entries to add to client JAR classpath from manifest of " + entry);
        }
    }

    private static List<String> getClassPathElementsFromManifest(Manifest mf, URI appURI, URI referencingURI) {
        ArrayList<String> classPathLibs = new ArrayList<String>();
        if (mf == null) {
            return classPathLibs;
        }
        Attributes mainAttrs = mf.getMainAttributes();
        if (mainAttrs == null) {
            return classPathLibs;
        }
        String classPathString = mainAttrs.getValue(Attributes.Name.CLASS_PATH);
        if (classPathString == null || classPathString.length() == 0) {
            return classPathLibs;
        }
        for (String classPathElement : classPathString.split(" ")) {
            URI elementURI = appURI.relativize(referencingURI.resolve(classPathElement));
            classPathLibs.add(elementURI.toString());
        }
        return classPathLibs;
    }

    private static void addClassPathElementsFromManifest(Manifest mf, URI appURI, URI moduleParentURI, List<String> libraries) {
        for (String element : ClientJarMakerUtils.getClassPathElementsFromManifest(mf, appURI, moduleParentURI)) {
            libraries.add(element);
        }
    }

    static void copy(ReadableArchive source, WritableArchive target, String entryName) throws IOException {
        block22: {
            InputStream is = null;
            OutputStream os = null;
            try {
                is = source.getEntry(entryName);
                if (is != null) {
                    try {
                        os = target.putNextEntry(entryName);
                    }
                    catch (ZipException ze) {
                        IOException closeEntryIOException = null;
                        if (os != null) {
                            try {
                                target.closeEntry();
                            }
                            catch (IOException ioe) {
                                closeEntryIOException = ioe;
                            }
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (closeEntryIOException != null) {
                            throw closeEntryIOException;
                        }
                        return;
                    }
                    ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)os);
                    break block22;
                }
                Enumeration e = source.entries(entryName);
                while (e.hasMoreElements()) {
                    ClientJarMakerUtils.copy(source, target, (String)e.nextElement());
                }
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                IOException closeEntryIOException = null;
                if (os != null) {
                    try {
                        target.closeEntry();
                    }
                    catch (IOException ioe) {
                        closeEntryIOException = ioe;
                    }
                }
                if (is != null) {
                    is.close();
                }
                if (closeEntryIOException != null) {
                    throw closeEntryIOException;
                }
            }
        }
    }

    static URI getParent(URI uri) throws URISyntaxException {
        return ClientJarMakerUtils.getParent(uri.toString());
    }

    static URI getParent(String uriString) throws URISyntaxException {
        int endOfParentURI = uriString.lastIndexOf("/") + 1;
        String parentURIString = endOfParentURI != 0 ? uriString.substring(0, endOfParentURI) : "";
        URI parentURI = new URI(parentURIString);
        return parentURI;
    }

    private static void copyArchive(ReadableArchive source, WritableArchive target, Set excludeList) {
        Enumeration e = source.entries();
        while (e.hasMoreElements()) {
            String entryName = (String)String.class.cast(e.nextElement());
            if (excludeList.contains(entryName)) continue;
            try {
                ClientJarMakerUtils.copy(source, target, entryName);
            }
            catch (IOException ioe) {}
        }
    }
}

