/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.persistence.jpa.PersistenceUnitInfoImpl;
import org.glassfish.persistence.jpa.ProviderContainerContractInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAApplication
implements ApplicationContainer {
    Collection<PersistenceUnitDescriptor> referencedPus = new ArrayList<PersistenceUnitDescriptor>();
    ProviderContainerContractInfo providerContainerContractInfo;
    Collection<EntityManagerFactory> loadedEMFs = new ArrayList<EntityManagerFactory>();
    private static Logger logger = LogDomains.getLogger(JPAApplication.class, (String)"javax.enterprise.system.core.classloading");
    private static Map<String, String> integrationProperties;

    JPAApplication(Collection<PersistenceUnitDescriptor> allReferencedPus, ProviderContainerContractInfo providerContainerContractInfo) {
        this.referencedPus = allReferencedPus;
        this.providerContainerContractInfo = providerContainerContractInfo;
        this.setSystemPropertyToEnableDoPrivilegedInEclipseLink();
        this.loadAllPus();
    }

    private void setSystemPropertyToEnableDoPrivilegedInEclipseLink() {
        String PROPERTY_NAME = "eclipselink.security.usedoprivileged";
        if (System.getProperty("eclipselink.security.usedoprivileged") == null) {
            System.setProperty("eclipselink.security.usedoprivileged", String.valueOf(Boolean.TRUE));
        }
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean start(ApplicationContext startupContxt) {
        return true;
    }

    public boolean stop(ApplicationContext stopContext) {
        this.closeAllEMFs();
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    private void loadAllPus() {
        String applicationLocation = this.providerContainerContractInfo.getApplicationLocation();
        boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
        if (fineMsgLoggable) {
            logger.fine("Loading persistence units for application: " + applicationLocation);
        }
        for (PersistenceUnitDescriptor pu : this.referencedPus) {
            EntityManagerFactory emf = this.loadPU(pu);
            this.loadedEMFs.add(emf);
        }
        if (fineMsgLoggable) {
            logger.fine("Finished loading persistence units for application: " + applicationLocation);
        }
    }

    private EntityManagerFactory loadPU(PersistenceUnitDescriptor pud) {
        PersistenceProvider provider;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("loading pud " + pud.getPuRoot());
        }
        PersistenceUnitInfoImpl pInfo = new PersistenceUnitInfoImpl(pud, this.providerContainerContractInfo);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PersistenceInfo for this pud is :\n" + pInfo);
        }
        try {
            provider = (PersistenceProvider)PersistenceProvider.class.cast(((ClassLoader)ClassLoader.class.cast(this.providerContainerContractInfo.getClassLoader())).loadClass(pInfo.getPersistenceProviderClassName()).newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)pInfo, integrationProperties);
        logger.logp(Level.FINE, "JPAApplication", "loadPU", "emf = {0}", emf);
        RootDeploymentDescriptor rootDD = pud.getParent().getParent();
        if (rootDD.isApplication()) {
            ((Application)Application.class.cast(rootDD)).addEntityManagerFactory(pInfo.getPersistenceUnitName(), pud.getPuRoot(), emf);
        } else {
            ((BundleDescriptor)BundleDescriptor.class.cast(rootDD)).addEntityManagerFactory(pInfo.getPersistenceUnitName(), emf);
        }
        return emf;
    }

    private void closeAllEMFs() {
        String applicationLocation = this.providerContainerContractInfo.getApplicationLocation();
        boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
        if (fineMsgLoggable) {
            logger.fine("Unloading persistence units for application: " + applicationLocation);
            logger.logp(Level.FINE, "JPAApplication", "closeEMFs", "loadedEMFs.size() = {0}", this.loadedEMFs.size());
        }
        for (EntityManagerFactory emf : this.loadedEMFs) {
            try {
                logger.logp(Level.FINE, "JPAApplication", "closeEMFs", "emf = {0}", emf);
                emf.close();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if (fineMsgLoggable) {
            logger.fine("Finished unloading persistence units for application: " + applicationLocation);
        }
    }

    static {
        HashMap<String, String> props = new HashMap<String, String>();
        String ECLIPSELINK_SERVER_PLATFORM_CLASS_NAME_PROPERTY = "eclipselink.target-server";
        props.put("eclipselink.target-server", System.getProperty("eclipselink.target-server", "SunAS9"));
        String TOPLINK_SERVER_PLATFORM_CLASS_NAME_PROPERTY = "toplink.target-server";
        props.put("toplink.target-server", System.getProperty("toplink.target-server", "SunAS9"));
        String HIBERNATE_TRANSACTION_MANAGER_LOOKUP_CLASS_PROPERTY = "hibernate.transaction.manager_lookup_class";
        props.put("hibernate.transaction.manager_lookup_class", System.getProperty("hibernate.transaction.manager_lookup_class", "org.hibernate.transaction.SunONETransactionManagerLookup"));
        integrationProperties = Collections.unmodifiableMap(props);
    }
}

