/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ByteArrayCombinerStream;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.UnitOfWorkListener;

public abstract class Lob
implements UnitOfWorkListener {
    public static final int STRING = 2;
    public static final int ASCII_STREAM = 4;
    public static final int UNICODE_STREAM = 8;
    public static final int CHARACTER_STREAM = 16;
    public static final int BINARY_STREAM = 32;
    public static final int BINARY_STRING = 64;
    protected Agent agent_;
    protected int dataType_ = 0;
    protected long sqlLength_;
    protected boolean lengthObtained_;

    protected Lob(Agent agent) {
        this.agent_ = agent;
        this.lengthObtained_ = false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public long sqlLength() throws SqlException {
        this.checkForClosedConnection();
        return this.sqlLength_;
    }

    public void listenToUnitOfWork() {
        this.agent_.connection_.CommitAndRollbackListeners_.put(this, null);
    }

    public void completeLocalCommit(Iterator iterator) {
        iterator.remove();
    }

    public void completeLocalRollback(Iterator iterator) {
        iterator.remove();
    }

    public Agent getAgent() {
        return this.agent_;
    }

    void checkForClosedConnection() throws SqlException {
        if (this.agent_.connection_.isClosedX()) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08003.C.2"));
        }
        this.agent_.checkForDeferredExceptions();
    }

    void completeLocalRollback() {
    }

    void completeLocalCommit() {
    }

    protected InputStream materializeStream(InputStream inputStream, String string) throws SqlException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[] byArray = new byte[32768];
        int n = 0;
        int n2 = 0;
        try {
            do {
                if ((n2 = inputStream.read(byArray, 0, byArray.length)) == byArray.length) {
                    arrayList.add(byArray);
                    int n3 = n + 32768;
                    byArray = n3 < 0 || n3 == Integer.MAX_VALUE ? new byte[Integer.MAX_VALUE - n] : new byte[32768];
                }
                if (n2 <= 0) continue;
                n += n2;
            } while (n2 == 32768);
            if (inputStream.read() != -1) {
                throw new SqlException(null, new ClientMessageId("22003"), string);
            }
            if (n2 > 0) {
                arrayList.add(byArray);
            }
            byArray = null;
            this.sqlLength_ = n;
            this.lengthObtained_ = true;
            return new ByteArrayCombinerStream(arrayList, n);
        }
        catch (IOException iOException) {
            throw new SqlException(null, new ClientMessageId("XCL30.S"), (Object)string, (Throwable)iOException);
        }
    }
}

