/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExceptionUtil {
    public static final String MESSAGE_KEY = "MessageKey";
    public static final String CLASSNAME_KEY = "ClassnameKey";
    public static final String STACK_TRACE_KEY = "StackTraceKey";
    public static final String STACK_TRACE_STRING_KEY = "StackTraceStringKey";
    public static final String EXCEPTION_KEY = "ExceptionKey";
    public static final Set<String> OVER_THE_WIRE_PACKAGE_PREFIXES = GSetUtil.newUnmodifiableStringSet("java.", "javax.", "org.omg.");

    private ExceptionUtil() {
    }

    public static String getStackTrace() {
        return ExceptionUtil.toString(new Exception("STACK TRACE"));
    }

    public static String toString(Throwable t) {
        String SEP = System.getProperty("line.separator");
        Throwable rootCause = ExceptionUtil.getRootCause(t);
        return rootCause.getClass().getName() + ": " + StringUtil.quote(rootCause.getMessage()) + SEP + ExceptionUtil.getStackTrace(rootCause);
    }

    public static boolean isAcceptableOverTheWire(Throwable t) {
        boolean goodForOverTheWire = false;
        String classname = t.getClass().getName();
        for (String prefix : OVER_THE_WIRE_PACKAGE_PREFIXES) {
            if (!classname.startsWith(prefix)) continue;
            goodForOverTheWire = true;
            break;
        }
        return goodForOverTheWire;
    }

    public static Map<String, Object> toMap(Throwable t) {
        String msg;
        HashMap<String, Object> m = new HashMap<String, Object>();
        Throwable rootCause = ExceptionUtil.getRootCause(t);
        String classname = rootCause.getClass().getName();
        m.put(CLASSNAME_KEY, classname);
        if (ExceptionUtil.isAcceptableOverTheWire(rootCause)) {
            m.put(EXCEPTION_KEY, rootCause);
        }
        if ((msg = rootCause.getMessage()) == null || msg.length() == 0) {
            msg = classname;
        }
        m.put(MESSAGE_KEY, msg);
        m.put(STACK_TRACE_KEY, rootCause.getStackTrace());
        m.put(STACK_TRACE_STRING_KEY, ExceptionUtil.getStackTrace(rootCause));
        return m;
    }

    public static Throwable[] getCauses(Throwable start) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        boolean haveNonException = false;
        Throwable t = start;
        while (t != null) {
            Throwable temp;
            list.add(t);
            if (!(t instanceof Exception)) {
                haveNonException = true;
            }
            if ((temp = t.getCause()) == null) break;
            t = temp;
        }
        Throwable[] results = haveNonException ? new Throwable[list.size()] : new Exception[list.size()];
        list.toArray(results);
        return results;
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable[] causes = ExceptionUtil.getCauses(e);
        return causes[causes.length - 1];
    }

    public static String getStackTrace(Throwable t) {
        StringBuffer buf = new StringBuffer();
        StackTraceElement[] elems = t.getStackTrace();
        for (int i = 0; i < elems.length; ++i) {
            buf.append(elems[i]);
            buf.append("\n");
        }
        return buf.toString();
    }
}

