/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.server.HK2Dispatcher;
import com.sun.enterprise.v3.services.impl.AbstractAdapter;
import com.sun.grizzly.standalone.DynamicContentAdapter;
import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.buf.ByteChunk;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;

public class VsAdapter
extends AbstractAdapter
implements Adapter {
    private static final String RFC_2616_FORMAT = "EEE, d MMM yyyy HH:mm:ss z";
    private final String docRoot;
    private final VirtualServer vs;
    private final Set<String> hostsNames;
    private Map<String, Adapter> endpoints = new HashMap<String, Adapter>();
    private Map<Adapter, ApplicationContainer> apps = new HashMap<Adapter, ApplicationContainer>();
    private HK2Dispatcher dispatcher = new HK2Dispatcher();

    public VsAdapter(VirtualServer vs) {
        this.vs = vs;
        this.docRoot = this.getDocRoot(vs);
        this.hostsNames = new HashSet<String>(StringUtils.parseStringList((String)vs.getHosts(), (String)","));
    }

    public boolean handles(String serverName) {
        return this.hostsNames.contains(serverName);
    }

    public VirtualServer getVirtualServer() {
        return this.vs;
    }

    public String toString() {
        return "Virtual Server " + this.vs.getId() + " adapter ";
    }

    public void service(Request req, Response res) throws Exception {
        if (LogHelper.getDefaultLogger().isLoggable(Level.FINER)) {
            LogHelper.getDefaultLogger().finer("Received something on " + req.requestURI());
        }
        String requestURI = req.requestURI().toString();
        try {
            while (true) {
                Adapter dispatchTo = this.endpoints.get(requestURI);
                ApplicationContainer container = this.apps.get(dispatchTo);
                if (dispatchTo != null) {
                    ClassLoader cl = null;
                    if (container != null) {
                        cl = container.getClassLoader();
                    }
                    this.dispatcher.dispath(dispatchTo, cl, req, res);
                    if (res.getStatus() != 200) {
                        VsAdapter.sendError(res, "GlassFish v3 Error " + res.getStatus());
                    }
                    dispatchTo.afterService(req, res);
                    return;
                }
                if (!requestURI.equals("/")) {
                    if (requestURI.lastIndexOf("/") != -1) {
                        requestURI = requestURI.substring(0, requestURI.lastIndexOf("/"));
                    }
                } else {
                    File file = new File(this.docRoot, req.requestURI().getString());
                    if (file.exists()) {
                        this.serviceFile(req, res, file);
                    } else if (req.requestURI().toString().equals("/favicon.ico")) {
                        this.serviceFile(req, res, new File(this.docRoot, "/favicon.gif"));
                    } else {
                        LogHelper.getDefaultLogger().info("No adapter registered for : " + requestURI);
                        VsAdapter.sendError(res, "Glassfish v3 Error : NotFound : " + requestURI);
                    }
                    return;
                }
                if (requestURI.length() != 0) continue;
                requestURI = "/";
            }
        }
        finally {
            try {
                if (req.requestURI().toString() != null) {
                    req.action(ActionCode.ACTION_POST_REQUEST, null);
                }
            }
            catch (Throwable t) {
                LogHelper.getDefaultLogger().log(Level.WARNING, "VsAdapter", t);
            }
            res.finish();
        }
    }

    public void registerEndpoint(String contextRoot, Adapter endpointAdapter, ApplicationContainer container) {
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        this.endpoints.put(contextRoot, endpointAdapter);
        if (container != null) {
            this.apps.put(endpointAdapter, container);
        }
    }

    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) {
        if (this.apps.containsValue(app)) {
            this.endpoints.remove(contextRoot);
            this.apps.remove(app);
        }
    }

    private String getDocRoot(VirtualServer virtualServer) {
        String docRoot = virtualServer.getDocroot();
        if (docRoot == null) {
            return virtualServer.getPropertyValue("docroot");
        }
        return "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceFile(Request req, Response res, File file) throws IOException, FileNotFoundException {
        if (file.isDirectory()) {
            file = new File(file, "index.html");
        }
        if (VsAdapter.modifiedSince(req, file)) {
            res.setStatus(304);
            return;
        }
        Object handler = null;
        ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(handler.getClass().getClassLoader());
            DynamicContentAdapter adapter = (DynamicContentAdapter)DynamicContentAdapter.class.cast(handler);
            adapter.setRootFolder(this.docRoot);
            adapter.service(req, res);
            return;
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Exception while servicing " + file, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentCl);
        }
        String type = URLConnection.guessContentTypeFromName(file.getName());
        res.setStatus(200);
        res.setContentType(type);
        res.setContentLength((int)file.length());
        res.addHeader("Server", "GlassFish/v3");
        res.sendHeaders();
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] b = new byte[8192];
            ByteChunk chunk = new ByteChunk();
            int rd = 0;
            while ((rd = fis.read(b)) > 0) {
                chunk.setBytes(b, 0, rd);
                res.doWrite(chunk);
            }
        }
        finally {
            fis.close();
        }
        try {
            req.action(ActionCode.ACTION_POST_REQUEST, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        res.finish();
    }

    private static boolean modifiedSince(Request req, File file) {
        try {
            String since = req.getMimeHeaders().getHeader("If-Modified-Since");
            if (since == null) {
                return false;
            }
            Date date = new SimpleDateFormat(RFC_2616_FORMAT, Locale.US).parse(since);
            return date.getTime() > file.lastModified();
        }
        catch (ParseException e) {
            return false;
        }
    }
}

