/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.services.cache.CachedItem;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.GenericStatement;
import org.apache.derby.impl.sql.conn.CachedStatement;
import org.apache.derby.impl.sql.conn.GenericLanguageConnectionContext;
import org.apache.derby.vti.VTITemplate;

public final class StatementCache
extends VTITemplate {
    private int position = -1;
    private Vector data;
    private GenericPreparedStatement currentPs;
    private boolean wasNull;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("ID", 1, false, 36), EmbedResultSetMetaData.getResultColumnDescriptor("SCHEMANAME", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("SQL_TEXT", 12, false, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("UNICODE", -7, false), EmbedResultSetMetaData.getResultColumnDescriptor("VALID", -7, false), EmbedResultSetMetaData.getResultColumnDescriptor("COMPILED_AT", 93, true)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public static void emptyCache() throws SQLException {
        GenericLanguageConnectionContext genericLanguageConnectionContext = (GenericLanguageConnectionContext)ConnectionUtil.getCurrentLCC();
        genericLanguageConnectionContext.emptyCache();
    }

    public StatementCache() throws SQLException {
        GenericLanguageConnectionContext genericLanguageConnectionContext = (GenericLanguageConnectionContext)ConnectionUtil.getCurrentLCC();
        if (genericLanguageConnectionContext.statementCache != null) {
            Hashtable hashtable = (Hashtable)((Object)genericLanguageConnectionContext.statementCache);
            this.data = new Vector(hashtable.size());
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                CachedItem cachedItem = (CachedItem)enumeration.nextElement();
                CachedStatement cachedStatement = (CachedStatement)cachedItem.getEntry();
                GenericPreparedStatement genericPreparedStatement = cachedStatement.getPreparedStatement();
                this.data.addElement(genericPreparedStatement);
            }
        }
    }

    public boolean next() {
        if (this.data == null) {
            return false;
        }
        ++this.position;
        while (this.position < this.data.size()) {
            this.currentPs = (GenericPreparedStatement)this.data.elementAt(this.position);
            if (this.currentPs != null) {
                return true;
            }
            ++this.position;
        }
        this.data = null;
        return false;
    }

    public void close() {
        this.data = null;
        this.currentPs = null;
    }

    public String getString(int n) {
        this.wasNull = false;
        switch (n) {
            case 1: {
                return this.currentPs.getObjectName();
            }
            case 2: {
                return ((GenericStatement)this.currentPs.statement).getCompilationSchema();
            }
            case 3: {
                String string = this.currentPs.getSource();
                string = StringUtil.truncate(string, 32672);
                return string;
            }
        }
        return null;
    }

    public boolean getBoolean(int n) {
        this.wasNull = false;
        switch (n) {
            case 4: {
                return true;
            }
            case 5: {
                return this.currentPs.isValid();
            }
        }
        return false;
    }

    public Timestamp getTimestamp(int n) {
        Timestamp timestamp = this.currentPs.getEndCompileTimestamp();
        this.wasNull = timestamp == null;
        return timestamp;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public ResultSetMetaData getMetaData() {
        return metadata;
    }
}

