/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.io.WebDeploymentDescriptorFile;
import com.sun.enterprise.deployment.runtime.web.ClassLoader;
import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.web.jsp.JSPCompiler;
import org.glassfish.web.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebDeployer
extends JavaEEDeployer<WebContainer, WebApplication> {
    @Inject
    ServerContext sc;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    RequestDispatcher dispatcher;
    private static final String DEFAULT_WEB_XML = "default-web.xml";
    private static WebBundleDescriptor defaultWebXMLWbd = null;

    protected String getModuleType() {
        return "web";
    }

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{Application.class}, null);
    }

    protected WebBundleDescriptor getDefaultBundleDescriptor() {
        return this.getDefaultWebXMLBundleDescriptor();
    }

    protected Application parseModuleMetaData(DeploymentContext dc) throws Exception {
        Properties params;
        String contextRoot;
        Application app = super.parseModuleMetaData(dc);
        WebBundleDescriptor wbd = null;
        Set webDesc = app.getWebBundleDescriptors();
        Iterator iter = webDesc.iterator();
        if (iter.hasNext()) {
            wbd = (WebBundleDescriptor)iter.next();
        }
        if ((contextRoot = (params = dc.getCommandParameters()).getProperty("contextroot")) == null && "".equals(contextRoot = wbd.getContextRoot())) {
            contextRoot = null;
        }
        if (contextRoot == null) {
            contextRoot = params.getProperty("previous_contextroot");
        }
        if (contextRoot == null) {
            contextRoot = params.getProperty("name");
        }
        if (contextRoot == null) {
            contextRoot = dc.getSource().getName();
        }
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        wbd.setContextRoot(contextRoot);
        wbd.setName(params.getProperty("name"));
        dc.getProps().setProperty("context-root", contextRoot);
        return app;
    }

    private WebModuleConfig loadWebModuleConfig(DeploymentContext dc) {
        WebModuleConfig wmInfo = null;
        try {
            ReadableArchive source = dc.getSource();
            Properties params = dc.getCommandParameters();
            String virtualServers = params.getProperty("virtualservers");
            wmInfo = new WebModuleConfig();
            WebBundleDescriptor wbd = null;
            Application app = (Application)dc.getModuleMetaData(Application.class);
            Set webDesc = app.getWebBundleDescriptors();
            Iterator iter = webDesc.iterator();
            if (iter.hasNext()) {
                wbd = (WebBundleDescriptor)iter.next();
            }
            wmInfo.setDescriptor(wbd);
            wmInfo.setVirtualServers(virtualServers);
            wmInfo.setLocation(dc.getSourceDir());
            wmInfo.setObjectType(dc.getProps().getProperty("object-type"));
        }
        catch (Exception ex) {
            dc.getLogger().log(Level.WARNING, "loadWebModuleConfig", ex);
        }
        return wmInfo;
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        Properties params = dc.getCommandParameters();
        boolean precompileJSP = Boolean.parseBoolean(params.getProperty("precompilejsp"));
        if (precompileJSP) {
            this.runJSPC(dc);
        }
    }

    public WebApplication load(WebContainer container, DeploymentContext dc) {
        WebModuleConfig wmInfo = this.loadWebModuleConfig(dc);
        WebApplication webApp = new WebApplication(container, wmInfo, Boolean.parseBoolean(dc.getProps().getProperty("keepSessions")) ? dc.getProps() : null);
        if (dc.getProps().containsKey("libraries")) {
            webApp.setLibraries(dc.getProps().getProperty("libraries"));
        }
        return webApp;
    }

    public void unload(WebApplication webApplication, DeploymentContext dc) {
        if (webApplication.props != null && dc.getProps().get("ActionReportProperties") != null) {
            ((Properties)dc.getProps().get("ActionReportProperties")).putAll((Map<?, ?>)webApplication.props);
        }
    }

    public WebBundleDescriptor getDefaultWebXMLBundleDescriptor() {
        this.initDefaultWebXMLBundleDescriptor();
        WebBundleDescriptor defaultWebBundleDesc = new WebBundleDescriptor();
        if (defaultWebXMLWbd != null) {
            defaultWebBundleDesc.addWebBundleDescriptor(defaultWebXMLWbd);
        }
        return defaultWebBundleDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initDefaultWebXMLBundleDescriptor() {
        if (defaultWebXMLWbd != null) {
            return;
        }
        InputStream fis = null;
        try {
            URL defaultWebXml = this.getDefaultWebXML();
            if (defaultWebXml != null) {
                fis = defaultWebXml.openStream();
                WebDeploymentDescriptorFile wddf = new WebDeploymentDescriptorFile();
                wddf.setXMLValidation(false);
                defaultWebXMLWbd = (WebBundleDescriptor)wddf.read(fis);
            }
        }
        catch (Exception e) {
            LogDomains.getLogger(WebDeployer.class, (String)"javax.enterprise.system.container.web").warning("Error in parsing default-web.xml");
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected URL getDefaultWebXML() throws IOException {
        File file = new File(this.env.getConfigDirPath(), DEFAULT_WEB_XML);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return null;
    }

    void runJSPC(DeploymentContext dc) throws DeploymentException {
        WebBundleDescriptor wbd = (WebBundleDescriptor)((Application)dc.getModuleMetaData(Application.class)).getStandaloneBundleDescriptor();
        try {
            File outDir = dc.getScratchDir("jsp");
            File inDir = dc.getSourceDir();
            boolean delegate = true;
            ClassLoader clBean = wbd.getSunDescriptor().getClassLoader();
            if (clBean != null) {
                String value = clBean.getAttributeValue("Delegate");
                delegate = ConfigBeansUtilities.toBoolean((String)value);
            }
            StringBuilder classpath = new StringBuilder(super.getCommonClassPath());
            classpath.append(File.pathSeparatorChar);
            classpath.append(ASClassLoaderUtil.getWebModuleClassPath(this.sc.getDefaultHabitat(), wbd.getApplication().getName(), dc.getProps().getProperty("libraries")));
            JSPCompiler.compile(inDir, outDir, wbd, classpath.toString(), this.sc);
        }
        catch (DeploymentException de) {
            dc.getLogger().log(Level.SEVERE, "Error compiling JSP", de);
            throw de;
        }
    }
}

