/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.annotations.ProbeParam;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.TimeStats;
import org.glassfish.flashlight.statistics.factory.CounterFactory;
import org.glassfish.flashlight.statistics.factory.TimeStatsFactory;
import org.glassfish.web.admin.monitor.telemetry.HttpServiceTelemetryBootstrap;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServiceRequestTelemetry
implements PostConstruct {
    private Counter errorCount = CounterFactory.createCount((long[])new long[0]);
    private Counter error200Count = CounterFactory.createCount((long[])new long[0]);
    private Counter error2xxCount = CounterFactory.createCount((long[])new long[0]);
    private Counter error302Count = CounterFactory.createCount((long[])new long[0]);
    private Counter error304Count = CounterFactory.createCount((long[])new long[0]);
    private Counter error3xxCount = CounterFactory.createCount((long[])new long[0]);
    private Counter error400Count = CounterFactory.createCount((long[])new long[0]);
    private Counter error401Count = CounterFactory.createCount((long[])new long[0]);
    private Counter error403Count = CounterFactory.createCount((long[])new long[0]);
    private Counter error404Count = CounterFactory.createCount((long[])new long[0]);
    private Counter error4xxCount = CounterFactory.createCount((long[])new long[0]);
    private Counter error503Count = CounterFactory.createCount((long[])new long[0]);
    private Counter error5xxCount = CounterFactory.createCount((long[])new long[0]);
    private Counter errorOtherCount = CounterFactory.createCount((long[])new long[0]);
    private TreeNode webRequestNode = null;
    private TimeStats requestProcessTime = TimeStatsFactory.createTimeStatsMilli();
    private Collection<ProbeClientMethodHandle> handles;
    private Logger logger;
    private boolean isEnabled = true;
    private HttpService httpService = null;
    private String virtualServerName = null;
    private HashMap<String, Counter> errorMap = new HashMap();
    @Inject
    private static Domain domain;

    public HttpServiceRequestTelemetry(TreeNode parent, String vsName, Logger logger) {
        try {
            this.logger = logger;
            this.virtualServerName = vsName;
            this.webRequestNode = parent;
            Method m1 = this.requestProcessTime.getClass().getMethod("getMaximumTime", null);
            TreeNode maxTime = TreeNodeFactory.createMethodInvoker((String)"maxTime", (Object)this.requestProcessTime, (String)"request", (Method)m1);
            parent.addChild(maxTime);
            this.requestProcessTime.getCount();
            Method m2 = this.requestProcessTime.getClass().getMethod("getCount", null);
            TreeNode requestCount = TreeNodeFactory.createMethodInvoker((String)"requestCount", (Object)this.requestProcessTime, (String)"request", (Method)m2);
            parent.addChild(requestCount);
            Method m3 = this.requestProcessTime.getClass().getMethod("getTime", null);
            TreeNode processingTime = TreeNodeFactory.createMethodInvoker((String)"processingTime", (Object)this.requestProcessTime, (String)"request", (Method)m3);
            parent.addChild(processingTime);
            this.errorCount.setName("errorCount");
            parent.addChild((TreeNode)this.errorCount);
            this.error200Count.setName("count200-count");
            parent.addChild((TreeNode)this.error200Count);
            this.error2xxCount.setName("count2xx-count");
            parent.addChild((TreeNode)this.error2xxCount);
            this.error302Count.setName("count302-count");
            parent.addChild((TreeNode)this.error302Count);
            this.error304Count.setName("count304-count");
            parent.addChild((TreeNode)this.error304Count);
            this.error3xxCount.setName("count3xx-count");
            parent.addChild((TreeNode)this.error3xxCount);
            this.error400Count.setName("count400-count");
            parent.addChild((TreeNode)this.error400Count);
            this.error401Count.setName("count401-count");
            parent.addChild((TreeNode)this.error401Count);
            this.error403Count.setName("count403-count");
            parent.addChild((TreeNode)this.error403Count);
            this.error404Count.setName("count404-count");
            parent.addChild((TreeNode)this.error404Count);
            this.error4xxCount.setName("count4xx-count");
            parent.addChild((TreeNode)this.error4xxCount);
            this.error503Count.setName("count503-count");
            parent.addChild((TreeNode)this.error503Count);
            this.error5xxCount.setName("count5xx-count");
            parent.addChild((TreeNode)this.error5xxCount);
            this.errorOtherCount.setName("countother-count");
            parent.addChild((TreeNode)this.errorOtherCount);
            this.errorMap.put("200", this.error200Count);
            this.errorMap.put("2", this.error2xxCount);
            this.errorMap.put("302", this.error302Count);
            this.errorMap.put("304", this.error304Count);
            this.errorMap.put("3", this.error3xxCount);
            this.errorMap.put("400", this.error400Count);
            this.errorMap.put("401", this.error401Count);
            this.errorMap.put("403", this.error403Count);
            this.errorMap.put("404", this.error404Count);
            this.errorMap.put("4", this.error4xxCount);
            this.errorMap.put("503", this.error503Count);
            this.errorMap.put("5", this.error5xxCount);
            this.errorMap.put("9", this.errorOtherCount);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(HttpServiceRequestTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(HttpServiceRequestTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void postConstruct() {
    }

    @ProbeListener(value="web:request::requestStartEvent")
    public void requestStartEvent(@ProbeParam(value="request") HttpServletRequest request, @ProbeParam(value="response") HttpServletResponse response) {
        String vsName = HttpServiceTelemetryBootstrap.getVirtualServer(request.getServerName(), String.valueOf(request.getServerPort()));
        if (vsName != null && vsName.equals(this.virtualServerName)) {
            this.requestProcessTime.entry();
            this.logger.finest("[TM]requestStartEvent received - virtual-server = " + request.getServerName() + " : port = " + request.getServerPort());
        }
    }

    @ProbeListener(value="web:request::requestEndEvent")
    public void requestEndEvent(@ProbeParam(value="request") HttpServletRequest request, @ProbeParam(value="response") HttpServletResponse response, @ProbeParam(value="statusCode") int statusCode) {
        String vsName = HttpServiceTelemetryBootstrap.getVirtualServer(request.getServerName(), String.valueOf(request.getServerPort()));
        if (vsName != null && vsName.equals(this.virtualServerName)) {
            this.requestProcessTime.exit();
            this.incrementStatsCounter(statusCode);
            this.logger.finest("[TM]requestEndEvent received - virtual-server = " + request.getServerName() + ": application = " + request.getContextPath() + " : servlet = " + request.getServletPath() + " :Response code = " + statusCode + " :Response time = " + this.requestProcessTime.getTime());
        }
    }

    public long getProcessTime() {
        return this.requestProcessTime.getTotalTime() / this.requestProcessTime.getCount();
    }

    public void setProbeListenerHandles(Collection<ProbeClientMethodHandle> handles) {
        this.handles = handles;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void enableMonitoring(boolean flag) {
        if (this.isEnabled != flag) {
            for (ProbeClientMethodHandle handle : this.handles) {
                if (flag) {
                    handle.enable();
                    continue;
                }
                handle.disable();
            }
            this.webRequestNode.setEnabled(flag);
            this.isEnabled = flag;
        }
    }

    private void incrementStatsCounter(int statusCode) {
        Counter errorCounter = this.errorMap.get(Integer.toString(statusCode));
        if (errorCounter == null) {
            errorCounter = this.errorMap.get(Integer.toString(Math.round(statusCode / 100)));
        }
        if (errorCounter == null) {
            errorCounter = this.errorMap.get("9");
        }
        errorCounter.increment();
        if (statusCode > 400) {
            this.errorCount.increment();
        }
    }
}

