/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import java.util.Collection;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.provider.annotations.ProbeParam;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.factory.CounterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspStatsTelemetry {
    private Collection<ProbeClientMethodHandle> handles;
    private boolean webMonitoringEnabled;
    private String moduleName;
    private String vsName;
    private Logger logger;
    private boolean isEnabled = true;
    private TreeNode jspNode = null;
    private Counter activeJspsLoadedCount = CounterFactory.createCount((long[])new long[0]);
    private Counter maxJspsLoadedCount = CounterFactory.createCount((long[])new long[0]);
    private Counter totalJspsLoadedCount = CounterFactory.createCount((long[])new long[0]);

    public JspStatsTelemetry(TreeNode parent, String moduleName, String vsName, boolean webMonitoringEnabled, Logger logger) {
        this.jspNode = parent;
        this.logger = logger;
        this.moduleName = moduleName;
        this.vsName = vsName;
        this.activeJspsLoadedCount.setName("activeJspsLoadedCount");
        parent.addChild((TreeNode)this.activeJspsLoadedCount);
        this.maxJspsLoadedCount.setName("maxJspsLoadedCount");
        parent.addChild((TreeNode)this.maxJspsLoadedCount);
        this.totalJspsLoadedCount.setName("totalJspsLoadedCount");
        parent.addChild((TreeNode)this.totalJspsLoadedCount);
        this.webMonitoringEnabled = webMonitoringEnabled;
    }

    public void enableMonitoring(boolean flag) {
        if (this.isEnabled != flag) {
            for (ProbeClientMethodHandle handle : this.handles) {
                if (flag) {
                    handle.enable();
                    continue;
                }
                handle.disable();
            }
            this.jspNode.setEnabled(flag);
            if (this.isEnabled) {
                this.resetStats();
            }
            this.isEnabled = flag;
        }
    }

    @ProbeListener(value="web:jsp::jspLoadedEvent")
    public void jspLoadedEvent(@ProbeParam(value="jsp") Servlet jsp, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("JSP Loaded event received - jspName = " + jsp.getServletConfig().getServletName() + ": appName = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeJspsLoadedCount.increment();
        this.totalJspsLoadedCount.increment();
        if (this.activeJspsLoadedCount.getCount() > this.maxJspsLoadedCount.getCount()) {
            this.maxJspsLoadedCount.setCount(this.activeJspsLoadedCount.getCount());
        }
    }

    public void setProbeListenerHandles(Collection<ProbeClientMethodHandle> handles) {
        this.handles = handles;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.vsName;
    }

    private boolean isValidEvent(String mName, String hostName) {
        if (this.moduleName == null || this.vsName == null) {
            return true;
        }
        return this.moduleName.equals(mName) && this.vsName.equals(hostName);
    }

    private void resetStats() {
        this.activeJspsLoadedCount.setReset(true);
        this.maxJspsLoadedCount.setReset(true);
        this.totalJspsLoadedCount.setReset(true);
    }
}

