/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import java.util.Collection;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.provider.annotations.ProbeParam;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.factory.CounterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletStatsTelemetry {
    private Collection<ProbeClientMethodHandle> handles;
    private boolean webMonitoringEnabled;
    private String moduleName;
    private String vsName;
    private Logger logger;
    private boolean isEnabled = true;
    private TreeNode servletNode = null;
    private Counter activeServletsLoadedCount = CounterFactory.createCount((long[])new long[0]);
    private Counter maxServletsLoadedCount = CounterFactory.createCount((long[])new long[0]);
    private Counter totalServletsLoadedCount = CounterFactory.createCount((long[])new long[0]);

    public ServletStatsTelemetry(TreeNode parent, String moduleName, String vsName, boolean webMonitoringEnabled, Logger logger) {
        this.servletNode = parent;
        this.logger = logger;
        this.moduleName = moduleName;
        this.vsName = vsName;
        this.activeServletsLoadedCount.setName("activeServletsLoadedCount");
        parent.addChild((TreeNode)this.activeServletsLoadedCount);
        this.maxServletsLoadedCount.setName("maxServletsLoadedCount");
        parent.addChild((TreeNode)this.maxServletsLoadedCount);
        this.totalServletsLoadedCount.setName("totalServletsLoadedCount");
        parent.addChild((TreeNode)this.totalServletsLoadedCount);
        this.webMonitoringEnabled = webMonitoringEnabled;
    }

    public void enableMonitoring(boolean flag) {
        if (this.isEnabled != flag) {
            for (ProbeClientMethodHandle handle : this.handles) {
                if (flag) {
                    handle.enable();
                    continue;
                }
                handle.disable();
            }
            this.servletNode.setEnabled(flag);
            if (this.isEnabled) {
                this.resetStats();
            }
            this.isEnabled = flag;
        }
    }

    @ProbeListener(value="web:servlet::servletInitializedEvent")
    public void servletInitializedEvent(@ProbeParam(value="servlet") Servlet servlet, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("Servlet Loaded event received - servletName = " + servlet.getServletConfig().getServletName() + ": appName = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeServletsLoadedCount.increment();
        this.totalServletsLoadedCount.increment();
        if (this.activeServletsLoadedCount.getCount() > this.maxServletsLoadedCount.getCount()) {
            this.maxServletsLoadedCount.setCount(this.activeServletsLoadedCount.getCount());
        }
    }

    @ProbeListener(value="web:servlet::servletDestroyedEvent")
    public void servletDestroyedEvent(@ProbeParam(value="servlet") Servlet servlet, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("Servlet Destroyed event received - servletName = " + servlet.getServletConfig().getServletName() + ": appName = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeServletsLoadedCount.decrement();
    }

    public void setProbeListenerHandles(Collection<ProbeClientMethodHandle> handles) {
        this.handles = handles;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private boolean isValidEvent(String mName, String hostName) {
        if (this.moduleName == null || this.vsName == null) {
            return true;
        }
        return this.moduleName.equals(mName) && this.vsName.equals(hostName);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.vsName;
    }

    private void resetStats() {
        this.activeServletsLoadedCount.setReset(true);
        this.maxServletsLoadedCount.setReset(true);
        this.totalServletsLoadedCount.setReset(true);
    }
}

