/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.security.api;

import com.sun.enterprise.security.auth.login.LoginCallbackHandler;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.web.integration.PrincipalGroupFactory;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;

public abstract class AppservPasswordLoginModule
implements LoginModule {
    protected Subject _subject;
    protected Map _sharedState;
    protected Map _options;
    protected String _username;
    protected String _password;
    protected Realm _currentRealm;
    protected boolean _succeeded = false;
    protected boolean _commitSucceeded = false;
    protected PrincipalImpl _userPrincipal;
    protected String[] _groupsList = null;
    protected Logger _logger = LogDomains.getLogger(AppservPasswordLoginModule.class, (String)"javax.enterprise.system.core.security");
    protected static final StringManager sm = StringManager.getManager(LoginCallbackHandler.class);

    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this._subject = subject;
        this._sharedState = sharedState;
        this._options = options;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Login module initialized: " + this.getClass().toString());
        }
    }

    public final boolean login() throws LoginException {
        if (this._subject == null) {
            String msg = sm.getString("pwdlm.noinfo");
            this._logger.log(Level.SEVERE, msg);
            throw new LoginException(msg);
        }
        PasswordCredential pwdCred = null;
        try {
            Iterator<Object> i = this._subject.getPrivateCredentials().iterator();
            while (i.hasNext() && pwdCred == null) {
                Object privCred = i.next();
                if (!(privCred instanceof PasswordCredential)) continue;
                pwdCred = (PasswordCredential)privCred;
            }
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "passwordlm.nocreds", e.toString());
        }
        if (pwdCred == null) {
            this._logger.log(Level.SEVERE, "passwordlm.nopwdcred");
            String msg = sm.getString("pwdlm.nocreds");
            throw new LoginException(msg);
        }
        String realm = null;
        try {
            realm = pwdCred.getRealm();
            this._currentRealm = Realm.getInstance((String)realm);
        }
        catch (Exception e) {
            String msg = sm.getString("pwdlm.norealm", (Object)realm);
            this._logger.log(Level.SEVERE, msg);
            throw new LoginException(msg);
        }
        if (this._currentRealm == null) {
            String msg = sm.getString("pwdlm.norealmavail", (Object)realm);
            this._logger.log(Level.SEVERE, msg);
            throw new LoginException(msg);
        }
        this._username = pwdCred.getUser();
        this._password = pwdCred.getPassword();
        this.authenticateUser();
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "JAAS login complete.");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (!this._succeeded) {
            return false;
        }
        String realm_name = this._currentRealm.getName();
        this._userPrincipal = PrincipalGroupFactory.getPrincipalInstance(this._username, realm_name);
        Set<Principal> principalSet = this._subject.getPrincipals();
        if (!principalSet.contains(this._userPrincipal)) {
            principalSet.add((Principal)this._userPrincipal);
        }
        for (int i = 0; i < this._groupsList.length; ++i) {
            if (this._groupsList[i] == null) continue;
            Group g = PrincipalGroupFactory.getGroupInstance(this._groupsList[i], realm_name);
            if (!principalSet.contains(g)) {
                principalSet.add((Principal)g);
            }
            this._groupsList[i] = null;
        }
        this._groupsList = null;
        this._username = null;
        this._password = null;
        this._commitSucceeded = true;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "JAAS authentication committed.");
        }
        return true;
    }

    public final boolean abort() throws LoginException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "JAAS authentication aborted.");
        }
        if (!this._succeeded) {
            return false;
        }
        if (this._succeeded && !this._commitSucceeded) {
            this._succeeded = false;
            this._username = null;
            this._password = null;
            this._userPrincipal = null;
            for (int i = 0; i < this._groupsList.length; ++i) {
                this._groupsList[i] = null;
            }
            this._groupsList = null;
        } else {
            this.logout();
        }
        return true;
    }

    public final boolean logout() throws LoginException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "JAAS logout for: " + this._subject.toString());
        }
        this._subject.getPrincipals().clear();
        this._subject.getPublicCredentials().clear();
        this._subject.getPrivateCredentials().clear();
        this._succeeded = false;
        this._commitSucceeded = false;
        this._username = null;
        this._password = null;
        this._userPrincipal = null;
        if (this._groupsList != null) {
            for (int i = 0; i < this._groupsList.length; ++i) {
                this._groupsList[i] = null;
            }
            this._groupsList = null;
        }
        return true;
    }

    public final void commitUserAuthentication(String[] groups) {
        this._groupsList = groups;
        this._succeeded = true;
    }

    public Subject getSubject() {
        return this._subject;
    }

    protected abstract void authenticateUser() throws LoginException;
}

