/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.allocator;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.AssocWithThreadResourceHandle;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;

public abstract class AbstractConnectorAllocator
implements ResourceAllocator {
    protected PoolManager poolMgr;
    protected ResourceSpec spec;
    protected ConnectionRequestInfo reqInfo;
    protected Subject subject;
    protected ManagedConnectionFactory mcf;
    protected ConnectorDescriptor desc;
    protected ClientSecurityInfo info;
    protected static final Logger _logger = LogDomains.getLogger(AbstractConnectorAllocator.class, (String)"javax.enterprise.resource.resourceadapter");

    public AbstractConnectorAllocator() {
    }

    public AbstractConnectorAllocator(PoolManager poolMgr, ManagedConnectionFactory mcf, ResourceSpec spec, Subject subject, ConnectionRequestInfo reqInfo, ClientSecurityInfo info, ConnectorDescriptor desc) {
        this.poolMgr = poolMgr;
        this.mcf = mcf;
        this.spec = spec;
        this.subject = subject;
        this.reqInfo = reqInfo;
        this.info = info;
        this.desc = desc;
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        if (this.mcf instanceof ValidatingManagedConnectionFactory) {
            return ((ValidatingManagedConnectionFactory)((Object)this.mcf)).getInvalidConnections(connectionSet);
        }
        return null;
    }

    public boolean isConnectionValid(ResourceHandle h) {
        HashSet<Object> conn = new HashSet<Object>();
        conn.add(h.getResource());
        Set invalids = null;
        try {
            invalids = this.getInvalidConnections(conn);
        }
        catch (ResourceException re) {
            // empty catch block
        }
        return (invalids == null || invalids.size() <= 0) && !h.hasConnectionErrorOccurred();
    }

    public void destroyResource(ResourceHandle resourceHandle) throws PoolingException {
        throw new UnsupportedOperationException();
    }

    public void fillInResourceObjects(ResourceHandle resourceHandle) throws PoolingException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsReauthentication() {
        return this.desc.supportsReauthentication();
    }

    public boolean isTransactional() {
        return true;
    }

    public void cleanup(ResourceHandle h) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)h.getResource();
            mc.cleanup();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "managed_con.cleanup-failed", ex);
            throw new PoolingException(ex.toString(), ex);
        }
    }

    public boolean matchConnection(ResourceHandle h) {
        HashSet<Object> set = new HashSet<Object>();
        set.add(h.getResource());
        try {
            ManagedConnection mc = this.mcf.matchManagedConnections(set, this.subject, this.reqInfo);
            return mc != null;
        }
        catch (ResourceException ex) {
            return false;
        }
    }

    public void closeUserConnection(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            mc.cleanup();
        }
        catch (ResourceException ex) {
            throw new PoolingException((Exception)ex);
        }
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle h) throws PoolingException {
        throw new UnsupportedOperationException();
    }

    protected ResourceHandle createResourceHandle(Object resource, ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info) {
        ConnectorConstants.PoolType pt = ConnectorConstants.PoolType.STANDARD_POOL;
        try {
            pt = ConnectorRuntime.getRuntime().getPoolType(spec.getConnectionPoolName());
        }
        catch (ConnectorRuntimeException cre) {
            // empty catch block
        }
        if (pt == ConnectorConstants.PoolType.ASSOCIATE_WITH_THREAD_POOL) {
            return new AssocWithThreadResourceHandle(resource, spec, alloc, info);
        }
        return new ResourceHandle(resource, spec, alloc, info);
    }
}

