/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.jruby.Messages;
import com.sun.grizzly.jruby.RubyAdapter;
import com.sun.grizzly.jruby.RubyRuntimeAsyncFilter;
import com.sun.grizzly.pool.DynamicPool;
import com.sun.grizzly.pool.DynamicPoolConfig;
import com.sun.grizzly.standalone.MimeType;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyOutputStream;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.util.buf.ByteChunk;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyThread;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Constants;
import org.jruby.runtime.builtin.IRubyObject;

public class RailsAdapter
extends GrizzlyAdapter {
    private final DynamicPool<Ruby> pool;
    private RubyRuntimeAsyncFilter asyncFilter;
    private final String contextRoot;
    private final Map environment = new HashMap();
    private File webDir = null;
    private final ReentrantLock initializedLock = new ReentrantLock();
    private final int numThreads;
    private ConcurrentHashMap<String, File> cache = new ConcurrentHashMap();
    private final boolean debugMode;
    private final Map<Ruby, WeakHashMap<Thread, RubyThread>> threadMaps = new HashMap<Ruby, WeakHashMap<Thread, RubyThread>>();

    public RailsAdapter(String railsRoot, String jrubyLib, int numRt, int minRt, int maxRt, boolean asyncExecution, RubyRuntimeAsyncFilter asyncFilter) {
        this("/", railsRoot, jrubyLib, numRt, minRt, maxRt, asyncExecution);
        this.asyncFilter = asyncFilter;
        asyncFilter.setRubyRuntimeQueue(this.pool.getObjectQueue());
    }

    public RailsAdapter(String contextRoot, String railsRoot, String jrubyLib, int numRt, int minRuntime, int maxRuntime, boolean asyncExecution) {
        super(railsRoot);
        this.setHandleStaticResources(true);
        this.setRootFolder(railsRoot + "/public");
        this.contextRoot = contextRoot;
        RubyAdapter myAdapter = new RubyAdapter(railsRoot, jrubyLib);
        DynamicPoolConfig myConfig = new DynamicPoolConfig(numRt, -1, maxRuntime, minRuntime, -1, -1, -1, -1, asyncExecution, false);
        this.pool = new DynamicPool<Ruby>(myAdapter, myConfig);
        JRubyVersion jrubyVersion = new JRubyVersion();
        this.logger.log(Level.INFO, Messages.format("jruby.version", jrubyVersion));
        this.debugMode = jrubyVersion.compare("1.1.4") < 0;
        this.numThreads = jrubyVersion.compare("1.1.5") < 0 ? 1 : Math.min(Runtime.getRuntime().availableProcessors(), numRt);
    }

    void startRubyRuntimePool() {
        try {
            SelectorThread.logger().log(Level.INFO, Messages.format("rails.starting", new Object[0]));
            this.pool.start(this.numThreads);
        }
        catch (RaiseException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            RubyException re = e.getException();
            String rubyMessage = (String)JavaEmbedUtils.rubyToJava((Ruby)this.pool.borrowObject(), (IRubyObject)re.message, String.class);
            String message = Messages.format("rails.failed.load", rubyMessage) + "\n";
            RubyArray backtrace = (RubyArray)re.backtrace();
            for (Object aBacktrace : backtrace) {
                String traceLine = (String)aBacktrace;
                message = message + "\t" + traceLine + "\n";
            }
            this.getLogger().log(Level.SEVERE, message, e);
            throw e;
        }
    }

    void stopRubyRuntimePool() {
        this.pool.stop();
    }

    private void loadRuntimeEnvironment(Ruby runtime) {
        String logger;
        String root;
        if (!(this.contextRoot == null || this.contextRoot.equals("/") || (root = runtime.getGlobalVariables().get("$root").asString().asJavaString()) != null && root.equals(this.contextRoot))) {
            runtime.defineReadonlyVariable("$root", JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)this.contextRoot));
        }
        if ((logger = runtime.getGlobalVariables().get("$logger").asString().asJavaString()) == null || logger.length() == 0) {
            IRubyObject loggerObj = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)new Logger(this.getLogger()));
            runtime.defineReadonlyVariable("$logger", loggerObj);
        }
        RubyHash env = (RubyHash)runtime.getObject().getConstant("ENV");
        if (this.environment.size() == 0) {
            this.environment.putAll(env);
        } else {
            env.clear();
            env.putAll(this.environment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        try {
            ((InternalOutputBuffer)res.getResponse().getOutputBuffer()).commit();
        }
        catch (IOException e) {
            res.getResponse().setCommitted(true);
            this.logger.log(Level.WARNING, Messages.format("grizzly.commit.err", res.getResponse().isCommitted()));
        }
        Ruby runtime = null;
        try {
            runtime = this.pool.borrowObject();
            if (runtime == null) {
                throw new IllegalStateException(Messages.format("jruby.runtime.notavailable", new Object[0]));
            }
            if (this.debugMode) {
                this.dispatchRailsRequestDebugMode(runtime, req, res);
            } else {
                this.dispatchRailsRequest(runtime, req, res);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (runtime != null) {
                this.pool.returnObject(runtime);
                if (this.asyncFilter != null) {
                    this.asyncFilter.resume();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyThread getContextThread(Ruby runtime) {
        RubyThread contextThread = null;
        Map<Ruby, WeakHashMap<Thread, RubyThread>> map = this.threadMaps;
        synchronized (map) {
            WeakHashMap<Thread, Object> threadMap = this.threadMaps.get(runtime);
            if (threadMap != null) {
                contextThread = threadMap.get(Thread.currentThread());
            } else {
                threadMap = new WeakHashMap();
                this.threadMaps.put(runtime, threadMap);
            }
            if (contextThread == null) {
                contextThread = RubyThread.adopt((IRubyObject)runtime.getThread(), (Thread)Thread.currentThread());
                threadMap.put(Thread.currentThread(), contextThread);
            }
        }
        return contextThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchRailsRequestDebugMode(Ruby runtime, GrizzlyRequest req, GrizzlyResponse res) throws IOException {
        RubyThread oldContext = runtime.getThreadService().getMainThread();
        try {
            RubyThread context = this.getContextThread(runtime);
            runtime.getThreadService().setMainThread(context);
            this.dispatchRailsRequest(runtime, req, res);
        }
        finally {
            runtime.getThreadService().setMainThread(oldContext);
        }
    }

    private void dispatchRailsRequest(Ruby runtime, GrizzlyRequest req, GrizzlyResponse res) throws IOException {
        try {
            GrizzlyOutputStream os = res.getOutputStream();
            RubyIO iObj = new RubyIO(runtime, (InputStream)req.getInputStream());
            runtime.defineReadonlyVariable("$stdin", (IRubyObject)iObj);
            RubyIO oObj = new RubyIO(runtime, (OutputStream)os);
            runtime.defineReadonlyVariable("$stdout", (IRubyObject)oObj);
            this.loadRuntimeEnvironment(runtime);
            Object[] args = new IRubyObject[]{JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)req.getRequest())};
            IRubyObject responder = runtime.getGlobalVariables().get("$responder");
            JavaEmbedUtils.invokeMethod((Ruby)runtime, (Object)responder, (String)"service", (Object[])args, IRubyObject.class);
        }
        catch (RaiseException e) {
            this.getLogger().log(Level.SEVERE, e.getLocalizedMessage(), e);
            RubyException exception = e.getException();
            exception.printBacktrace(System.err);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(String uri, Request req, Response res) throws Exception {
        if (this.contextRoot != null && uri.startsWith(this.contextRoot)) {
            uri = uri.substring(this.contextRoot.length());
        }
        FileInputStream fis = null;
        try {
            File resource;
            if (this.webDir == null) {
                this.initializedLock.lock();
                try {
                    this.webDir = new File(this.getRootFolder());
                    try {
                        this.setRootFolder(this.webDir.getCanonicalPath());
                    }
                    catch (IOException e) {
                        this.logger.log(Level.WARNING, "service()", e);
                    }
                }
                finally {
                    this.initializedLock.unlock();
                }
            }
            if ((resource = this.cache.get(uri)) == null) {
                resource = new File(this.webDir, uri);
                this.cache.put(uri, resource);
            }
            if (resource.isDirectory()) {
                resource = new File(resource, "index.html");
                this.cache.put(uri, resource);
            }
            if (!resource.exists()) {
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.FINE, Messages.format("static.file.notfound", resource));
                }
                res.setStatus(404);
                this.customizedErrorPage(req, res);
                return;
            }
            res.setStatus(200);
            int dot = uri.lastIndexOf(".");
            if (dot > 0) {
                String ext = uri.substring(dot + 1);
                String ct = MimeType.get((String)ext);
                if (ct != null) {
                    res.setContentType(ct);
                }
            } else {
                res.setContentType(MimeType.get((String)"html"));
            }
            res.setContentLength((int)resource.length());
            res.sendHeaders();
            fis = new FileInputStream(resource);
            byte[] b = new byte[8192];
            ByteChunk chunk = new ByteChunk();
            int rd = 0;
            while ((rd = fis.read(b)) > 0) {
                chunk.setBytes(b, 0, rd);
                res.doWrite(chunk);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {}
            }
        }
        res.setCommitted(true);
    }

    private static class Logger {
        private final java.util.logging.Logger logger;

        public Logger(java.util.logging.Logger logger) {
            this.logger = logger;
        }

        public void log(String msg) {
            this.logger.fine(msg);
        }
    }

    private static class JRubyVersion {
        private final int major;
        private final int minor;
        private final int suffix;

        public JRubyVersion() {
            this(Constants.VERSION);
        }

        private JRubyVersion(String version) {
            int i = version.lastIndexOf(46);
            if (i != -1) {
                this.suffix = Character.digit(version.charAt(i + 1), 10);
                if ((i = version.substring(0, i).lastIndexOf(46)) != -1) {
                    this.minor = Character.digit(version.charAt(i + 1), 10);
                    this.major = i == 1 ? Character.digit(version.charAt(i - 1), 10) : 0;
                } else {
                    this.minor = 0;
                    this.major = 1;
                }
            } else {
                this.suffix = 0;
                this.minor = 0;
                this.major = 0;
            }
        }

        public int compare(JRubyVersion version) {
            if (version.major == this.major && version.minor == this.minor && version.suffix == this.suffix) {
                return 0;
            }
            if (this.major > version.major || this.minor > version.minor || this.suffix > version.suffix) {
                return 1;
            }
            return -1;
        }

        public int compare(String version) {
            return this.compare(new JRubyVersion(version));
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.suffix;
        }
    }
}

