/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.arp.AsyncFilter;
import com.sun.grizzly.arp.AsyncHandler;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.jruby.RailsAdapter;
import com.sun.grizzly.jruby.RubyRuntimeAsyncFilter;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import java.io.IOException;
import java.util.logging.Level;

public class RailsSelectorThread
extends SelectorThread {
    private static final String NUMBER_OF_RUNTIME = "com.sun.grizzly.rails.numberOfRuntime";
    private String jrubyLib;
    private int numberOfRuntime = 5;
    private int maxRt = -1;
    private int minRt = -1;
    private String railsRoot = null;

    public String getRailsRoot() {
        return this.railsRoot;
    }

    public void initEndpoint() throws IOException, InstantiationException {
        this.setupSystemProperties();
        this.asyncExecution = true;
        RubyRuntimeAsyncFilter asyncFilter = new RubyRuntimeAsyncFilter();
        this.adapter = new RailsAdapter(this.railsRoot, this.jrubyLib, this.numberOfRuntime, this.minRt, this.maxRt, this.asyncExecution, asyncFilter);
        ((RailsAdapter)this.adapter).startRubyRuntimePool();
        RailsSelectorThread.setWebAppRootPath((String)(this.railsRoot + "/public"));
        this.setBufferResponse(false);
        DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
        this.setAsyncHandler((AsyncHandler)asyncHandler);
        asyncHandler.addAsyncFilter((AsyncFilter)asyncFilter);
        this.algorithmClassName = StaticStreamAlgorithm.class.getName();
        super.initEndpoint();
    }

    public void setNumberOfRuntime(int numberOfRuntime) {
        this.numberOfRuntime = numberOfRuntime;
    }

    public void setRailsRoot(String railsRoot) {
        this.railsRoot = railsRoot;
    }

    public synchronized void stopEndpoint() {
        ((RailsAdapter)this.adapter).stopRubyRuntimePool();
        super.stopEndpoint();
    }

    protected void setupSystemProperties() {
        this.jrubyLib = System.getProperty("jruby.lib");
        if (this.jrubyLib == null) {
            this.jrubyLib = System.getenv().get("JRUBY_HOME") + "/lib";
            System.setProperty("jruby.lib", this.jrubyLib);
        }
        if (System.getProperty(NUMBER_OF_RUNTIME) != null) {
            try {
                this.numberOfRuntime = Integer.parseInt(System.getProperty(NUMBER_OF_RUNTIME));
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, "Invalid number of Runtime: " + System.getProperty(NUMBER_OF_RUNTIME));
            }
        }
        if (System.getProperty("jruby.runtime.max") != null) {
            try {
                this.maxRt = Integer.parseInt(System.getProperty("jruby.runtime.max"));
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, "Invalid number of max runtime: " + System.getProperty("jruby.runtime.max"));
            }
        }
        if (System.getProperty("jruby.runtime.min") != null) {
            try {
                this.minRt = Integer.parseInt(System.getProperty("jruby.runtime.min"));
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, "Invalid number of min runtime: " + System.getProperty("jruby.runtime.min"));
            }
        }
    }
}

