/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.impl.services.locks.LockSet;
import org.apache.derby.impl.services.locks.LockSpace;
import org.apache.derby.impl.services.locks.SinglePool;
import org.apache.derby.impl.services.locks.TableNameInfo;

class Deadlock {
    private Deadlock() {
    }

    static Object[] look(SinglePool singlePool, LockSet lockSet, LockControl lockControl, ActiveLock activeLock, byte by) {
        Hashtable hashtable = Deadlock.getWaiters(lockSet);
        Stack<Object> stack = new Stack<Object>();
        stack.push(activeLock.getCompatabilitySpace());
        stack.push(lockControl.getGrants());
        block0: while (!stack.isEmpty()) {
            int n;
            List list = (List)stack.peek();
            if (list.isEmpty()) {
                Deadlock.rollback(stack);
                continue;
            }
            int n2 = list.size() - 1;
            Object object = ((Lock)list.get(n2)).getCompatabilitySpace();
            for (n = 0; n < n2; ++n) {
                if (!object.equals(((Lock)list.get(n)).getCompatabilitySpace())) continue;
                stack.push(object);
                Deadlock.rollback(stack);
                continue block0;
            }
            while (true) {
                Lock lock;
                if ((n = stack.indexOf(object)) != -1) {
                    if (n == stack.size() - 1 || n == stack.size() - 2 && n == stack.indexOf(list) - 1) {
                        lock = (ActiveLock)((Dictionary)hashtable).get(object);
                        if (((ActiveLock)lock).canSkip) {
                            stack.push(object);
                            Deadlock.rollback(stack);
                            continue block0;
                        }
                    }
                    return Deadlock.handle(singlePool, stack, n, hashtable, by);
                }
                stack.push(object);
                lock = (Lock)((Dictionary)hashtable).get(object);
                if (lock == null) {
                    Deadlock.rollback(stack);
                    continue block0;
                }
                Object v = ((Dictionary)hashtable).get(lock);
                if (v instanceof LockControl) {
                    LockControl lockControl2 = (LockControl)v;
                    if (lockControl2.isUnlocked()) {
                        Deadlock.rollback(stack);
                        continue block0;
                    }
                    stack.push(lockControl2.getGrants());
                    continue block0;
                }
                object = lock.getCompatabilitySpace();
            }
        }
        return null;
    }

    private static void rollback(Stack stack) {
        do {
            stack.pop();
            if (!stack.isEmpty()) continue;
            return;
        } while (!(stack.peek() instanceof List));
        List list = (List)stack.peek();
        list.remove(list.size() - 1);
    }

    private static Hashtable getWaiters(LockSet lockSet) {
        Hashtable hashtable = new Hashtable(lockSet.size() * 2);
        Enumeration enumeration = lockSet.elements();
        while (enumeration.hasMoreElements()) {
            Control control = (Control)enumeration.nextElement();
            control.addWaiters(hashtable);
        }
        return hashtable;
    }

    private static Object[] handle(SinglePool singlePool, Stack stack, int n, Dictionary dictionary, byte by) {
        Object e = stack.elementAt(0);
        int n2 = Integer.MAX_VALUE;
        Object var7_7 = null;
        for (int i = n; i < stack.size(); ++i) {
            Object e2 = stack.elementAt(i);
            if (e2 instanceof List) continue;
            if (e.equals(e2) && by == 2) {
                var7_7 = e;
                break;
            }
            LockSpace lockSpace = (LockSpace)singlePool.get(e2);
            if (lockSpace == null) {
                var7_7 = e2;
                break;
            }
            int n3 = lockSpace.deadlockCount(n2);
            if (n3 > n2) continue;
            var7_7 = e2;
            n2 = n3;
        }
        if (e.equals(var7_7)) {
            Object[] objectArray = new Object[]{stack, dictionary};
            return objectArray;
        }
        ActiveLock activeLock = (ActiveLock)dictionary.get(var7_7);
        activeLock.wakeUp((byte)2);
        return null;
    }

    static StandardException buildException(SinglePool singlePool, Object[] objectArray) {
        Stack stack = (Stack)objectArray[0];
        Dictionary dictionary = (Dictionary)objectArray[1];
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        TableNameInfo tableNameInfo = null;
        TransactionInfo[] transactionInfoArray = null;
        TransactionController transactionController = null;
        if (languageConnectionContext != null) {
            try {
                transactionController = languageConnectionContext.getTransactionExecute();
                tableNameInfo = new TableNameInfo(languageConnectionContext, false);
                transactionInfoArray = languageConnectionContext.getLanguageConnectionFactory().getAccessFactory().getTransactionInfo();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        Hashtable hashtable = new Hashtable(17);
        String string = null;
        for (int i = 0; i < stack.size(); ++i) {
            Object object;
            Object e = stack.elementAt(i);
            if (e instanceof List) {
                object = (List)e;
                if (object.size() == 0) continue;
                stringBuffer.append("  Granted XID : ");
                for (int j = 0; j < object.size(); ++j) {
                    if (j != 0) {
                        stringBuffer.append(", ");
                    }
                    Lock lock = (Lock)object.get(j);
                    stringBuffer.append("{");
                    stringBuffer.append(lock.getCompatabilitySpace());
                    stringBuffer.append(", ");
                    stringBuffer.append(lock.getQualifier());
                    stringBuffer.append("} ");
                }
                stringBuffer.append('\n');
                continue;
            }
            object = (Lock)dictionary.get(e);
            ((Lock)object).getLockable().lockAttributes(-1, hashtable);
            Deadlock.addInfo(stringBuffer, "Lock : ", hashtable.get("TYPE"));
            if (tableNameInfo != null) {
                Long l = (Long)hashtable.get("CONGLOMID");
                if (l == null) {
                    Long l2 = (Long)hashtable.get("CONTAINERID");
                    try {
                        l = new Long(transactionController.findConglomid(l2));
                    }
                    catch (StandardException standardException) {
                        // empty catch block
                    }
                }
                Deadlock.addInfo(stringBuffer, ", ", tableNameInfo.getTableName(l));
            }
            Deadlock.addInfo(stringBuffer, ", ", hashtable.get("LOCKNAME"));
            stringBuffer.append('\n');
            String string2 = e.toString();
            if (i == 0) {
                string = string2;
            }
            Deadlock.addInfo(stringBuffer, "  Waiting XID : {", string2);
            Deadlock.addInfo(stringBuffer, ", ", ((Lock)object).getQualifier());
            stringBuffer.append("} ");
            if (transactionInfoArray != null) {
                for (int j = transactionInfoArray.length - 1; j >= 0; --j) {
                    String string3;
                    TransactionInfo transactionInfo = transactionInfoArray[j];
                    if (transactionInfo == null || (string3 = transactionInfo.getTransactionIdString()) == null || !string3.equals(string2)) continue;
                    Deadlock.addInfo(stringBuffer, ", ", transactionInfo.getUsernameString());
                    Deadlock.addInfo(stringBuffer, ", ", transactionInfo.getStatementTextString());
                    break;
                }
            }
            stringBuffer.append('\n');
            hashtable.clear();
        }
        StandardException standardException = StandardException.newException("40001", (Object)stringBuffer.toString(), string);
        standardException.setReport(singlePool.deadlockMonitor);
        return standardException;
    }

    private static void addInfo(StringBuffer stringBuffer, String string, Object object) {
        stringBuffer.append(string);
        if (object == null) {
            object = "?";
        }
        stringBuffer.append(object);
    }
}

