/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSKEYSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSKEYS";
    protected static final int SYSKEYS_COLUMN_COUNT = 2;
    protected static final int SYSKEYS_CONSTRAINTID = 1;
    protected static final int SYSKEYS_CONGLOMERATEID = 2;
    protected static final int SYSKEYS_INDEX1_ID = 0;
    private static final boolean[] uniqueness = null;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final String[] uuids = new String[]{"80000039-00d0-fd77-3ed8-000a0a0b1900", "8000003c-00d0-fd77-3ed8-000a0a0b1900", "8000003b-00d0-fd77-3ed8-000a0a0b1900"};

    public SYSKEYSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, boolean bl) {
        super(uUIDFactory, executionFactory, dataValueFactory, bl);
        this.initInfo(2, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        String string2 = null;
        if (tupleDescriptor != null) {
            KeyConstraintDescriptor keyConstraintDescriptor = (KeyConstraintDescriptor)tupleDescriptor;
            UUID uUID = keyConstraintDescriptor.getUUID();
            string = uUID.toString();
            string2 = keyConstraintDescriptor.getIndexUUIDString();
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(2);
        execRow.setColumn(1, this.dvf.getCharDataValue(string));
        execRow.setColumn(2, this.dvf.getCharDataValue(string2));
        return execRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        SubKeyConstraintDescriptor subKeyConstraintDescriptor = null;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string2);
        subKeyConstraintDescriptor = new SubKeyConstraintDescriptor(uUID, uUID2);
        return subKeyConstraintDescriptor;
    }

    public SystemColumn[] buildColumnList() {
        int n = 0;
        SystemColumn[] systemColumnArray = new SystemColumn[2];
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("CONSTRAINTID"), 1, 0, 0, false, "CHAR", true, 36);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("CONGLOMERATEID"), 2, 0, 0, false, "CHAR", true, 36);
        return systemColumnArray;
    }
}

