/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.base.NotificationService;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.OverflowHandler;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.mbean.AMXNonConfigImplBase;
import org.glassfish.admin.amx.mbean.NotificationBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NotificationServiceImpl
extends AMXNonConfigImplBase
implements NotificationListener,
NotificationEmitter {
    private Map<ObjectName, NotificationFilter> mListenees;
    private final Object mUserData;
    private final Map<ObjectName, NotificationFilter> mIncludePatterns;
    private final Map<Object, NotificationBuffer> mBuffers;
    private final String[] NOTIF_TYPES = new String[]{"X-NotificationService.BufferOverflow"};
    private static int sBufferID = 0;

    public NotificationServiceImpl(ObjectName parentObjectName, Object userData, int bufferSize) {
        super("X-NotificationService", "X-NotificationService", parentObjectName, NotificationService.class, null);
        if (userData == null || !(userData instanceof Serializable)) {
            throw new IllegalArgumentException();
        }
        this.mUserData = userData;
        this.mListenees = Collections.synchronizedMap(new HashMap());
        this.mBuffers = Collections.synchronizedMap(new HashMap());
        this.mIncludePatterns = new HashMap<ObjectName, NotificationFilter>();
    }

    public final Object getUserData() {
        return this.mUserData;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo info = new MBeanNotificationInfo(this.NOTIF_TYPES, Notification.class.getName(), "");
        MBeanNotificationInfo[] selfInfos = new MBeanNotificationInfo[]{info};
        return JMXUtil.mergeMBeanNotificationInfos((MBeanNotificationInfo[])super.getNotificationInfo(), (MBeanNotificationInfo[])selfInfos);
    }

    protected void issueBufferOverflowNotification(Notification oldNotif) {
        if (this.shouldEmitNotifications()) {
            this.sendNotification("X-NotificationService.BufferOverflow", "X-NotificationService.OverflowedNotification", oldNotif);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notif, Object handback) {
        Map<Object, NotificationBuffer> map = this.mBuffers;
        synchronized (map) {
            for (Object id : this.mBuffers.keySet()) {
                this.getBuffer(id).bufferNotification(notif);
            }
        }
        this.sendNotification(notif);
    }

    private NotificationBuffer getBuffer(Object bufferID) {
        return this.mBuffers.get(bufferID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createBuffer(int bufferSize, NotificationFilter filter) {
        OverflowHandlerImpl handler = new OverflowHandlerImpl();
        NotificationBuffer buffer = new NotificationBuffer(bufferSize, filter, handler);
        String id = null;
        Map<Object, NotificationBuffer> map = this.mBuffers;
        synchronized (map) {
            id = "" + ++sBufferID;
            this.mBuffers.put(id, buffer);
        }
        return id;
    }

    public void removeBuffer(Object bufferID) {
        NotificationBuffer buffer = this.mBuffers.remove(bufferID);
    }

    public Map getBufferNotifications(Object bufferID, long sequenceNumberIn) {
        NotificationBuffer buffer = this.getBuffer(bufferID);
        return buffer.getNotifications(sequenceNumberIn);
    }

    @Override
    public String getGroup() {
        return "utility";
    }

    protected Set<ObjectName> getMatchingObjectNames(ObjectName pattern) {
        Set s = null;
        s = pattern.isPattern() ? JMXUtil.queryNames((MBeanServer)this.getMBeanServer(), (ObjectName)pattern, null) : GSetUtil.newSingletonSet((Object)pattern);
        return s;
    }

    protected void listenToIfMatch(ObjectName objectName) {
        if (!this.mListenees.keySet().contains(objectName)) {
            String defaultDomain = this.getMBeanServer().getDefaultDomain();
            for (ObjectName pattern : this.mIncludePatterns.keySet()) {
                if (!JMXUtil.matchesPattern((String)defaultDomain, (ObjectName)pattern, (ObjectName)objectName)) continue;
                NotificationFilter filter = this.mIncludePatterns.get(pattern);
                this.listenToSingle(objectName, filter);
            }
        }
    }

    protected void listenToSingle(ObjectName objectName, NotificationFilter filter) {
        this.mListenees.put(objectName, filter);
        try {
            this.getMBeanServer().addNotificationListener(objectName, this, filter, null);
        }
        catch (Exception e) {
            this.mListenees.remove(objectName);
        }
    }

    public void listenTo(ObjectName pattern, NotificationFilter filter) throws InstanceNotFoundException {
        this.mIncludePatterns.put(pattern, filter);
        Set<ObjectName> listenees = this.getMatchingObjectNames(pattern);
        MBeanServer server = this.getMBeanServer();
        for (ObjectName objectName : listenees) {
            if (objectName.equals(this.getObjectName())) continue;
            this.listenToSingle(objectName, filter);
        }
    }

    private void checkListeningTo(ObjectName objectName) {
        if (!this.mListenees.containsKey(objectName)) {
            throw new IllegalArgumentException(objectName.toString());
        }
    }

    public void dontListenTo(ObjectName pattern) {
        this.mIncludePatterns.remove(pattern);
        Set<ObjectName> listenees = this.getMatchingObjectNames(pattern);
        MBeanServer server = this.getMBeanServer();
        for (ObjectName objectName : listenees) {
            try {
                server.removeNotificationListener(objectName, this);
                this.mListenees.remove(objectName);
            }
            catch (ListenerNotFoundException e) {
            }
            catch (InstanceNotFoundException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ObjectName> getListeneeObjectNameSet() {
        HashSet<ObjectName> objectNames = new HashSet<ObjectName>();
        Map<ObjectName, NotificationFilter> map = this.mListenees;
        synchronized (map) {
            objectNames.addAll(this.mListenees.keySet());
        }
        return objectNames;
    }

    private NotificationFilter _getFilter(ObjectName objectName) {
        NotificationFilter filter = this.mListenees.get(objectName);
        return filter;
    }

    public NotificationFilter getFilter(ObjectName objectName) {
        this.checkListeningTo(objectName);
        return this._getFilter(objectName);
    }

    @Override
    protected void preRegisterDone() throws Exception {
        super.preRegisterDone();
        JMXUtil.listenToMBeanServerDelegate((MBeanServerConnection)this.getMBeanServer(), (NotificationListener)new RegistrationListener(), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preDeregisterHook() throws Exception {
        super.preDeregisterHook();
        Map<Object, Object> map = this.mListenees;
        synchronized (map) {
            Set<ObjectName> s = this.getListeneeObjectNameSet();
            ObjectName[] objectNames = new ObjectName[s.size()];
            s.toArray(objectNames);
            for (int i = 0; i < objectNames.length; ++i) {
                this.dontListenTo(objectNames[i]);
            }
        }
        map = this.mBuffers;
        synchronized (map) {
            for (NotificationBuffer buffer : this.mBuffers.values()) {
                this.removeBuffer(buffer);
            }
        }
    }

    private final class RegistrationListener
    implements NotificationListener {
        public void handleNotification(Notification notifIn, Object handback) {
            if (notifIn instanceof MBeanServerNotification) {
                MBeanServerNotification notif = (MBeanServerNotification)notifIn;
                ObjectName objectName = notif.getMBeanName();
                String type = notif.getType();
                if (type.equals("JMX.mbean.registered")) {
                    NotificationServiceImpl.this.listenToIfMatch(objectName);
                } else if (type.equals("JMX.mbean.unregistered")) {
                    NotificationServiceImpl.this.dontListenTo(objectName);
                }
            }
        }
    }

    private final class OverflowHandlerImpl
    implements OverflowHandler {
        public void handleBufferOverflow(Object o) {
            Notification notif = (Notification)o;
            NotificationServiceImpl.this.issueBufferOverflowNotification(notif);
        }
    }
}

