/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11;

import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyOutputBuffer;
import com.sun.grizzly.tcp.http11.GrizzlyOutputStream;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlySession;
import com.sun.grizzly.tcp.http11.GrizzlyWriter;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.UEncoder;
import com.sun.grizzly.util.http.Cookie;
import com.sun.grizzly.util.http.FastHttpDateFormat;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.util.http.ServerCookie;
import com.sun.grizzly.util.res.StringManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class GrizzlyResponse {
    private boolean cacheEnabled = false;
    private String detailErrorMsg;
    protected SimpleDateFormat format = null;
    protected static final String info = "com.sun.grizzly.util.tcp.GrizzlyResponse/1.0";
    protected static StringManager sm = StringManager.getManager("com.sun.grizzly.tcp.http11");
    protected GrizzlyRequest request = null;
    protected Response response;
    protected GrizzlyOutputBuffer outputBuffer;
    protected GrizzlyOutputStream outputStream;
    protected GrizzlyWriter writer;
    protected boolean appCommitted = false;
    protected boolean included = false;
    private boolean isCharacterEncodingSet = false;
    private boolean isContentTypeSet = false;
    protected boolean error = false;
    protected ArrayList cookies = new ArrayList();
    protected boolean usingOutputStream = false;
    protected boolean usingWriter = false;
    protected UEncoder urlEncoder = new UEncoder();
    protected CharChunk redirectURLCC = new CharChunk();

    public GrizzlyResponse() {
        this(false, false);
    }

    public GrizzlyResponse(boolean chunkingDisabled, boolean cacheEnabled) {
        this.outputBuffer = new GrizzlyOutputBuffer(chunkingDisabled);
        this.outputStream = new GrizzlyOutputStream(this.outputBuffer);
        this.writer = new GrizzlyWriter(this.outputBuffer);
        this.urlEncoder.addSafeCharacter('/');
        this.cacheEnabled = cacheEnabled;
    }

    public GrizzlyRequest getRequest() {
        return this.request;
    }

    public void setRequest(GrizzlyRequest request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
        this.outputBuffer.setResponse(response);
    }

    public Response getResponse() {
        return this.response;
    }

    public void recycle() {
        this.outputBuffer.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.appCommitted = false;
        this.included = false;
        this.error = false;
        this.isContentTypeSet = false;
        this.isCharacterEncodingSet = false;
        this.detailErrorMsg = null;
        this.cookies.clear();
        if (System.getSecurityManager() != null) {
            if (this.outputStream != null) {
                this.outputStream.clear();
                this.outputStream = null;
            }
            if (this.writer != null) {
                this.writer.clear();
                this.writer = null;
            }
        } else {
            this.writer.recycle();
        }
        this.cacheEnabled = false;
    }

    public String encodeURL(String url) {
        String absolute = this.toAbsolute(url);
        if (this.isEncodeable(absolute)) {
            if (url.equalsIgnoreCase("")) {
                url = absolute;
            }
            return this.toEncoded(url, this.request.getSession().getIdInternal());
        }
        return url;
    }

    protected boolean isEncodeable(String location) {
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        GrizzlySession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        if (this.request.isRequestedSessionIdFromCookie()) {
            return false;
        }
        return this.doIsEncodeable(this.request, session, location);
    }

    private boolean doIsEncodeable(GrizzlyRequest request, GrizzlySession session, String location) {
        int urlPort;
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!request.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!request.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = request.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(request.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String contextPath = "/";
        if (contextPath != null) {
            String file = url.getFile();
            if (file == null || !file.startsWith(contextPath)) {
                return false;
            }
            if (file.indexOf(";jsessionid=" + session.getIdInternal()) >= 0) {
                return false;
            }
        }
        return true;
    }

    public int getContentCount() {
        return this.outputBuffer.getContentWritten();
    }

    public void setAppCommitted(boolean appCommitted) {
        this.appCommitted = appCommitted;
    }

    public boolean isAppCommitted() {
        return this.appCommitted || this.isCommitted() || this.isSuspended() || this.getContentLength() > 0 && this.getContentCount() >= this.getContentLength();
    }

    public boolean getIncluded() {
        return this.included;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public String getInfo() {
        return info;
    }

    public OutputStream getStream() {
        if (this.outputStream == null) {
            this.outputStream = new GrizzlyOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public void setStream(OutputStream stream) {
    }

    public void setSuspended(boolean suspended) {
        this.outputBuffer.setSuspended(suspended);
    }

    public boolean isSuspended() {
        return this.outputBuffer.isSuspended();
    }

    public void setError() {
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public void setDetailMessage(String message) {
        this.detailErrorMsg = message;
    }

    public String getDetailMessage() {
        return this.detailErrorMsg;
    }

    public GrizzlyOutputStream createOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new GrizzlyOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public void finishResponse() throws IOException {
        try {
            this.outputBuffer.close();
        }
        catch (IOException e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getContentLength() {
        return this.response.getContentLength();
    }

    public String getContentType() {
        return this.response.getContentType();
    }

    public PrintWriter getReporter() throws IOException {
        if (this.outputBuffer.isNew()) {
            this.outputBuffer.checkConverter();
            if (this.writer == null) {
                this.writer = new GrizzlyWriter(this.outputBuffer);
            }
            return this.writer;
        }
        return null;
    }

    public void flushBuffer() throws IOException {
        this.outputBuffer.flush();
    }

    public int getBufferSize() {
        return this.outputBuffer.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public GrizzlyOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException(sm.getString("response.getOutputStream.ise"));
        }
        this.usingOutputStream = true;
        if (this.outputStream == null) {
            this.outputStream = new GrizzlyOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException(sm.getString("response.getWriter.ise"));
        }
        this.setCharacterEncoding(this.getCharacterEncoding());
        this.usingWriter = true;
        this.outputBuffer.checkConverter();
        if (this.writer == null) {
            this.writer = new GrizzlyWriter(this.outputBuffer);
        }
        return this.writer;
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void reset() {
        if (this.included) {
            return;
        }
        this.response.reset();
        this.outputBuffer.reset();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("response.resetBuffer.ise"));
        }
        this.outputBuffer.reset();
    }

    public void setBufferSize(int size) {
        if (this.isCommitted() || !this.outputBuffer.isNew()) {
            throw new IllegalStateException(sm.getString("response.setBufferSize.ise"));
        }
        this.outputBuffer.setBufferSize(size);
    }

    public void setContentLengthLong(long length) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.response.setContentLengthLong(length);
    }

    public void setContentLength(int length) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.response.setContentLength(length);
    }

    public void setContentType(String type) {
        int index;
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter && type != null && (index = type.indexOf(";")) != -1) {
            type = type.substring(0, index);
        }
        this.response.setContentType(type);
        if (type != null && (index = type.indexOf(";")) != -1) {
            int len = type.length();
            ++index;
            while (index < len && Character.isSpace(type.charAt(index))) {
                ++index;
            }
            if (index + 7 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                this.isCharacterEncodingSet = true;
            }
        }
        this.isContentTypeSet = true;
    }

    public void setCharacterEncoding(String charset) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.response.setCharacterEncoding(charset);
        this.isCharacterEncodingSet = true;
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.response.setLocale(locale);
        if (this.usingWriter) {
            return;
        }
        if (this.isCharacterEncodingSet) {
            return;
        }
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public String getHeader(String name) {
        return this.response.getMimeHeaders().getHeader(name);
    }

    public String[] getHeaderNames() {
        MimeHeaders headers = this.response.getMimeHeaders();
        int n = headers.size();
        String[] result = new String[n];
        for (int i = 0; i < n; ++i) {
            result[i] = headers.getName(i).toString();
        }
        return result;
    }

    public String[] getHeaderValues(String name) {
        Enumeration e = this.response.getMimeHeaders().values(name);
        Vector result = new Vector();
        while (e.hasMoreElements()) {
            result.addElement(e.nextElement());
        }
        Object[] resultArray = new String[result.size()];
        result.copyInto(resultArray);
        return resultArray;
    }

    public String getMessage() {
        return this.response.getMessage();
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public void reset(int status, String message) {
        this.reset();
        this.setStatus(status, message);
    }

    public void addCookie(final Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        final StringBuffer sb = new StringBuffer();
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServerCookie.appendCookieValue(sb, cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure());
                    return null;
                }
            });
        } else {
            ServerCookie.appendCookieValue(sb, cookie.getVersion(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getComment(), cookie.getMaxAge(), cookie.getSecure());
        }
        this.addHeader("Set-Cookie", sb.toString());
        this.cookies.add(cookie);
    }

    public void addDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.addHeader(name, FastHttpDateFormat.formatDate(value, this.format));
    }

    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.response.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public void sendAcknowledgement() throws IOException {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.response.acknowledge();
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("response.sendError.ise"));
        }
        if (this.included) {
            return;
        }
        this.setError();
        this.response.setStatus(status);
        this.response.setMessage(message);
        this.resetBuffer();
        this.setSuspended(true);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("response.sendRedirect.ise"));
        }
        if (this.included) {
            return;
        }
        this.resetBuffer();
        try {
            String absolute = this.toAbsolute(location);
            this.setStatus(200);
            this.setHeader("Location", absolute);
        }
        catch (IllegalArgumentException e) {
            this.setStatus(404);
        }
        this.setSuspended(true);
    }

    public void setDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.setHeader(name, FastHttpDateFormat.formatDate(value, this.format));
    }

    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.response.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    public void setStatus(int status) {
        this.setStatus(status, null);
    }

    public void setStatus(int status, String message) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.response.setStatus(status);
        this.response.setMessage(message);
    }

    protected String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (leadingSlash || !leadingSlash && location.indexOf("://") == -1) {
            this.redirectURLCC.recycle();
            String scheme = this.request.getScheme();
            String name = this.request.getServerName();
            int port = this.request.getServerPort();
            try {
                this.redirectURLCC.append(scheme, 0, scheme.length());
                this.redirectURLCC.append("://", 0, 3);
                this.redirectURLCC.append(name, 0, name.length());
                if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                    this.redirectURLCC.append(':');
                    String portS = port + "";
                    this.redirectURLCC.append(portS, 0, portS.length());
                }
                if (!leadingSlash) {
                    String relativePath = this.request.getDecodedRequestURI();
                    int pos = relativePath.lastIndexOf(47);
                    relativePath = relativePath.substring(0, pos);
                    String encodedURI = null;
                    final String frelativePath = relativePath;
                    if (System.getSecurityManager() != null) {
                        try {
                            encodedURI = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    return GrizzlyResponse.this.urlEncoder.encodeURL(frelativePath);
                                }
                            });
                        }
                        catch (PrivilegedActionException pae) {
                            IllegalArgumentException iae = new IllegalArgumentException(location);
                            iae.initCause(pae.getCause());
                            throw iae;
                        }
                    } else {
                        encodedURI = this.urlEncoder.encodeURL(relativePath);
                    }
                    this.redirectURLCC.append(encodedURI, 0, encodedURI.length());
                    this.redirectURLCC.append('/');
                }
                this.redirectURLCC.append(location, 0, location.length());
            }
            catch (IOException e) {
                IllegalArgumentException iae = new IllegalArgumentException(location);
                iae.initCause(e);
                throw iae;
            }
            return this.redirectURLCC.toString();
        }
        return location;
    }

    protected String toEncoded(String url, String sessionId) {
        String jrouteId;
        StringBuffer sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuffer(path)).length() > 0) {
            sb.append(";jsessionid=");
            sb.append(sessionId);
        }
        if ((jrouteId = this.request.getHeader("proxy-jroute")) != null) {
            sb.append(":");
            sb.append(jrouteId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void enableCache(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        this.outputBuffer.enableCache(cacheEnabled);
    }

    public GrizzlyOutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public void setChunkingDisabled(boolean chunkingDisabled) {
        if (this.outputBuffer != null) {
            this.outputBuffer.setChunkingDisabled(chunkingDisabled);
        }
    }

    public boolean getChunkingDisabled() {
        if (this.outputBuffer != null) {
            this.outputBuffer.getChunkingDisabled();
        }
        return true;
    }
}

