/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.client;

import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.cli.framework.CommandException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.glassfish.deployment.client.AbstractDeploymentFacility;
import org.glassfish.deployment.client.CommandXMLResultParser;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DeploymentFacility;
import org.glassfish.deployment.client.ServerConnectionIdentifier;
import org.glassfish.deployment.client.TargetOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDeploymentFacility
extends AbstractDeploymentFacility
implements DeploymentFacility,
TargetOwner {
    private File passwordFile;

    @Override
    protected boolean doConnect() {
        this.passwordFile = this.preparePasswordFile();
        return true;
    }

    @Override
    public boolean doDisconnect() {
        this.passwordFile.delete();
        return true;
    }

    private File preparePasswordFile() {
        File pwFile = null;
        try {
            pwFile = File.createTempFile("rdf", ".dat");
            PrintStream ps = new PrintStream(pwFile);
            ps.println("AS_ADMIN_PASSWORD=" + this.getTargetDAS().getPassword());
            ps.close();
            return pwFile;
        }
        catch (IOException ex) {
            if (pwFile != null) {
                pwFile.delete();
            }
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected AbstractDeploymentFacility.DFCommandRunner getDFCommandRunner(String commandName, Map<String, Object> commandOptions, String[] operands) throws CommandException {
        return new RemoteCommandRunner(commandName, commandOptions, operands);
    }

    protected String[] prepareRemoteCommandArguments(String commandName, Map<String, Object> options, String[] operands) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(commandName);
        if (options == null) {
            options = Collections.EMPTY_MAP;
        }
        for (Map.Entry entry : options.entrySet()) {
            result.add("--" + (String)entry.getKey() + "=" + this.convertValue(entry.getValue()));
        }
        ServerConnectionIdentifier targetDAS = this.getTargetDAS();
        if (targetDAS.isSecure()) {
            result.add("--secure");
        }
        result.add("--host=" + targetDAS.getHostName());
        result.add("--port=" + targetDAS.getHostPort());
        result.add("--user=" + targetDAS.getUserName());
        result.add("--passwordfile=" + this.passwordFile.getAbsolutePath());
        if (operands != null) {
            for (String o : operands) {
                result.add(o);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private Object convertValue(Object value) {
        if (value instanceof Properties) {
            StringBuilder sb = new StringBuilder();
            Properties p = (Properties)value;
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(":");
                }
                sb.append((String)entry.getKey() + "=" + (String)entry.getValue());
            }
            return sb.toString();
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoteCommandRunner
    implements AbstractDeploymentFacility.DFCommandRunner {
        private final String commandName;
        private final Map<String, Object> commandOptions;
        private final String[] operands;

        private RemoteCommandRunner(String commandName, Map<String, Object> commandOptions, String[] operands) {
            this.commandOptions = commandOptions;
            this.commandName = commandName;
            this.operands = operands;
        }

        @Override
        public DFDeploymentStatus run() throws CommandException {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                String[] commandArgs = RemoteDeploymentFacility.this.prepareRemoteCommandArguments(this.commandName, this.commandOptions, this.operands);
                CLIRemoteCommand rc = new CLIRemoteCommand(commandArgs, "xml-cli", (OutputStream)baos);
                rc.runCommand();
                DFDeploymentStatus status = CommandXMLResultParser.parse(new ByteArrayInputStream(baos.toByteArray()));
                return status;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

