/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Enumerator;

final class ApplicationFilterConfig
implements FilterConfig,
Serializable {
    private static Logger log = Logger.getLogger(ApplicationFilterConfig.class.getName());
    private StandardContext context = null;
    private transient Filter filter = null;
    private FilterDef filterDef = null;

    public ApplicationFilterConfig(StandardContext context, FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.context = context;
        this.setFilterDef(filterDef);
    }

    public String getFilterName() {
        return this.filterDef.getFilterName();
    }

    public String getInitParameter(String name) {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return null;
        }
        return (String)map.get(name);
    }

    public Enumeration getInitParameterNames() {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return new Enumerator(new ArrayList());
        }
        return new Enumerator(map.keySet());
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ApplicationFilterConfig[");
        sb.append("name=");
        sb.append(this.filterDef.getFilterName());
        sb.append(", filterClass=");
        sb.append(this.filterDef.getFilterClass());
        sb.append("]");
        return sb.toString();
    }

    Filter getFilter() throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        if (this.filter != null) {
            return this.filter;
        }
        String filterClass = this.filterDef.getFilterClass();
        ClassLoader classLoader = null;
        classLoader = filterClass.startsWith("org.apache.catalina.") ? this.getClass().getClassLoader() : this.context.getLoader().getClassLoader();
        ClassLoader oldCtxClassLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = classLoader.loadClass(filterClass);
        this.filter = (Filter)clazz.newInstance();
        if (this.context != null) {
            this.context.fireContainerEvent("beforeFilterInitialized", this.filter);
        }
        this.filter.init((FilterConfig)this);
        if (this.context != null) {
            this.context.fireContainerEvent("afterFilterInitialized", this.filter);
        }
        return this.filter;
    }

    FilterDef getFilterDef() {
        return this.filterDef;
    }

    void release() {
        if (this.filter != null) {
            if (this.context != null) {
                this.context.fireContainerEvent("beforeFilterDestroyed", this.filter);
            }
            if (SecurityUtil.executeUnderSubjectDoAs()) {
                try {
                    SecurityUtil.doAsPrivilege("destroy", this.filter);
                    SecurityUtil.remove(this.filter);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "ApplicationFilterConfig.doAsPrivilege", ex);
                }
            } else {
                this.filter.destroy();
            }
            if (this.context != null) {
                this.context.fireContainerEvent("afterFilterDestroyed", this.filter);
            }
        }
        this.filter = null;
    }

    void setFilterDef(FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.filterDef = filterDef;
        if (filterDef == null) {
            if (this.filter != null) {
                if (SecurityUtil.executeUnderSubjectDoAs()) {
                    try {
                        SecurityUtil.doAsPrivilege("destroy", this.filter);
                        SecurityUtil.remove(this.filter);
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, "ApplicationFilterConfig.doAsPrivilege", ex);
                    }
                } else {
                    this.filter.destroy();
                }
            }
            this.filter = null;
        } else {
            Filter filter = this.getFilter();
        }
    }
}

