/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;

public class ModifyColumnNode
extends ColumnDefinitionNode {
    int columnPosition = -1;
    UUID oldDefaultUUID;

    UUID getOldDefaultUUID() {
        return this.oldDefaultUUID;
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    public void checkUserType(TableDescriptor tableDescriptor) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeServices;
        if (this.getNodeType() != 186) {
            return;
        }
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.name);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)this.name, (Object)tableDescriptor.getName());
        }
        DataTypeDescriptor dataTypeDescriptor2 = columnDescriptor.getType();
        TypeId typeId = columnDescriptor.getType().getTypeId();
        TypeId typeId2 = this.dataTypeServices.getTypeId();
        dataTypeDescriptor.setNullability(dataTypeDescriptor2.isNullable());
        if (!typeId.equals(typeId2)) {
            throw StandardException.newException("42Z15", this.name);
        }
        String string = this.dataTypeServices.getTypeName();
        if (!(string.equals("NATIONAL CHAR VARYING") || string.equals("VARCHAR") || string.equals("VARCHAR () FOR BIT DATA"))) {
            throw StandardException.newException("42Z16");
        }
        if (dataTypeDescriptor.getMaximumWidth() < dataTypeDescriptor2.getMaximumWidth()) {
            throw StandardException.newException("42Z17", this.name);
        }
    }

    public void checkExistingConstraints(TableDescriptor tableDescriptor) throws StandardException {
        if (this.getNodeType() != 186 && this.getNodeType() != 187 && this.getNodeType() != 193) {
            return;
        }
        DataDictionary dataDictionary = this.getDataDictionary();
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        int[] nArray = new int[]{this.columnPosition};
        for (int i = 0; i < constraintDescriptorList.size(); ++i) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (!(constraintDescriptor instanceof KeyConstraintDescriptor) || !constraintDescriptor.columnIntersects(nArray)) continue;
            int n = constraintDescriptor.getConstraintType();
            if (n == 6 && this.getNodeType() == 186) {
                throw StandardException.newException("42Z18", (Object)this.name, (Object)constraintDescriptor.getConstraintName());
            }
            if (this.getNodeType() == 187 && (constraintDescriptor.getConstraintType() == 2 || constraintDescriptor.getConstraintType() == 3)) {
                throw StandardException.newException("42Z20", this.name);
            }
            ConstraintDescriptorList constraintDescriptorList2 = dataDictionary.getForeignKeys(constraintDescriptor.getUUID());
            if (constraintDescriptorList2.size() > 0) {
                throw StandardException.newException("42Z19", (Object)this.name, (Object)constraintDescriptorList2.elementAt(0).getConstraintName());
            }
            this.getCompilerContext().createDependency(constraintDescriptor);
        }
    }

    int getAction() {
        switch (this.getNodeType()) {
            case 97: {
                if (this.autoinc_create_or_modify_Start_Increment == 1L) {
                    return 5;
                }
                if (this.autoinc_create_or_modify_Start_Increment == 2L) {
                    return 6;
                }
                return 7;
            }
            case 186: {
                return 2;
            }
            case 187: {
                return 3;
            }
            case 193: {
                return 4;
            }
        }
        return 0;
    }

    void bindAndValidateDefault(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.name);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)this.name, (Object)tableDescriptor.getName());
        }
        DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(dataDictionary);
        this.oldDefaultUUID = defaultDescriptor == null ? null : defaultDescriptor.getUUID();
        this.columnPosition = columnDescriptor.getPosition();
        if (this.getNodeType() != 97) {
            return;
        }
        if (this.defaultNode == null) {
            this.defaultInfo = (DefaultInfoImpl)columnDescriptor.getDefaultInfo();
        }
        if (this.autoinc_create_or_modify_Start_Increment == 1L) {
            this.autoincrementIncrement = columnDescriptor.getAutoincInc();
        }
        if (this.autoinc_create_or_modify_Start_Increment == 2L) {
            this.autoincrementStart = columnDescriptor.getAutoincStart();
        }
        this.dataTypeServices = columnDescriptor.getType();
        this.validateDefault(dataDictionary, tableDescriptor);
    }

    private ColumnDescriptor getLocalColumnDescriptor(String string, TableDescriptor tableDescriptor) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)string, (Object)tableDescriptor.getName());
        }
        return columnDescriptor;
    }

    public void validateAutoincrement(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n) throws StandardException {
        ColumnDescriptor columnDescriptor;
        if (this.getNodeType() == 187 && (columnDescriptor = this.getLocalColumnDescriptor(this.name, tableDescriptor)).isAutoincrement()) {
            throw StandardException.newException("42Z26", this.getColumnName());
        }
        if (this.autoincrementVerify && !(columnDescriptor = this.getLocalColumnDescriptor(this.name, tableDescriptor)).isAutoincrement()) {
            throw StandardException.newException("42837", (Object)tableDescriptor.getQualifiedName(), (Object)this.name);
        }
        if (!this.isAutoincrement) {
            return;
        }
        super.validateAutoincrement(dataDictionary, tableDescriptor, n);
        if (this.dataTypeServices.isNullable()) {
            throw StandardException.newException("42Z27", this.getColumnName());
        }
    }
}

