/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.oxm.XMLField;

public class XMLUnionField
extends XMLField {
    private ArrayList schemaTypes = new ArrayList();

    public XMLUnionField() {
    }

    public XMLUnionField(String xPath) {
        super(xPath);
    }

    public ArrayList getSchemaTypes() {
        return this.schemaTypes;
    }

    public void setSchemaTypes(ArrayList value) {
        this.schemaTypes = value;
    }

    public void addSchemaType(QName value) {
        if (value != null) {
            if (this.schemaTypes == null) {
                this.schemaTypes = new ArrayList();
            }
            if (!this.contains(this.schemaTypes, value)) {
                this.schemaTypes.add(value);
            }
        }
    }

    public QName getSchemaType() {
        if (this.schemaTypes != null) {
            return (QName)this.getSchemaTypes().get(0);
        }
        return null;
    }

    public void setSchemaType(QName value) {
        this.addSchemaType(value);
    }

    private boolean contains(ArrayList types, QName value) {
        for (QName type : types) {
            if (!type.equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnionField() {
        return true;
    }

    public Object convertValueBasedOnSchemaType(Object value, XMLConversionManager xmlConversionManager) {
        Object convertedValue = value;
        for (int i = 0; i < this.schemaTypes.size(); ++i) {
            QName nextQName = (QName)this.schemaTypes.get(i);
            try {
                if (nextQName == null) continue;
                Class javaClass = this.getType();
                javaClass = this.getJavaClass(nextQName);
                convertedValue = xmlConversionManager.convertObject(value, javaClass, nextQName);
                break;
            }
            catch (ConversionException ce) {
                if (i != this.schemaTypes.size() - 1) continue;
                throw ce;
            }
        }
        return convertedValue;
    }

    public Class getJavaClass(QName qname) {
        if (this.userXMLTypes != null && this.userXMLTypes.containsKey(qname)) {
            return (Class)this.userXMLTypes.get(qname);
        }
        Class javaClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(qname);
        return XMLConversionManager.getObjectClass(javaClass);
    }
}

