/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.cometd.BayeuxCometHandlerBase;
import com.sun.grizzly.cometd.CometdContext;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.DataHandler;
import com.sun.grizzly.cometd.bayeux.Advice;
import com.sun.grizzly.cometd.bayeux.ConnectRequest;
import com.sun.grizzly.cometd.bayeux.ConnectResponse;
import com.sun.grizzly.cometd.bayeux.Data;
import com.sun.grizzly.cometd.bayeux.DeliverResponse;
import com.sun.grizzly.cometd.bayeux.DisconnectRequest;
import com.sun.grizzly.cometd.bayeux.DisconnectResponse;
import com.sun.grizzly.cometd.bayeux.HandshakeRequest;
import com.sun.grizzly.cometd.bayeux.HandshakeResponse;
import com.sun.grizzly.cometd.bayeux.PublishRequest;
import com.sun.grizzly.cometd.bayeux.PublishResponse;
import com.sun.grizzly.cometd.bayeux.ReconnectRequest;
import com.sun.grizzly.cometd.bayeux.ReconnectResponse;
import com.sun.grizzly.cometd.bayeux.SubscribeRequest;
import com.sun.grizzly.cometd.bayeux.SubscribeResponse;
import com.sun.grizzly.cometd.bayeux.UnsubscribeRequest;
import com.sun.grizzly.cometd.bayeux.UnsubscribeResponse;
import com.sun.grizzly.cometd.bayeux.Verb;
import com.sun.grizzly.cometd.bayeux.VerbBase;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BayeuxCometHandler
extends BayeuxCometHandlerBase {
    public static final String DEFAULT_CONTENT_TYPE = "application/json-comment-filtered";
    public static final String BAYEUX_COMET_HANDLER = "bayeuxCometHandler";
    private static Collection<String> BAYEUX_COMET_HANDLER_COLLECTION = Collections.unmodifiableCollection(Collections.singleton("bayeuxCometHandler"));
    private ConcurrentHashMap<String, Collection<String>> inactiveChannels = new ConcurrentHashMap();
    private ConcurrentLinkedQueue<String> authenticatedUsers = new ConcurrentLinkedQueue();
    private Random random = new Random();
    private ConcurrentHashMap<String, DataHandler> activeCometHandlers = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHandshake(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        HandshakeRequest handshakeReq = (HandshakeRequest)cometdContext.getVerb();
        HandshakeResponse handshakeRes = new HandshakeResponse(handshakeReq);
        handshakeRes.setAdvice(new Advice());
        if (handshakeReq.isValid()) {
            String clientId = null;
            Random random = this.random;
            synchronized (random) {
                clientId = String.valueOf(Long.toHexString(this.random.nextLong()));
            }
            handshakeRes.setClientId(clientId);
            this.authenticatedUsers.offer(clientId);
        } else {
            handshakeRes.setSuccessful(false);
            handshakeRes.setError("501::invalid handshake");
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(handshakeRes.toJSON());
        res.flush();
    }

    @Override
    public void onConnect(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        ConnectRequest connectReq = (ConnectRequest)cometdContext.getVerb();
        ConnectResponse connectRes = new ConnectResponse(connectReq);
        connectRes.setAdvice(new Advice());
        String errorMessage = this.isAuthenticatedAndValid(connectReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            boolean hasChannel = false;
            String clientId = connectReq.getClientId();
            DataHandler dataHandler = this.activeCometHandlers.get(clientId);
            if (dataHandler != null && dataHandler.getChannels().size() > 0) {
                hasChannel = true;
                dataHandler.attach(new Object[]{req, res});
                event.getCometContext().addCometHandler(dataHandler);
                connectRes.setAdvice(null);
            }
            String jsonMessage = hasChannel ? connectRes.toLongPolledJSON() : connectRes.toJSON();
            res.write(jsonMessage);
        } else {
            res.write(errorMessage);
        }
        res.flush();
    }

    @Override
    public void onDisconnect(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdResponse res = cometdContext.getResponse();
        DisconnectRequest disconnectReq = (DisconnectRequest)cometdContext.getVerb();
        DisconnectResponse disconnectRes = new DisconnectResponse(disconnectReq);
        String errorMessage = this.isAuthenticatedAndValid(disconnectReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            this.removeActiveHandler(disconnectReq.getClientId(), event.getCometContext());
            this.authenticatedUsers.remove(disconnectReq.getClientId());
            res.write(disconnectRes.toJSON());
        } else {
            res.write(errorMessage);
        }
        res.flush();
        this.notifyEnd(event, disconnectReq);
    }

    public boolean removeActiveHandler(String clientId, CometContext ctx) throws IOException {
        DataHandler dataHandler = this.activeCometHandlers.remove(clientId);
        if (dataHandler != null && ctx.isActive(dataHandler)) {
            ctx.notify("disconnecting", 3, dataHandler.hashCode());
            return true;
        }
        return false;
    }

    @Override
    public void onReconnect(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        ReconnectRequest reconnectReq = (ReconnectRequest)cometdContext.getVerb();
        ReconnectResponse reconnectRes = new ReconnectResponse(reconnectReq);
        String errorMessage = this.isAuthenticatedAndValid(reconnectReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            res.write(reconnectRes.toJSON());
        } else {
            res.write(errorMessage);
        }
        res.flush();
        this.notifyEnd(event, reconnectReq);
    }

    @Override
    public void onSubscribe(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        SubscribeRequest subscribeReq = (SubscribeRequest)cometdContext.getVerb();
        SubscribeResponse subscribeRes = new SubscribeResponse(subscribeReq);
        String errorMessage = this.isAuthenticatedAndValid(subscribeReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            String clientId = subscribeReq.getClientId();
            DataHandler dataHandler = this.activeCometHandlers.get(clientId);
            if (dataHandler == null) {
                dataHandler = new DataHandler(this);
                dataHandler.setClientId(clientId);
                DataHandler dh = this.activeCometHandlers.putIfAbsent(clientId, dataHandler);
                if (dh != null) {
                    dataHandler = dh;
                }
            }
            dataHandler.addChannel(subscribeReq.getSubscription());
            res.write(subscribeRes.toJSON());
        } else {
            res.write(errorMessage);
        }
        res.flush();
        this.notifyEnd(event, subscribeReq);
    }

    @Override
    public void onUnsubscribe(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        UnsubscribeRequest unsubscribeReq = (UnsubscribeRequest)cometdContext.getVerb();
        UnsubscribeResponse unsubscribeRes = new UnsubscribeResponse(unsubscribeReq);
        boolean hasSubscription = false;
        DataHandler dataHandler = null;
        String clientId = unsubscribeReq.getClientId();
        String subscription = unsubscribeReq.getSubscription();
        String errorMessage = this.isAuthenticatedAndValid(unsubscribeReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage == null) {
            dataHandler = this.activeCometHandlers.get(clientId);
            if (dataHandler != null && (hasSubscription = dataHandler.removeChannel(subscription))) {
                Collection<String> uscs;
                dataHandler.removeChannel(subscription);
                Collection<String> unsubscribedChannels = this.inactiveChannels.get(clientId);
                if (unsubscribedChannels == null && (uscs = this.inactiveChannels.putIfAbsent(clientId, unsubscribedChannels = new ConcurrentLinkedQueue<String>())) != null) {
                    unsubscribedChannels = uscs;
                }
                unsubscribedChannels.add(subscription);
            }
            unsubscribeRes.setSuccessful(hasSubscription);
            res.write(unsubscribeRes.toJSON());
        } else {
            res.write(errorMessage);
        }
        res.flush();
        this.notifyEnd(event, unsubscribeReq);
    }

    @Override
    public void onPublish(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdResponse res = cometdContext.getResponse();
        PublishRequest publishReq = (PublishRequest)cometdContext.getVerb();
        PublishResponse publishRes = new PublishResponse(publishReq);
        DeliverResponse deliverRes = null;
        String errorMessage = this.isAuthenticatedAndValid(publishReq);
        res.setContentType(DEFAULT_CONTENT_TYPE);
        if (errorMessage != null) {
            res.write(errorMessage);
        } else {
            String clientId;
            publishRes.setSuccessful(true);
            Data data = publishReq.getData();
            if (data != null) {
                deliverRes = new DeliverResponse(publishReq);
                deliverRes.setFollow(true);
                if (publishReq.isFirst()) {
                    deliverRes.setFirst(false);
                }
            }
            boolean hasWritten = false;
            if (deliverRes != null && (clientId = publishReq.getClientId()) != null) {
                Collection<String> subscribedChannels = null;
                DataHandler dataHandler = this.activeCometHandlers.get(clientId);
                if (dataHandler != null) {
                    subscribedChannels = dataHandler.getChannels();
                }
                if (subscribedChannels != null && subscribedChannels.contains(publishReq.getChannel())) {
                    hasWritten = true;
                    if (publishReq.isLast()) {
                        publishRes.setLast(false);
                    }
                    res.write(publishRes.toJSON());
                    res.write(deliverRes.toJSON());
                }
            }
            if (!hasWritten) {
                res.write(publishRes.toJSON());
            }
        }
        res.flush();
        if (deliverRes != null) {
            event.getCometContext().notify(deliverRes);
        }
        this.notifyEnd(event, publishReq);
    }

    private void notifyEnd(CometEvent event, VerbBase verb) throws IOException {
        String clientId;
        if (verb.isLast() && (clientId = verb.getClientId()) != null) {
            Collection<String> subscribedChannels = null;
            DataHandler dataHandler = this.activeCometHandlers.get(clientId);
            if (dataHandler != null) {
                subscribedChannels = dataHandler.getChannels();
            }
            Collection<String> unsubscribedChannels = this.inactiveChannels.get(clientId);
            if (subscribedChannels != null && subscribedChannels.size() > 0 || unsubscribedChannels != null && unsubscribedChannels.size() > 0) {
                event.getCometContext().notify("NOTIFY_END");
            }
            if (unsubscribedChannels != null) {
                unsubscribedChannels.clear();
                this.inactiveChannels.remove(clientId);
            }
        }
    }

    private String isAuthenticatedAndValid(VerbBase verb) {
        String clientId = verb.getClientId();
        if (clientId == null) {
            return null;
        }
        if (clientId != null && !this.authenticatedUsers.contains(clientId)) {
            return BayeuxCometHandler.constructError("402", "Unknown Client", verb.getMetaChannel());
        }
        if (!verb.isValid()) {
            return BayeuxCometHandler.constructError("501", "Invalid Operation", verb.getMetaChannel());
        }
        return null;
    }

    private static final String constructError(String errorMessage, String errorMsg, String meta) {
        StringBuilder sb = new StringBuilder();
        sb.append("[{\"successful\":false,\"error\":\"");
        sb.append(errorMessage);
        sb.append("::");
        sb.append(errorMsg);
        sb.append("\",\"advice\":{\"reconnect\":\"handshake\"},\"channel\":\"");
        sb.append(meta);
        sb.append("\"}]");
        return sb.toString();
    }

    public static final CometdContext newCometdContext(final CometdRequest req, final CometdResponse res, final Verb verb) {
        return new CometdContext(){

            public Verb getVerb() {
                return verb;
            }

            public CometdRequest getRequest() {
                return req;
            }

            public CometdResponse getResponse() {
                return res;
            }
        };
    }

    @Override
    public void onTerminate(CometEvent event) throws IOException {
        this.onInterrupt(event);
    }

    @Override
    public void onInterrupt(CometEvent event) throws IOException {
    }

    @Override
    public void onPing(CometEvent event) throws IOException {
    }

    @Override
    public void onStatus(CometEvent event) throws IOException {
    }

    @Override
    public Collection<String> getChannels() {
        return BAYEUX_COMET_HANDLER_COLLECTION;
    }

    @Override
    public void addChannel(String channel) {
    }

    @Override
    public boolean removeChannel(String channel) {
        return false;
    }
}

