/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.RepositoryChangeListener;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.common_impl.AbstractModulesRegistryImpl;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.InhabitantsParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.osgiadapter.BundleEventType;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiDirectoryBasedRepository;
import org.jvnet.hk2.osgiadapter.OSGiFactoryImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HK2Main
extends Main
implements BundleActivator,
SynchronousBundleListener {
    private BundleContext ctx;
    private ModulesRegistry mr;
    private Habitat habitat;
    private String repName = "modules";
    private static final String CONTEXT_ROOT_DIR_PROP = HK2Main.class.getPackage().getName() + ".contextrootdir";
    private File contextRootDir;
    private ModuleStartup moduleStartup;

    public void start(BundleContext context) throws Exception {
        StartupContext startupContext;
        this.ctx = context;
        Logger.logger.logp(Level.FINE, "HK2Main", "run", "Thread.currentThread().getContextClassLoader() = {0}", Thread.currentThread().getContextClassLoader());
        Logger.logger.logp(Level.FINE, "HK2Main", "run", "this.getClass().getClassLoader() = {0}", ((Object)((Object)this)).getClass().getClassLoader());
        this.ctx.addBundleListener((BundleListener)this);
        this.contextRootDir = this.getContextRootDir(context);
        Logger.logger.logp(Level.FINE, "HK2Main", "start", "contextRootDir = {0}", this.contextRootDir);
        String lineformat = System.getProperty("glassfish.startup.context");
        if (lineformat != null) {
            Properties arguments = new Properties();
            ByteArrayInputStream is = new ByteArrayInputStream(lineformat.getBytes());
            arguments.load(is);
            startupContext = new StartupContext(this.contextRootDir, arguments);
        } else {
            startupContext = new StartupContext(this.contextRootDir, new String[0]);
        }
        OSGiFactoryImpl.initialize(this.ctx);
        this.mr = this.createModulesRegistry();
        this.habitat = this.createHabitat(this.mr, startupContext);
        this.createServiceTracker(this.habitat);
        this.moduleStartup = this.launch(this.mr, this.habitat, null, startupContext);
    }

    protected ModulesRegistry createModulesRegistry() {
        ModulesRegistry mr = AbstractFactory.getInstance().createModulesRegistry();
        Collection<? extends Repository> reps = this.createRepositories();
        for (Repository repository : reps) {
            mr.addRepository(repository);
        }
        return mr;
    }

    protected File getContextRootDir(BundleContext context) {
        String prop = context.getProperty(CONTEXT_ROOT_DIR_PROP);
        File f = prop != null ? new File(prop) : new File(System.getProperty("user.home"));
        return f;
    }

    protected void setParentClassLoader(StartupContext context, ModulesRegistry mr) throws BootException {
    }

    private void createServiceTracker(Habitat habitat) {
        ServiceTracker st = new ServiceTracker(this.ctx, (Filter)new NonHK2ServiceFilter(), (ServiceTrackerCustomizer)new HK2ServiceTrackerCustomizer(habitat));
        st.open(true);
    }

    private Collection<? extends Repository> createRepositories() {
        ArrayList<OSGiDirectoryBasedRepository> reps = new ArrayList<OSGiDirectoryBasedRepository>();
        OSGiDirectoryBasedRepository rep = new OSGiDirectoryBasedRepository(this.repName, this.contextRootDir, true);
        try {
            rep.initialize();
            reps.add(rep);
        }
        catch (IOException e) {
            try {
                rep.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
        for (File dir : this.contextRootDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            rep = new OSGiDirectoryBasedRepository(dir.getName(), dir);
            try {
                rep.initialize();
                reps.add(rep);
            }
            catch (IOException e) {
                try {
                    rep.shutdown();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                Logger.logger.log(Level.SEVERE, "Cannot initialize repository at " + dir.getAbsolutePath(), e);
            }
        }
        for (Repository repository : reps) {
            repository.addListener(new RepositoryChangeListener(){

                public void added(URI location) {
                    try {
                        File file = new File(location);
                        if (file.isDirectory()) {
                            HK2Main.this.initializeRepo((Repository)new OSGiDirectoryBasedRepository(file.getName(), file), HK2Main.this.habitat, HK2Main.this.mr);
                        }
                    }
                    catch (IOException e) {
                        Logger.logger.log(Level.SEVERE, "Exception while adding new repository of modules", e);
                    }
                }

                public void removed(URI location) {
                }

                public void moduleAdded(ModuleDefinition definition) {
                    InhabitantsParser parser = new InhabitantsParser(HK2Main.this.habitat);
                    Module module = HK2Main.this.mr.add(definition);
                    try {
                        ((AbstractModulesRegistryImpl)HK2Main.this.mr).parseInhabitants(module, "default", parser);
                    }
                    catch (IOException e) {
                        Logger.logger.log(Level.WARNING, "Exception while processing newly added module ", e);
                    }
                }

                public void moduleRemoved(ModuleDefinition definition) {
                }
            });
        }
        Logger.logger.exiting("HK2Main", "createRepositories", reps);
        return reps;
    }

    public void stop(BundleContext context) throws Exception {
        this.moduleStartup.stop();
        if (this.mr != null) {
            this.mr.shutdown();
        }
    }

    public void bundleChanged(BundleEvent event) {
        Logger.logger.logp(Level.FINE, "BundleListenerImpl", "bundleChanged", "source= {0}, type= {1}", new Object[]{event.getSource(), BundleEventType.valueOf(event.getType())});
    }

    private void initializeRepo(Repository repo, Habitat habitat, ModulesRegistry mr) throws IOException {
        block6: {
            try {
                repo.initialize();
            }
            catch (IOException e) {
                Logger.logger.info("Exception while processing jars in newly added repository");
                int maxTry = 10;
                boolean done = false;
                while (!done && maxTry > 0) {
                    try {
                        repo.initialize();
                        done = true;
                    }
                    catch (IOException ex) {
                        Logger.logger.warning("Error while processing, " + --maxTry + " tries left");
                    }
                }
                if (done) break block6;
                Logger.logger.log(Level.SEVERE, "Exception while processing jars in newly added repository", e);
            }
        }
        mr.addRepository(repo);
        InhabitantsParser parser = new InhabitantsParser(habitat);
        for (Module module : mr.getModules()) {
            if (repo.find(module.getModuleDefinition().getName(), module.getModuleDefinition().getVersion()) == null) continue;
            ((AbstractModulesRegistryImpl)mr).parseInhabitants(module, "default", parser);
        }
    }

    private class HK2ServiceTrackerCustomizer
    implements ServiceTrackerCustomizer {
        private final Habitat habitat;

        private HK2ServiceTrackerCustomizer(Habitat habitat) {
            this.habitat = habitat;
        }

        public Object addingService(ServiceReference reference) {
            Object object = HK2Main.this.ctx.getService(reference);
            String[] contractNames = (String[])reference.getProperty("objectclass");
            if (contractNames != null && contractNames.length > 0) {
                for (String contractName : contractNames) {
                    String name = (String)reference.getProperty("org.springframework.osgi.bean.name");
                    this.habitat.addIndex((Inhabitant)new ExistingSingletonInhabitant(object), contractName, name);
                    Logger.logger.logp(Level.INFO, "HK2Main$HK2ServiceTrackerCustomizer", "addingService", "registering service = {0}, contract = {1}, name = {2}", new Object[]{object, contractName, name});
                }
            } else {
                this.habitat.add((Inhabitant)new ExistingSingletonInhabitant(object));
                Logger.logger.logp(Level.INFO, "HK2Main$HK2ServiceTrackerCustomizer", "addingService", "registering service = {0}", object);
            }
            return object;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            String[] contractNames = (String[])reference.getProperty("objectclass");
            if (contractNames != null && contractNames.length > 0) {
                for (String contractName : contractNames) {
                    this.habitat.removeIndex(contractName, service);
                    Logger.logger.logp(Level.INFO, "HK2Main$HK2ServiceTrackerCustomizer", "removingService", "removing service = {0}, contract = {1}", new Object[]{service, contractName});
                }
            } else {
                Inhabitant inhabitant = this.habitat.getInhabitantByType(service.getClass());
                if (inhabitant != null) {
                    this.habitat.remove(inhabitant);
                } else {
                    Logger.logger.logp(Level.WARNING, "HK2Main$HK2ServiceTrackerCustomizer", "removedService", "cannot removed singleton service = {0}", service);
                }
            }
        }
    }

    private class NonHK2ServiceFilter
    implements Filter {
        private NonHK2ServiceFilter() {
        }

        public boolean match(ServiceReference serviceReference) {
            return !HK2Main.this.ctx.getBundle().equals(serviceReference.getBundle());
        }

        public boolean match(Dictionary dictionary) {
            throw new RuntimeException("Unexpected method called");
        }

        public boolean matchCase(Dictionary dictionary) {
            throw new RuntimeException("Unexpected method called");
        }

        public String toString() {
            return "(objectClass=*)";
        }
    }
}

