/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.LifecyclePolicy;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleChangeListener;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantsParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiModulesRegistryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.RequiredBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OSGiModuleImpl
implements Module {
    private Bundle bundle;
    private ModuleDefinition md;
    private OSGiModulesRegistryImpl registry;
    private ModuleState state;
    private boolean isTransientlyActive = false;
    private LifecyclePolicy lifecyclePolicy;

    public OSGiModuleImpl(OSGiModulesRegistryImpl registry, Bundle bundle, ModuleDefinition md) {
        this.registry = registry;
        this.bundle = bundle;
        this.md = md;
        switch (bundle.getState()) {
            case 1: 
            case 2: {
                this.state = ModuleState.NEW;
                break;
            }
            case 4: {
                this.state = ModuleState.RESOLVED;
                break;
            }
            case 8: {
                this.state = ModuleState.PREPARING;
                break;
            }
            case 32: {
                this.state = ModuleState.READY;
                break;
            }
            default: {
                throw new RuntimeException("Does not know how to handle bundle with state [" + bundle.getState() + "]");
            }
        }
    }

    public ModuleDefinition getModuleDefinition() {
        return this.md;
    }

    public String getName() {
        return this.md.getName();
    }

    public ModulesRegistry getRegistry() {
        return this.registry;
    }

    public ModuleState getState() {
        return this.state;
    }

    public synchronized void resolve() throws ResolveError {
        this.start();
    }

    public synchronized void start() throws ResolveError {
        if (this.state == ModuleState.READY) {
            return;
        }
        try {
            if ((this.bundle.getState() & 0x20) == 0) {
                this.bundle.start();
                this.isTransientlyActive = true;
                Logger.logger.logp(Level.INFO, "OSGiModuleImpl", "start", "Started bundle {0}", this.bundle);
            }
        }
        catch (BundleException e) {
            throw new ResolveError("Failed to start " + this, (Throwable)e);
        }
        if (this.md.getLifecyclePolicyClassName() != null) {
            try {
                Class lifecyclePolicyClass = this.bundle.loadClass(this.md.getLifecyclePolicyClassName());
                this.lifecyclePolicy = (LifecyclePolicy)lifecyclePolicyClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                this.state = ModuleState.ERROR;
                throw new ResolveError("ClassNotFound : " + e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                this.state = ModuleState.ERROR;
                throw new ResolveError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.state = ModuleState.ERROR;
                throw new ResolveError((Throwable)e);
            }
        }
        if (this.lifecyclePolicy != null) {
            this.lifecyclePolicy.start((Module)this);
        }
        this.state = ModuleState.READY;
    }

    public synchronized boolean stop() {
        this.detach();
        this.state = ModuleState.NEW;
        return true;
    }

    public void detach() {
        if ((this.bundle.getState() & 2) != 0) {
            return;
        }
        if (this.lifecyclePolicy != null) {
            this.lifecyclePolicy.stop((Module)this);
            this.lifecyclePolicy = null;
        }
        try {
            this.bundle.stop();
            Logger.logger.logp(Level.INFO, "OSGiModuleImpl", "detach", "Stopped bundle = {0}", new Object[]{this.bundle});
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
        this.state = ModuleState.NEW;
    }

    public void uninstall() {
        try {
            this.bundle.uninstall();
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
        this.registry.remove(this);
        this.registry = null;
    }

    public void refresh() {
        URI location = this.md.getLocations()[0];
        File f = new File(location);
        if (f.lastModified() > this.bundle.getLastModified()) {
            try {
                this.bundle.update();
                this.registry.getPackageAdmin().refreshPackages(new Bundle[]{this.bundle});
            }
            catch (BundleException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ModuleMetadata getMetadata() {
        return this.md.getMetadata();
    }

    public <T> Iterable<Class<? extends T>> getProvidersClass(Class<T> serviceClass) {
        return this.getProvidersClass(serviceClass.getName());
    }

    public Iterable<Class> getProvidersClass(String name) {
        ArrayList<Class> r = new ArrayList<Class>();
        for (String provider : this.getMetadata().getEntry((String)name).providerNames) {
            try {
                r.add(this.getClassLoader().loadClass(provider));
            }
            catch (ClassNotFoundException e) {
                Logger.logger.log(Level.SEVERE, "Failed to load " + provider + " from " + this.getName(), e);
            }
        }
        return r;
    }

    public boolean hasProvider(Class serviceClass) {
        String name = serviceClass.getName();
        return this.getMetadata().getEntry(name).hasProvider();
    }

    public void addListener(ModuleChangeListener listener) {
        this.registry.addModuleChangeListener(listener, this);
    }

    public void removeListener(ModuleChangeListener listener) {
        this.registry.removeModuleChangeListener(listener);
    }

    public void dumpState(PrintStream writer) {
        writer.print(this.bundle.toString());
    }

    void parseInhabitants(String name, InhabitantsParser parser) throws IOException {
        Holder<ClassLoader> holder = new Holder<ClassLoader>(){

            public ClassLoader get() {
                ClassLoader ret = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new ClassLoader(){

                            @Override
                            public synchronized Class<?> loadClass(final String name) throws ClassNotFoundException {
                                if (Logger.logger.isLoggable(Level.FINE)) {
                                    Logger.logger.logp(Level.FINE, "OSGiModuleImpl", "loadClass", "Loading {0} from bundle: {1}", new Object[]{name, OSGiModuleImpl.this.bundle});
                                }
                                OSGiModuleImpl.this.start();
                                try {
                                    Class aClass = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                                        public Object run() {
                                            try {
                                                return OSGiModuleImpl.this.bundle.loadClass(name);
                                            }
                                            catch (Throwable e) {
                                                Logger.logger.logp(Level.SEVERE, "OSGiModuleImpl", "loadClass", "Exception in module " + OSGiModuleImpl.this.bundle.toString() + " : " + e.toString());
                                                throw new RuntimeException(e);
                                            }
                                        }
                                    });
                                    if (Logger.logger.isLoggable(Level.FINE)) {
                                        Logger.logger.logp(Level.FINE, "OSGiModuleImpl", "loadClass", name + ".class.getClassLoader() = {0}", aClass.getClassLoader());
                                    }
                                    return aClass;
                                }
                                catch (RuntimeException e) {
                                    Logger.logger.logp(Level.SEVERE, "OSGiModuleImpl", "loadClass", "Exception in module " + OSGiModuleImpl.this.bundle.toString() + " : " + e.toString());
                                    throw new ClassNotFoundException(e.getCause().getMessage(), e.getCause());
                                }
                            }
                        };
                    }
                });
                return ret;
            }
        };
        for (ModuleMetadata.InhabitantsDescriptor d : this.md.getMetadata().getHabitats(name)) {
            parser.parse(d.createScanner(), (Holder)holder);
        }
    }

    public ClassLoader getClassLoader() {
        return new ClassLoader(Bundle.class.getClassLoader()){
            public static final String META_INF_SERVICES = "META-INF/services/";

            @Override
            protected synchronized Class<?> loadClass(final String name, boolean resolve) throws ClassNotFoundException {
                try {
                    Class ret = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                return OSGiModuleImpl.this.bundle.loadClass(name);
                            }
                            catch (ClassNotFoundException e) {
                                OSGiModuleImpl m = (OSGiModuleImpl)OSGiModuleImpl.this.registry.getProvidingModule(name);
                                if (m != null) {
                                    try {
                                        return m.bundle.loadClass(name);
                                    }
                                    catch (ClassNotFoundException ex) {
                                        throw new RuntimeException(ex);
                                    }
                                }
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    return ret;
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)e.getCause();
                    }
                    throw e;
                }
            }

            @Override
            public URL getResource(String name) {
                URL result = OSGiModuleImpl.this.bundle.getResource(name);
                if (result != null) {
                    return result;
                }
                if (name.startsWith(META_INF_SERVICES)) {
                    String serviceName = name.substring(META_INF_SERVICES.length());
                    for (Module m : OSGiModuleImpl.this.registry.getModules()) {
                        List list = m.getMetadata().getDescriptors(serviceName);
                        if (list.isEmpty()) continue;
                        return (URL)list.get(0);
                    }
                }
                return null;
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                if (name.startsWith(META_INF_SERVICES)) {
                    Enumeration<URL> parentResources = Bundle.class.getClassLoader().getResources(name);
                    String serviceName = name.substring(META_INF_SERVICES.length());
                    ArrayList punchedInURLs = new ArrayList();
                    for (Module m : OSGiModuleImpl.this.registry.getModules()) {
                        punchedInURLs.addAll(m.getMetadata().getDescriptors(serviceName));
                    }
                    ArrayList enumerators = new ArrayList();
                    enumerators.add(parentResources);
                    enumerators.add(Collections.enumeration(punchedInURLs));
                    CompositeEnumeration result = new CompositeEnumeration(enumerators);
                    return result;
                }
                Enumeration resources = OSGiModuleImpl.this.bundle.getResources(name);
                if (resources == null) {
                    resources = new Enumeration<URL>(){

                        @Override
                        public boolean hasMoreElements() {
                            return false;
                        }

                        @Override
                        public URL nextElement() {
                            throw new NoSuchElementException();
                        }
                    };
                }
                return resources;
            }

            public String toString() {
                return "Class Loader for Bundle [" + OSGiModuleImpl.this.bundle.toString() + " ]";
            }
        };
    }

    public void addImport(Module module) {
        throw new UnsupportedOperationException("This method can't be implemented in OSGi environment");
    }

    public Module addImport(ModuleDependency dependency) {
        throw new UnsupportedOperationException("This method can't be implemented in OSGi environment");
    }

    public boolean isSticky() {
        return true;
    }

    public void setSticky(boolean sticky) {
    }

    public List<Module> getImports() {
        ArrayList<Module> result = new ArrayList<Module>();
        RequiredBundle[] requiredBundles = this.registry.getPackageAdmin().getRequiredBundles(this.bundle.getSymbolicName());
        if (requiredBundles != null) {
            for (RequiredBundle rb : requiredBundles) {
                Module m = this.registry.getModule(rb.getBundle());
                if (m == null) continue;
                result.add(m);
            }
        }
        return result;
    }

    public boolean isShared() {
        return true;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public boolean isTransientlyActive() {
        return this.isTransientlyActive;
    }

    public String toString() {
        return this.md.toString();
    }
}

