/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.WebModule;
import java.beans.PropertyChangeEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.monitoring.TelemetryProvider;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.ProbeProviderEventManager;
import org.glassfish.flashlight.provider.ProbeProviderListener;
import org.glassfish.web.admin.monitor.telemetry.JspStatsTelemetry;
import org.glassfish.web.admin.monitor.telemetry.ServletStatsTelemetry;
import org.glassfish.web.admin.monitor.telemetry.SessionStatsTelemetry;
import org.glassfish.web.admin.monitor.telemetry.WebRequestTelemetry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="web-container")
@Scoped(value=Singleton.class)
public class WebTelemetryBootstrap
implements ProbeProviderListener,
TelemetryProvider,
PostConstruct,
ConfigListener {
    @Inject
    Logger logger;
    @Inject
    private static Domain domain;
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    private ProbeProviderEventManager ppem;
    @Inject
    private ProbeClientMediator pcm;
    private boolean requestProviderRegistered = false;
    private boolean servletProviderRegistered = false;
    private boolean jspProviderRegistered = false;
    private boolean sessionProviderRegistered = false;
    private boolean probeProviderListenerRegistered = false;
    private boolean webMonitoringEnabled = false;
    private boolean isWebTreeBuilt = false;
    private WebRequestTelemetry webRequestTM = null;
    private SessionStatsTelemetry webSessionsTM = null;
    private List<SessionStatsTelemetry> vsSessionTMs = null;
    private ServletStatsTelemetry webServletsTM = null;
    private List<ServletStatsTelemetry> vsServletTMs = null;
    private List<WebRequestTelemetry> vsRequestTMs = null;
    private JspStatsTelemetry webJspTM = null;
    private List<JspStatsTelemetry> vsJspTMs = null;
    private TreeNode serverNode;
    private TreeNode webNode;
    private TreeNode webSessionNode;
    private TreeNode webServletNode;
    private TreeNode webJspNode;
    private TreeNode webRequestNode;
    private TreeNode applicationsNode;
    private static HttpService httpService;

    public void postConstruct() {
        Level dbgLevel = Level.FINEST;
        Level defaultLevel = this.logger.getLevel();
        if (defaultLevel == null || dbgLevel.intValue() < defaultLevel.intValue()) {
            // empty if block
        }
        this.logger.finest("[Monitor]In the WebTelemetry bootstrap ************");
        this.buildTopLevelMonitoringTree();
        List lc = domain.getConfigs().getConfig();
        Config config = null;
        for (Config cf : lc) {
            if (!cf.getName().equals("server-config")) continue;
            config = cf;
            break;
        }
        httpService = config.getHttpService();
    }

    public void onLevelChange(String newLevel) {
        boolean newLevelEnabledValue = this.getEnabledValue(newLevel);
        this.logger.finest("[Monitor]In the Level Change = " + newLevel + "  ************");
        if (this.webMonitoringEnabled == newLevelEnabledValue) {
            return;
        }
        this.webMonitoringEnabled = newLevelEnabledValue;
        if (this.webMonitoringEnabled) {
            if (!this.probeProviderListenerRegistered) {
                this.registerProbeProviderListener();
            } else {
                this.enableWebMonitoring(true);
            }
        } else {
            this.enableWebMonitoring(false);
        }
    }

    public void providerRegistered(String moduleName, String providerName, String appName) {
        try {
            this.logger.finest("[Monitor]Provider registered event received - providerName = " + providerName + " : module name = " + moduleName + " : appName = " + appName);
            if (providerName.equals("session")) {
                this.logger.finest("[Monitor]and it is Web session");
                this.buildWebMonitoringTree();
                this.sessionProviderRegistered = true;
                if (!this.isWebTreeBuilt) {
                    return;
                }
                this.buildSessionTelemetry();
            }
            if (providerName.equals("servlet")) {
                this.logger.finest("[Monitor]and it is Web servlet");
                this.buildWebMonitoringTree();
                this.servletProviderRegistered = true;
                if (!this.isWebTreeBuilt) {
                    return;
                }
                this.buildServletTelemetry();
            }
            if (providerName.equals("jsp")) {
                this.logger.finest("[Monitor]and it is Web jsp");
                this.buildWebMonitoringTree();
                this.jspProviderRegistered = true;
                if (!this.isWebTreeBuilt) {
                    return;
                }
                this.buildJspTelemetry();
            }
            if (providerName.equals("request")) {
                this.logger.finest("[Monitor]and it is Web request");
                this.buildWebMonitoringTree();
                this.requestProviderRegistered = true;
                if (!this.isWebTreeBuilt) {
                    return;
                }
                this.buildWebRequestTelemetry();
            }
        }
        catch (Exception e) {
            this.logger.finest("[Monitor]WARNING: Exception in WebMonitorStartup : " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void providerUnregistered(String moduleName, String providerName, String appName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private boolean getEnabledValue(String enabledStr) {
        return !"OFF".equals(enabledStr);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        for (PropertyChangeEvent event : events) {
            if (!event.getPropertyName().equals("application-ref")) continue;
            String propName = event.getPropertyName();
            String appName = null;
            if (event.getNewValue() != null) {
                appName = ((ApplicationRef)event.getNewValue()).getRef();
                this.updateApplicationSubTree(appName, true);
            } else if (event.getOldValue() != null) {
                appName = ((ApplicationRef)event.getOldValue()).getRef();
                this.updateApplicationSubTree(appName, false);
            }
            this.logger.finest("[Monitor] (Un)Deploy event received - name = " + propName + " : Value = " + appName);
        }
        return null;
    }

    private void registerProbeProviderListener() {
        this.ppem.registerProbeProviderListener((ProbeProviderListener)this);
        this.probeProviderListenerRegistered = true;
    }

    private void buildTopLevelMonitoringTree() {
        if (this.serverNode != null) {
            return;
        }
        if (this.mrdr.get("server") != null) {
            this.serverNode = this.mrdr.get("server");
            return;
        }
        Server srvr = null;
        List ls = domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            srvr = sr;
            break;
        }
        this.serverNode = TreeNodeFactory.createTreeNode((String)"server", null, (String)"server");
        this.mrdr.add("server", this.serverNode);
    }

    private void buildWebMonitoringTree() {
        if (this.isWebTreeBuilt || !this.webMonitoringEnabled) {
            return;
        }
        Server srvr = null;
        List ls = domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            srvr = sr;
            break;
        }
        this.logger.finest("[Monitor]Web Monitoring tree is being built");
        this.webNode = TreeNodeFactory.createTreeNode((String)"web", null, (String)"web");
        this.serverNode.addChild(this.webNode);
        this.webSessionNode = TreeNodeFactory.createTreeNode((String)"session", null, (String)"web");
        this.webNode.addChild(this.webSessionNode);
        this.webServletNode = TreeNodeFactory.createTreeNode((String)"servlet", null, (String)"web");
        this.webNode.addChild(this.webServletNode);
        this.webJspNode = TreeNodeFactory.createTreeNode((String)"jsp", null, (String)"web");
        this.webNode.addChild(this.webJspNode);
        this.webRequestNode = TreeNodeFactory.createTreeNode((String)"request", (Object)this, (String)"web");
        this.webNode.addChild(this.webRequestNode);
        this.applicationsNode = TreeNodeFactory.createTreeNode((String)"applications", null, (String)"web");
        this.serverNode.addChild(this.applicationsNode);
        List la = domain.getApplications().getModules(Application.class);
        for (Application sapp : la) {
            TreeNode app = TreeNodeFactory.createTreeNode((String)sapp.getName(), null, (String)"web");
            this.applicationsNode.addChild(app);
            this.addVirtualServers(srvr, app, sapp.getName());
        }
        List lja = domain.getApplications().getModules(J2eeApplication.class);
        for (J2eeApplication japp : lja) {
            TreeNode app = TreeNodeFactory.createTreeNode((String)japp.getName(), null, (String)"web");
            this.applicationsNode.addChild(app);
        }
        List lm = domain.getApplications().getModules(WebModule.class);
        for (WebModule wm : lm) {
            TreeNode app = TreeNodeFactory.createTreeNode((String)wm.getName(), null, (String)"web");
            this.applicationsNode.addChild(app);
            this.addVirtualServers(srvr, app, wm.getName());
        }
        this.isWebTreeBuilt = true;
    }

    private void updateApplicationSubTree(String appName, boolean isDeployed) {
        this.logger.finest("Updating the tree for the Deployed(" + isDeployed + ") App=" + appName);
        if (isDeployed) {
            if (!this.isWebTreeBuilt) {
                return;
            }
            Server srvr = null;
            List ls = domain.getServers().getServer();
            for (Server sr : ls) {
                if (!"server".equals(sr.getName())) continue;
                srvr = sr;
                break;
            }
            TreeNode app = TreeNodeFactory.createTreeNode((String)appName, null, (String)"web");
            this.applicationsNode.addChild(app);
            this.addVirtualServers(srvr, app, appName);
            TreeNode appsNode = this.serverNode.getNode("applications");
            Collection appNodes = appsNode.getChildNodes();
            for (TreeNode appNode : appNodes) {
                if (!appNode.getName().equals(appName)) continue;
                Collection vsNodes = appNode.getChildNodes();
                for (TreeNode vsNode : vsNodes) {
                    this.buildWebRequestTelemetryForVS(vsNode, appName);
                    this.buildJSPTelemetryForVS(vsNode, appNode.getName());
                    this.buildServletTelemetryForVS(vsNode, appName);
                    this.buildSessionTelemetryForVS(vsNode, appName);
                }
            }
        } else {
            Collection appNodes = this.applicationsNode.getChildNodes();
            TreeNode appNodeToRemove = null;
            for (TreeNode appNode : appNodes) {
                if (!appNode.getName().equals(appName)) continue;
                Collection vsNodes = appNode.getChildNodes();
                for (TreeNode vsNode : vsNodes) {
                    String vsName = vsNode.getName();
                    this.removeJSPTelemetryForVS(appName, vsName);
                    this.removeServletTelemetryForVS(appName, vsName);
                    this.removeSessionTelemetryForVS(appName, vsName);
                    this.removeRequestTelemetryForVS(appName, vsName);
                }
                appNode.setEnabled(false);
                appNodeToRemove = appNode;
                break;
            }
            if (appNodeToRemove != null) {
                this.applicationsNode.removeChild(appNodeToRemove);
            }
        }
    }

    private void addVirtualServers(Server server, TreeNode tn, String appName) {
        for (ApplicationRef ar : server.getApplicationRef()) {
            if (!appName.equals(ar.getRef())) continue;
            String vsL = ar.getVirtualServers();
            if (vsL != null) {
                for (String str : vsL.split(",")) {
                    TreeNode vs = TreeNodeFactory.createTreeNode((String)str, null, (String)"web");
                    tn.addChild(vs);
                }
            } else {
                this.addUserVirtualServers(tn);
            }
            return;
        }
    }

    private void addUserVirtualServers(TreeNode tn) {
        List lc = domain.getConfigs().getConfig();
        Config config = null;
        for (Config cf : lc) {
            if (!cf.getName().equals("server-config")) continue;
            config = cf;
            break;
        }
        httpService = config.getHttpService();
        for (VirtualServer vs : httpService.getVirtualServer()) {
            if (vs.getId().equals("__asadmin")) continue;
            TreeNode vsNode = TreeNodeFactory.createTreeNode((String)vs.getId(), null, (String)"web");
            tn.addChild(vsNode);
        }
    }

    private void buildJspTelemetry() {
        if (this.webJspTM == null) {
            this.webJspTM = new JspStatsTelemetry(this.webJspNode, null, null, this.webMonitoringEnabled, this.logger);
            Collection handles = this.pcm.registerListener((Object)this.webJspTM);
            this.webJspTM.setProbeListenerHandles(handles);
        } else if (!this.webJspTM.isEnabled()) {
            this.webJspTM.enableMonitoring(true);
        }
        if (this.vsJspTMs == null) {
            this.vsJspTMs = new ArrayList<JspStatsTelemetry>();
            TreeNode appsNode = this.serverNode.getNode("applications");
            Collection appNodes = appsNode.getChildNodes();
            for (TreeNode appNode : appNodes) {
                Collection vsNodes = appNode.getChildNodes();
                for (TreeNode vsNode : vsNodes) {
                    this.buildJSPTelemetryForVS(vsNode, appNode.getName());
                }
            }
        } else {
            for (JspStatsTelemetry jspTM : this.vsJspTMs) {
                if (jspTM.isEnabled()) continue;
                jspTM.enableMonitoring(true);
            }
        }
    }

    private void buildJSPTelemetryForVS(TreeNode vsNode, String appName) {
        if (!this.jspProviderRegistered) {
            return;
        }
        JspStatsTelemetry vsJspTM = new JspStatsTelemetry(vsNode, appName, vsNode.getName(), this.webMonitoringEnabled, this.logger);
        Collection handles = this.pcm.registerListener((Object)vsJspTM);
        vsJspTM.setProbeListenerHandles(handles);
        this.vsJspTMs.add(vsJspTM);
    }

    private void removeJSPTelemetryForVS(String appName, String vsName) {
        if (!this.jspProviderRegistered || !this.isWebTreeBuilt || this.vsJspTMs == null) {
            return;
        }
        ArrayList<JspStatsTelemetry> jspTMsToRemove = new ArrayList<JspStatsTelemetry>();
        for (JspStatsTelemetry vsJspTM : this.vsJspTMs) {
            if (!vsJspTM.getModuleName().equals(appName) || !vsJspTM.getVSName().equals(vsName)) continue;
            jspTMsToRemove.add(vsJspTM);
            vsJspTM.enableMonitoring(false);
        }
        for (JspStatsTelemetry jspTMToRemove : jspTMsToRemove) {
            this.vsJspTMs.remove(jspTMToRemove);
        }
    }

    private void buildServletTelemetry() {
        if (this.webServletsTM == null) {
            this.webServletsTM = new ServletStatsTelemetry(this.webServletNode, null, null, this.webMonitoringEnabled, this.logger);
            Collection handles = this.pcm.registerListener((Object)this.webServletsTM);
            this.webServletsTM.setProbeListenerHandles(handles);
        } else if (this.webServletsTM.isEnabled()) {
            this.webServletsTM.enableMonitoring(true);
        }
        if (this.vsServletTMs == null) {
            this.vsServletTMs = new ArrayList<ServletStatsTelemetry>();
            TreeNode appsNode = this.serverNode.getNode("applications");
            Collection appNodes = appsNode.getChildNodes();
            for (TreeNode appNode : appNodes) {
                Collection vsNodes = appNode.getChildNodes();
                for (TreeNode vsNode : vsNodes) {
                    this.buildServletTelemetryForVS(vsNode, appNode.getName());
                }
            }
        } else {
            for (ServletStatsTelemetry servletTM : this.vsServletTMs) {
                if (servletTM.isEnabled()) continue;
                servletTM.enableMonitoring(true);
            }
        }
    }

    private void buildServletTelemetryForVS(TreeNode vsNode, String appName) {
        if (!this.servletProviderRegistered) {
            return;
        }
        ServletStatsTelemetry vsServletTM = new ServletStatsTelemetry(vsNode, appName, vsNode.getName(), this.webMonitoringEnabled, this.logger);
        Collection handles = this.pcm.registerListener((Object)vsServletTM);
        vsServletTM.setProbeListenerHandles(handles);
        this.vsServletTMs.add(vsServletTM);
    }

    private void removeServletTelemetryForVS(String appName, String vsName) {
        if (!this.servletProviderRegistered || !this.isWebTreeBuilt || this.vsServletTMs == null) {
            return;
        }
        ArrayList<ServletStatsTelemetry> servletTMsToRemove = new ArrayList<ServletStatsTelemetry>();
        for (ServletStatsTelemetry vsServletTM : this.vsServletTMs) {
            if (!vsServletTM.getModuleName().equals(appName) || !vsServletTM.getVSName().equals(vsName)) continue;
            vsServletTM.enableMonitoring(false);
            servletTMsToRemove.add(vsServletTM);
        }
        for (ServletStatsTelemetry servletTMToRemove : servletTMsToRemove) {
            this.vsServletTMs.remove(servletTMToRemove);
        }
    }

    private void buildSessionTelemetry() {
        if (this.webSessionsTM == null) {
            this.webSessionsTM = new SessionStatsTelemetry(this.webSessionNode, null, null, this.webMonitoringEnabled, this.logger);
            Collection handles = this.pcm.registerListener((Object)this.webSessionsTM);
            this.webSessionsTM.setProbeListenerHandles(handles);
        } else if (!this.webSessionsTM.isEnabled()) {
            this.webSessionsTM.enableMonitoring(true);
        }
        if (this.vsSessionTMs == null) {
            this.vsSessionTMs = new ArrayList<SessionStatsTelemetry>();
            TreeNode appsNode = this.serverNode.getNode("applications");
            Collection appNodes = appsNode.getChildNodes();
            for (TreeNode appNode : appNodes) {
                Collection vsNodes = appNode.getChildNodes();
                for (TreeNode vsNode : vsNodes) {
                    this.buildSessionTelemetryForVS(vsNode, appNode.getName());
                }
            }
        } else {
            for (SessionStatsTelemetry sessionTM : this.vsSessionTMs) {
                if (sessionTM.isEnabled()) continue;
                sessionTM.enableMonitoring(true);
            }
        }
    }

    private void buildSessionTelemetryForVS(TreeNode vsNode, String appName) {
        if (!this.sessionProviderRegistered) {
            return;
        }
        SessionStatsTelemetry vsSessionTM = new SessionStatsTelemetry(vsNode, appName, vsNode.getName(), this.webMonitoringEnabled, this.logger);
        Collection handles = this.pcm.registerListener((Object)vsSessionTM);
        vsSessionTM.setProbeListenerHandles(handles);
        this.vsSessionTMs.add(vsSessionTM);
    }

    private void removeSessionTelemetryForVS(String appName, String vsName) {
        if (!this.sessionProviderRegistered || !this.isWebTreeBuilt || this.vsSessionTMs == null) {
            return;
        }
        ArrayList<SessionStatsTelemetry> sessionTMsToRemove = new ArrayList<SessionStatsTelemetry>();
        for (SessionStatsTelemetry vsSessionTM : this.vsSessionTMs) {
            if (!vsSessionTM.getModuleName().equals(appName) || !vsSessionTM.getVSName().equals(vsName)) continue;
            vsSessionTM.enableMonitoring(false);
            sessionTMsToRemove.add(vsSessionTM);
        }
        for (SessionStatsTelemetry sessionTMToRemove : sessionTMsToRemove) {
            this.vsSessionTMs.remove(sessionTMToRemove);
        }
    }

    private void buildWebRequestTelemetry() {
        if (this.webRequestTM == null) {
            this.webRequestTM = new WebRequestTelemetry(this.webRequestNode, null, null, this.logger);
            Collection handles = this.pcm.registerListener((Object)this.webRequestTM);
            this.webRequestTM.setProbeListenerHandles(handles);
        } else if (!this.webRequestTM.isEnabled()) {
            this.webRequestTM.enableMonitoring(true);
        }
        if (this.vsRequestTMs == null) {
            this.vsRequestTMs = new ArrayList<WebRequestTelemetry>();
            TreeNode appsNode = this.serverNode.getNode("applications");
            Collection appNodes = appsNode.getChildNodes();
            for (TreeNode appNode : appNodes) {
                Collection vsNodes = appNode.getChildNodes();
                for (TreeNode vsNode : vsNodes) {
                    this.buildWebRequestTelemetryForVS(vsNode, appNode.getName());
                }
            }
        } else {
            for (WebRequestTelemetry requestTM : this.vsRequestTMs) {
                if (requestTM.isEnabled()) continue;
                requestTM.enableMonitoring(true);
            }
        }
    }

    private void buildWebRequestTelemetryForVS(TreeNode vsNode, String appName) {
        if (!this.requestProviderRegistered) {
            return;
        }
        WebRequestTelemetry vsRequestTM = new WebRequestTelemetry(vsNode, appName, vsNode.getName(), this.logger);
        Collection handles = this.pcm.registerListener((Object)vsRequestTM);
        vsRequestTM.setProbeListenerHandles(handles);
        this.vsRequestTMs.add(vsRequestTM);
    }

    private void removeRequestTelemetryForVS(String appName, String vsName) {
        if (!this.requestProviderRegistered || !this.isWebTreeBuilt || this.vsRequestTMs == null) {
            return;
        }
        ArrayList<WebRequestTelemetry> requestTMsToRemove = new ArrayList<WebRequestTelemetry>();
        for (WebRequestTelemetry vsRequestTM : this.vsRequestTMs) {
            if (!vsRequestTM.getModuleName().equals(appName) || !vsRequestTM.getVSName().equals(vsName)) continue;
            vsRequestTM.enableMonitoring(false);
            requestTMsToRemove.add(vsRequestTM);
        }
        for (WebRequestTelemetry requestTMToRemove : requestTMsToRemove) {
            this.vsRequestTMs.remove(requestTMToRemove);
        }
    }

    private void enableWebMonitoring(boolean isEnabled) {
        this.webNode.setEnabled(isEnabled);
        this.applicationsNode.setEnabled(isEnabled);
        if (this.webSessionsTM != null) {
            this.webSessionsTM.enableMonitoring(isEnabled);
        }
        if (this.vsSessionTMs != null) {
            for (SessionStatsTelemetry sessionTM : this.vsSessionTMs) {
                sessionTM.enableMonitoring(isEnabled);
            }
        }
        if (this.webServletsTM != null) {
            this.webServletsTM.enableMonitoring(isEnabled);
        }
        if (this.vsServletTMs != null) {
            for (ServletStatsTelemetry servletTM : this.vsServletTMs) {
                servletTM.enableMonitoring(isEnabled);
            }
        }
        if (this.webJspTM != null) {
            this.webJspTM.enableMonitoring(isEnabled);
        }
        if (this.vsJspTMs != null) {
            for (JspStatsTelemetry jspTM : this.vsJspTMs) {
                jspTM.enableMonitoring(isEnabled);
            }
        }
        if (this.webRequestTM != null) {
            this.webRequestTM.enableMonitoring(isEnabled);
        }
        if (this.vsRequestTMs != null) {
            for (WebRequestTelemetry requestTM : this.vsRequestTMs) {
                requestTM.enableMonitoring(isEnabled);
            }
        }
    }

    public static String getAppName(String contextRoot) {
        if (contextRoot == null) {
            return null;
        }
        List lm = domain.getApplications().getModules(WebModule.class);
        for (WebModule wm : lm) {
            if (!contextRoot.equals(wm.getContextRoot())) continue;
            return wm.getName();
        }
        List la = domain.getApplications().getModules(Application.class);
        for (Application sapp : la) {
            if (!contextRoot.equals(sapp.getContextRoot())) continue;
            return sapp.getName();
        }
        return null;
    }

    public static String getVirtualServerName(String hostName, String listenerPort) {
        try {
            if (hostName == null) {
                return null;
            }
            if (hostName.equals("localhost")) {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            HttpListener httpListener = null;
            for (HttpListener hl : httpService.getHttpListener()) {
                if (!hl.getPort().equals(listenerPort)) continue;
                httpListener = hl;
                break;
            }
            VirtualServer virtualServer = null;
            for (VirtualServer vs : httpService.getVirtualServer()) {
                if (!vs.getHosts().contains(hostName) || !vs.getHttpListeners().contains(httpListener.getId())) continue;
                virtualServer = vs;
                break;
            }
            return virtualServer.getId();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(WebTelemetryBootstrap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    static {
        httpService = null;
    }
}

