/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class DependAction
extends Action {
    static final Map<String, Type> knownTypes = new HashMap<String, Type>();
    Image img;
    Type type;
    String fmriStr;
    Fmri minFmri;
    Fmri maxFmri;
    boolean required;

    DependAction(Image image, String[] tokens) {
        super(1);
        Fmri f;
        knownTypes.put("require", Type.REQUIRED);
        knownTypes.put("optional", Type.OPTIONAL);
        knownTypes.put("transfer", Type.TRANSFER);
        knownTypes.put("incorporate", Type.INCORPORATE);
        this.minFmri = Fmri.nullFmri;
        this.maxFmri = Fmri.nullFmri;
        this.img = image;
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i].startsWith("fmri=")) {
                this.fmriStr = tokens[i].substring(5);
                continue;
            }
            if (!tokens[i].startsWith("type=")) continue;
            String typeStr = tokens[i].substring(5);
            if (knownTypes.containsKey(typeStr)) {
                this.type = knownTypes.get(typeStr);
                continue;
            }
            throw new IllegalArgumentException("unknown depend type: " + typeStr);
        }
        this.minFmri = f = new Fmri(this.fmriStr);
        this.required = true;
        if (this.type == Type.OPTIONAL || this.type == Type.TRANSFER) {
            this.required = false;
        } else if (this.type == Type.INCORPORATE) {
            this.required = false;
            this.maxFmri = f;
        }
    }

    void install(Action orig) throws IOException {
    }

    Type getType() {
        return this.type;
    }

    Fmri getMinFmri() {
        return this.minFmri;
    }

    String keyValue() {
        return this.fmriStr;
    }

    public String toString() {
        return "depend: fmri=" + this.fmriStr + ", type=" + (Object)((Object)this.type);
    }

    boolean isDifferent(Action a) {
        if (!(a instanceof DependAction)) {
            return true;
        }
        DependAction da = (DependAction)a;
        return !this.equals(a) || !this.minFmri.equals(da.minFmri) || !this.maxFmri.equals(da.maxFmri) || this.required != da.required;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        REQUIRED,
        OPTIONAL,
        TRANSFER,
        INCORPORATE;

    }
}

