/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.branding;

import java.util.PropertyResourceBundle;
import org.glassfish.api.branding.Branding;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class GlassFishBranding
implements Branding,
PostConstruct {
    private String product_name = "GlassFish";
    private String abbrev_product_name = "glassfish";
    private String full_version = "3.0-Prelude-Embedded-b12";
    private String major_version = "3";
    private String minor_version = "0";
    private String build_id = "java_re-private";
    private String version_prefix = "v";
    private String version_suffix = "Prelude";
    private boolean fullVersionSet = false;
    private PropertyResourceBundle bundle;

    public void postConstruct() {
        this.setup();
        if (this.bundle == null) {
            return;
        }
        this.product_name = this.get("product_name", this.product_name);
        this.abbrev_product_name = this.get("abbrev_product_name", this.abbrev_product_name);
        this.full_version = this.get("full_version", this.full_version);
        this.major_version = this.get("major_version", this.major_version);
        this.minor_version = this.get("minor_version", this.minor_version);
        this.build_id = this.get("build_id", this.build_id);
        this.version_prefix = this.get("version_prefix", this.version_prefix);
        this.version_suffix = this.get("version_suffix", this.version_suffix);
        if (!this.fullVersionSet && this.minor_version != null && this.minor_version.length() > 0) {
            try {
                this.full_version = Integer.parseInt(this.minor_version) > 0 ? this.major_version + "." + this.minor_version : this.major_version;
            }
            catch (NumberFormatException nfe) {
                this.full_version = this.major_version;
            }
        }
    }

    public String getVersion() {
        StringBuffer sb = new StringBuffer("");
        if (this.product_name == null) {
            return null;
        }
        sb.append(this.product_name);
        if (this.version_prefix != null) {
            sb.append(" " + this.version_prefix);
        }
        if (this.full_version != null) {
            sb.append(this.full_version);
        }
        if (this.version_suffix != null) {
            sb.append(" " + this.version_suffix);
        }
        return sb.toString();
    }

    public String getFullVersion() {
        return this.getVersion() + " (build " + this.build_id + ")";
    }

    public String getAbbreviatedVersion() {
        return this.abbrev_product_name;
    }

    public String getMajorVersion() {
        return this.major_version;
    }

    public String getMinorVersion() {
        return this.minor_version;
    }

    public String getBuildVersion() {
        return this.build_id;
    }

    public String getVersionPrefix() {
        return this.version_prefix;
    }

    public String getVersionSuffix() {
        return this.version_suffix;
    }

    public String getProductName() {
        return this.product_name;
    }

    public String getAbbrevProductName() {
        return this.abbrev_product_name;
    }

    private String get(String key, String defaultValue) {
        try {
            return this.bundle.getString(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private void setup() {
        try {
            this.bundle = (PropertyResourceBundle)PropertyResourceBundle.getBundle("BrandingVersion");
        }
        catch (Exception e) {
            this.bundle = null;
            System.out.println("no resource bundle found for version, using default GlassFish version");
        }
    }
}

