/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.jruby.Messages;
import com.sun.grizzly.jruby.RubyRuntimeAsyncFilter;
import com.sun.grizzly.jruby.config.JRubyConfig;
import com.sun.grizzly.jruby.rack.RackAdapter;
import com.sun.grizzly.jruby.rack.RackApplication;
import com.sun.grizzly.jruby.rack.RackApplicationChooser;
import com.sun.grizzly.jruby.rack.RackApplicationFactory;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.jruby.runtime.Constants;

public class RackGrizzlyAdapter
extends GrizzlyAdapter {
    private final RackAdapter handler;
    private RubyRuntimeAsyncFilter asyncFilter;
    private final int numThreads;
    private final boolean asyncExecution;
    private final RackApplicationFactory factory;
    public final JRubyConfig config;

    public RackGrizzlyAdapter(JRubyConfig config, boolean asyncExecution) {
        super(config.appRoot());
        this.config = config;
        this.setHandleStaticResources(false);
        this.setRootFolder(config.appRoot() + File.separator + "public");
        this.asyncExecution = asyncExecution;
        JRubyVersion jrubyVersion = new JRubyVersion();
        this.logger.log(Level.INFO, Messages.format("jruby.version", jrubyVersion));
        this.numThreads = jrubyVersion.compare("1.1.5") < 0 ? 1 : Math.min(Runtime.getRuntime().availableProcessors(), config.runtimeConfig().getInitRuntime());
        this.handler = RackApplicationChooser.getFactory(config.appRoot(), this);
        this.factory = this.handler.getFactory();
    }

    public boolean async() {
        return this.asyncExecution;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    void stopRubyRuntimePool() {
        this.handler.shutdown();
    }

    public java.util.logging.Logger getLogger() {
        return this.logger;
    }

    private String getEffectiveLogLevel() {
        Level myLevel = null;
        java.util.logging.Logger pLog = this.logger;
        myLevel = pLog.getLevel();
        while (myLevel == null) {
            pLog = pLog.getParent();
            myLevel = pLog.getLevel();
        }
        return myLevel.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        RackApplication serviceApp = null;
        try {
            serviceApp = this.handler.getApp();
            if (serviceApp == null) {
                throw new IllegalStateException(Messages.format("jruby.runtime.notavailable", new Object[0]));
            }
            this.dispatchRailsRequest(serviceApp, req, res);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (serviceApp != null) {
                this.handler.returnApp(serviceApp);
                if (this.asyncFilter != null) {
                    this.asyncFilter.resume();
                }
            }
        }
    }

    private void dispatchRailsRequest(RackApplication app, GrizzlyRequest req, GrizzlyResponse res) throws IOException {
        try {
            app.call(req).respond(res);
        }
        catch (Exception e) {
            res.setError();
            if (res.isCommitted()) {
                this.logger.log(Level.WARNING, "Error: Couldn't handle error: response committed", e);
                return;
            }
            res.reset();
            try {
                RackApplication errorApp = this.factory.getErrorApplication(app.getRuntime());
                req.setAttribute("rack.exception", (Object)e);
                this.logger.log(Level.WARNING, e.getMessage(), e);
                errorApp.call(req).respond(res);
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Error: Couldn't handle error", ex);
                res.sendError(500);
            }
        }
    }

    private static class Logger {
        private final java.util.logging.Logger logger;

        public Logger(java.util.logging.Logger logger) {
            this.logger = logger;
        }

        public void log(String msg) {
            this.logger.fine(msg);
        }

        public void info(String msg) {
            this.logger.info(msg);
        }

        public void warning(String msg) {
            this.logger.warning(msg);
        }

        public void severe(String msg) {
            this.logger.severe(msg);
        }

        public void fine(String msg) {
            this.logger.fine(msg);
        }
    }

    private static class JRubyVersion {
        private int major;
        private int minor;
        private int suffix;
        private String qualifier = "";

        public JRubyVersion() {
            this(Constants.VERSION);
        }

        private JRubyVersion(String version) {
            int i = version.lastIndexOf(46);
            if (i != -1) {
                block7: {
                    String v = version.substring(i + 1, version.length());
                    try {
                        this.suffix = Integer.parseInt(v);
                    }
                    catch (NumberFormatException e) {
                        int index = 0;
                        for (char c : v.toCharArray()) {
                            if (!Character.isDigit(c)) break;
                            ++index;
                        }
                        this.suffix = Integer.parseInt(v.substring(0, index));
                        if (index <= 0) break block7;
                        this.qualifier = v.substring(index, v.length());
                    }
                }
                int j = version.substring(0, i).lastIndexOf(46);
                if (j != -1) {
                    this.minor = Integer.parseInt(version.substring(j + 1, i));
                    this.major = j != 0 ? Integer.parseInt(version.substring(0, j)) : 0;
                } else {
                    this.minor = 0;
                    this.major = 1;
                }
            } else {
                this.suffix = 0;
                this.minor = 0;
                this.major = 0;
            }
        }

        public int compare(JRubyVersion version) {
            int result = this.major - version.major;
            if (result == 0 && (result = this.minor - version.minor) == 0) {
                result = this.suffix - version.suffix;
            }
            return result;
        }

        public int compare(String version) {
            return this.compare(new JRubyVersion(version));
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.suffix + this.qualifier;
        }
    }
}

