/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby;

import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.scripting.jruby.Messages;

public class JRubyApplication
implements ApplicationContainer {
    private final Logger logger;
    private Object jRubyRuntime;
    private Adapter adapter;
    private final RequestDispatcher dispatcher;
    private ClassLoader acl;
    private final String contextRoot;
    private final ServerEnvironment serverEnvironment;
    private final String railsRoot;
    private String jrubyHome;
    private final DeploymentContext deploymentContext;
    private static final String JRUBY_HOME = "jruby.home";
    private static final String CONTEXT_ROOT_ARG = "--contextroot";

    public JRubyApplication(DeploymentContext context, ServerEnvironment env, RequestDispatcher dispatcher) throws IOException {
        this.logger = context.getLogger();
        this.railsRoot = context.getSourceDir().getCanonicalPath();
        this.dispatcher = dispatcher;
        this.serverEnvironment = env;
        this.deploymentContext = context;
        this.contextRoot = this.getContextRoot(context, env.getStartupContext().getArguments());
        String home = System.getProperty(JRUBY_HOME);
        if (home == null) {
            home = context.getProps().getProperty(JRUBY_HOME);
        }
        if (home != null) {
            this.jrubyHome = home;
        }
        if (this.jrubyHome == null) {
            this.logger.severe(Messages.format("railsapplication.jrubyhome.null", new Object[0]));
            throw new IllegalArgumentException(Messages.format("railsapplication.jrubyhome.null", new Object[0]));
        }
        context.getProps().setProperty(JRUBY_HOME, this.jrubyHome);
        context.getLogger().info(Messages.format("railsdeployer.loading.info", ((DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class)).name, this.contextRoot));
    }

    private String getContextRoot(DeploymentContext context, Properties props) {
        String contextRoot = props.getProperty(CONTEXT_ROOT_ARG);
        DeployCommandParameters params = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        if (params.contextRoot != null) {
            contextRoot = params.contextRoot;
        }
        if (contextRoot == null || contextRoot.length() == 0) {
            contextRoot = "/" + params.name;
        }
        return contextRoot;
    }

    private boolean startJRubyGrizzlyAdapter() {
        try {
            URL[] urls = this.findJRubyJars();
            URLClassLoader cl = new URLClassLoader(urls, JRubyApplication.class.getClassLoader());
            Class<?> c = cl.loadClass("com.sun.grizzly.jruby.RubyRuntime");
            this.jRubyRuntime = c.getConstructor(Properties.class, String.class, String.class).newInstance(this.deploymentContext.getProps(), this.railsRoot, this.contextRoot);
            this.adapter = (Adapter)c.getMethod("getAdapter", new Class[0]).invoke(this.jRubyRuntime, new Object[0]);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, Messages.format("railsapplication.adaptor.creation.error", e.getMessage()), e);
            return false;
        }
        return true;
    }

    public boolean stop(ApplicationContext startupContext) {
        try {
            this.jRubyRuntime.getClass().getMethod("stopRubyRuntimePool", new Class[0]).invoke(this.jRubyRuntime, new Object[0]);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, Messages.format("railsapplication.error.stopping", this.contextRoot, e.getMessage()), e);
            return false;
        }
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.acl;
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean start(ApplicationContext startupContext) throws Exception {
        this.acl = startupContext.getClassLoader();
        if (!this.startJRubyGrizzlyAdapter()) {
            return false;
        }
        try {
            String ctx = this.contextRoot;
            if (this.contextRoot.equals("/")) {
                ctx = "";
            }
            this.dispatcher.registerEndpoint(ctx, this.adapter, (ApplicationContainer)this);
        }
        catch (EndpointRegistrationException e) {
            this.logger.log(Level.SEVERE, Messages.format("railsdeployer.adapter.registry.err", startupContext.getProps().getProperty("name")), e);
            return false;
        }
        return true;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void service(Request request, Response response) throws Exception {
        this.adapter.service(request, response);
    }

    public void afterService(Request request, Response response) throws Exception {
        this.adapter.afterService(request, response);
    }

    private URL[] findJRubyJars() throws MalformedURLException, ClassNotFoundException {
        ArrayList<URL> urls = new ArrayList<URL>();
        File jrubyLibDir = new File(this.jrubyHome, "lib");
        for (File lib : jrubyLibDir.listFiles()) {
            if (!lib.isFile() || !lib.toString().endsWith(".jar")) continue;
            urls.add(lib.toURI().toURL());
        }
        File grizzlyjruby = this.serverEnvironment.getStartupContext().getRootDirectory();
        File[] grizzlyjrubyJars = grizzlyjruby.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.startsWith("grizzly-jruby-module") && name.startsWith("grizzly-jruby");
            }
        });
        if (grizzlyjrubyJars.length > 0) {
            urls.add(grizzlyjrubyJars[0].toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

