/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.enterprise.connectors.work.WorkCoordinator;
import com.sun.enterprise.connectors.work.WorkStats;
import com.sun.enterprise.connectors.work.monitor.MonitorableWorkManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;

public final class CommonWorkManager
implements MonitorableWorkManager {
    private static WorkManager wm = null;
    private ThreadPoolManager tpm;
    private ThreadPool tp;
    private static final Logger logger = LogDomains.getLogger(CommonWorkManager.class, (String)"javax.enterprise.resource.resourceadapter");
    private boolean isMonitoringEnabled = false;
    private WorkStats workStats = null;
    private StringManager localStrings = StringManager.getManager(CommonWorkManager.class);
    private ConnectorRuntime runtime;

    public CommonWorkManager(String threadPoolId, ConnectorRuntime runtime) throws ConnectorRuntimeException {
        try {
            this.runtime = runtime;
            this.tp = runtime.getThreadPool(threadPoolId);
        }
        catch (NoSuchThreadPoolException e) {
            String msg = this.localStrings.getString("workmanager.threadpool_not_found");
            logger.log(Level.SEVERE, msg, threadPoolId);
            throw new ConnectorRuntimeException(e.getMessage());
        }
        if (this.tp == null) {
            String msg = this.localStrings.getString("workmanager.threadpool_not_found");
            logger.log(Level.SEVERE, msg, threadPoolId);
            throw new ConnectorRuntimeException(msg);
        }
    }

    public void doWork(Work work) throws WorkException {
        this.doWork(work, -1L, null, null);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "doWork for [" + work.toString() + "] START";
            logger.log(Level.FINEST, this.debugMsg(msg));
        }
        WorkCoordinator wc = new WorkCoordinator(work, startTimeout, execContext, this.tp.getAnyWorkQueue(), workListener, this.workStats, this.runtime);
        wc.submitWork(2);
        wc.lock();
        WorkException we = wc.getException();
        if (we != null) {
            throw we;
        }
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "doWork for [" + work.toString() + "] END";
            msg = "doWork for [" + work.toString() + "] END";
            logger.log(Level.FINEST, this.debugMsg(msg));
        }
    }

    public long startWork(Work work) throws WorkException {
        return this.startWork(work, -1L, null, null);
    }

    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "startWork for [" + work.toString() + "] START";
            logger.log(Level.FINEST, this.debugMsg(msg));
        }
        long acceptanceTime = System.currentTimeMillis();
        WorkCoordinator wc = new WorkCoordinator(work, startTimeout, execContext, this.tp.getAnyWorkQueue(), workListener, this.workStats, this.runtime);
        wc.submitWork(1);
        wc.lock();
        WorkException we = wc.getException();
        if (we != null) {
            throw we;
        }
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "startWork for [" + work.toString() + "] END";
            logger.log(Level.FINEST, this.debugMsg(msg));
        }
        long startTime = System.currentTimeMillis();
        return startTime - acceptanceTime;
    }

    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, -1L, null, null);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "scheduleWork for [" + work.toString() + "] START";
            logger.log(Level.FINEST, this.debugMsg(msg));
        }
        WorkCoordinator wc = new WorkCoordinator(work, startTimeout, execContext, this.tp.getAnyWorkQueue(), workListener, this.workStats, this.runtime);
        wc.submitWork(3);
        wc.lock();
        WorkException we = wc.getException();
        if (we != null) {
            throw we;
        }
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "scheduleWork for [" + work.toString() + "] END";
            logger.log(Level.FINEST, this.debugMsg(msg));
        }
    }

    private String debugMsg(String message) {
        String msg = "[Thread " + Thread.currentThread().getName() + "] -- " + message;
        return msg;
    }

    public boolean isMonitoringEnabled() {
        return this.isMonitoringEnabled;
    }

    public void setMonitoringEnabled(boolean isEnabled) {
        this.isMonitoringEnabled = isEnabled;
        if (this.workStats == null) {
            this.workStats = new WorkStats();
        }
        if (!isEnabled) {
            this.workStats.reset();
        }
    }

    public long getWaitQueueLength() {
        return this.workStats.currWaitQueueLength;
    }

    public long getMaxWaitQueueLength() {
        return this.workStats.maxWaitQueueLength;
    }

    public long getMinWaitQueueLength() {
        if (this.workStats.minWaitQueueLength != Long.MAX_VALUE) {
            return this.workStats.minWaitQueueLength;
        }
        return 0L;
    }

    public long getMaxWorkRequestWaitTime() {
        return this.workStats.maxWorkRequestWaitTime;
    }

    public long getMinWorkRequestWaitTime() {
        return this.workStats.minWorkRequestWaitTime;
    }

    public long getSubmittedWorkCount() {
        return this.workStats.submittedWorkCount;
    }

    public long getRejectedWorkCount() {
        return this.workStats.rejectedWorkCount;
    }

    public long getCompletedWorkCount() {
        return this.workStats.completedWorkCount;
    }

    public long getCurrentActiveWorkCount() {
        return this.workStats.currentActiveWorkCount;
    }

    public long getMaxActiveWorkCount() {
        return this.workStats.maxActiveWorkCount;
    }

    public long getMinActiveWorkCount() {
        if (this.workStats.minActiveWorkCount != Long.MAX_VALUE) {
            return this.workStats.minActiveWorkCount;
        }
        return 0L;
    }
}

