/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.ActionReport;

public abstract class ActionReporter
extends ActionReport {
    protected Throwable exception = null;
    protected String actionDescription = null;
    protected List<ActionReporter> subActions = new ArrayList<ActionReporter>();
    protected ActionReport.ExitCode exitCode = ActionReport.ExitCode.SUCCESS;
    protected ActionReport.MessagePart topMessage = new ActionReport.MessagePart();
    protected String contentType = "text/html";

    public void setFailure() {
        this.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    public boolean isFailure() {
        return this.getActionExitCode() == ActionReport.ExitCode.FAILURE;
    }

    public void setWarning() {
        this.setActionExitCode(ActionReport.ExitCode.WARNING);
    }

    public boolean isWarning() {
        return this.getActionExitCode() == ActionReport.ExitCode.WARNING;
    }

    public boolean isSuccess() {
        return this.getActionExitCode() == ActionReport.ExitCode.SUCCESS;
    }

    public void setSuccess() {
        this.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    public void setActionDescription(String message) {
        this.actionDescription = message;
    }

    public void setFailureCause(Throwable t) {
        this.exception = t;
    }

    public Throwable getFailureCause() {
        return this.exception;
    }

    public ActionReport.MessagePart getTopMessagePart() {
        return this.topMessage;
    }

    public ActionReport addSubActionsReport() {
        ActionReporter subAction;
        try {
            subAction = (ActionReporter)((Object)((Object)((Object)this)).getClass().newInstance());
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        catch (InstantiationException ex) {
            return null;
        }
        this.subActions.add(subAction);
        return subAction;
    }

    public void setActionExitCode(ActionReport.ExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public ActionReport.ExitCode getActionExitCode() {
        return this.exitCode;
    }

    public void setMessage(String message) {
        this.topMessage.setMessage(message);
    }

    public String getMessage() {
        return this.topMessage.getMessage();
    }

    public void setMessage(InputStream in) {
        try {
            if (in == null) {
                throw new NullPointerException("Internal Error - null InputStream");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.copyStream(in, baos);
            this.setMessage(baos.toString());
        }
        catch (Exception ex) {
            this.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.setFailureCause(ex);
        }
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
        out.close();
        in.close();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String s) {
        this.contentType = s;
    }
}

