/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.Controller;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateHolder<E> {
    private AtomicReference<E> stateRef = new AtomicReference();
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private volatile boolean isLockEnabled;
    private Map<ConditionListener<E>, Object> conditionListeners = new ConcurrentHashMap<ConditionListener<E>, Object>();

    public StateHolder() {
        this(false);
    }

    public StateHolder(boolean isLockEnabled) {
        this.isLockEnabled = isLockEnabled;
    }

    public E getState() {
        return this.getState(this.isLockEnabled);
    }

    public E getState(boolean locked) {
        if (locked) {
            this.readWriteLock.readLock().lock();
        }
        E retState = this.stateRef.get();
        if (locked) {
            this.readWriteLock.readLock().unlock();
        }
        return retState;
    }

    public void setState(E state) {
        this.setState(state, this.isLockEnabled);
    }

    public void setState(E state, boolean locked) {
        if (locked) {
            this.readWriteLock.writeLock().lock();
        }
        this.stateRef.set(state);
        if (locked) {
            this.readWriteLock.readLock().lock();
            this.readWriteLock.writeLock().unlock();
        }
        this.checkConditionListeners(state);
        if (locked) {
            this.readWriteLock.readLock().unlock();
        }
    }

    public ReentrantReadWriteLock getStateLocker() {
        return this.readWriteLock;
    }

    public boolean isLockEnabled() {
        return this.isLockEnabled;
    }

    public void setLockEnabled(boolean isLockEnabled) {
        this.isLockEnabled = isLockEnabled;
    }

    public ConditionListener<E> notifyWhenStateIsEqual(E state, Object listener) {
        boolean isLockEnabledLocal = this.isLockEnabled;
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().lock();
        }
        EqualConditionListener<E> conditionListener = null;
        if (this.stateRef.get().equals(state)) {
            EventListener.notifyListener(listener);
        } else {
            conditionListener = new EqualConditionListener<E>();
            EventListener eventListener = new EventListener();
            eventListener.set(listener);
            conditionListener.set(state, eventListener);
            this.conditionListeners.put(conditionListener, this);
        }
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().unlock();
        }
        return conditionListener;
    }

    public ConditionListener<E> notifyWhenStateIsNotEqual(E state, Object listener) {
        boolean isLockEnabledLocal = this.isLockEnabled;
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().lock();
        }
        NotEqualConditionListener<E> conditionListener = null;
        if (!this.stateRef.get().equals(state)) {
            EventListener.notifyListener(listener);
        } else {
            conditionListener = new NotEqualConditionListener<E>();
            EventListener eventListener = new EventListener();
            eventListener.set(listener);
            conditionListener.set(state, eventListener);
            this.conditionListeners.put(conditionListener, this);
        }
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().unlock();
        }
        return conditionListener;
    }

    public void notifyWhenConditionMatchState(ConditionListener<E> conditionListener) {
        E currentState;
        boolean isLockEnabledLocal = this.isLockEnabled;
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().lock();
        }
        if (conditionListener.check(currentState = this.getState())) {
            conditionListener.notifyListener();
        } else {
            this.conditionListeners.put(conditionListener, this);
        }
        if (isLockEnabledLocal) {
            this.getStateLocker().writeLock().unlock();
        }
    }

    public void removeConditionListener(ConditionListener<E> conditionListener) {
        if (conditionListener == null) {
            return;
        }
        this.conditionListeners.remove(conditionListener);
    }

    protected void checkConditionListeners(E state) {
        Iterator<ConditionListener<E>> it = this.conditionListeners.keySet().iterator();
        while (it.hasNext()) {
            ConditionListener<E> listener = it.next();
            try {
                if (!listener.check(state)) continue;
                it.remove();
                listener.notifyListener();
            }
            catch (Exception e) {
                Controller.logger().log(Level.WARNING, "Error calling ConditionListener", e);
            }
        }
    }

    public static class EventListener {
        public Object notificationObject;

        public void set(Object notificationObject) {
            this.notificationObject = notificationObject;
        }

        public void notifyEvent() {
            EventListener.notifyListener(this.notificationObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static void notifyListener(Object listener) {
            if (listener instanceof CountDownLatch) {
                ((CountDownLatch)listener).countDown();
            } else {
                if (listener instanceof Callable) {
                    try {
                        ((Callable)listener).call();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (listener instanceof Runnable) {
                    ((Runnable)listener).run();
                } else {
                    Object object = listener;
                    synchronized (object) {
                        listener.notify();
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotEqualConditionListener<E>
    extends ConditionListener<E> {
        @Override
        public boolean check(E state) {
            return !state.equals(this.state);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EqualConditionListener<E>
    extends ConditionListener<E> {
        @Override
        public boolean check(E state) {
            return state.equals(this.state);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ConditionListener<E> {
        public E state;
        public EventListener listener;

        protected void set(E state, EventListener listener) {
            this.state = state;
            this.listener = listener;
        }

        public void notifyListener() {
            this.listener.notifyEvent();
        }

        public abstract boolean check(E var1);
    }
}

