/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.SelectionKeyActionAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadAttachment
extends SelectionKeyActionAttachment
implements AttributeHolder {
    private ReentrantLock threadLock = new ReentrantLock();
    private String threadId;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private ByteBuffer byteBuffer;
    private ByteBuffer inputBB;
    private ByteBuffer outputBB;
    private SSLEngine sslEngine;
    private int mode;

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public ByteBuffer getInputBB() {
        return this.inputBB;
    }

    public void setInputBB(ByteBuffer inputBB) {
        this.inputBB = inputBB;
    }

    public ByteBuffer getOutputBB() {
        return this.outputBB;
    }

    public void setOutputBB(ByteBuffer outputBB) {
        this.outputBB = outputBB;
    }

    public SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    public void setSSLEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    public void associate() {
        if (!this.threadLock.isHeldByCurrentThread()) {
            this.threadLock.lock();
        }
    }

    public void deassociate() {
        if (this.threadLock.isHeldByCurrentThread()) {
            this.threadLock.unlock();
        }
    }

    @Override
    public void process(SelectionKey selectionKey) {
        ((WorkerThread)Thread.currentThread()).attach(this);
    }

    @Override
    public void postProcess(SelectionKey selectionKey) {
        ((WorkerThread)Thread.currentThread()).detach();
    }

    public void reset() {
        this.mode = Mode.ATTRIBUTES_ONLY;
        this.byteBuffer = null;
        this.sslEngine = null;
        this.inputBB = null;
        this.outputBB = null;
    }

    @Override
    public void release(SelectionKey selectionKey) {
        this.attributes.clear();
        this.reset();
        this.deassociate();
        super.release(selectionKey);
    }

    public static class Mode {
        public static int ATTRIBUTES_ONLY = 0;
        public static int BYTE_BUFFER = 2;
        public static int INPUT_BB = 4;
        public static int OUTPUT_BB = 8;
        public static int SECURE_BUFFERS = 12;
        public static int SSL_ENGINE = 16;
        public static int SSL_ARTIFACTS = 28;
        public static int STORE_ALL = 31;
    }
}

