/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="disable")
@I18n(value="disable.command")
@Scoped(value=PerLookup.class)
public class DisableCommand
extends ApplicationLifecycle
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableCommand.class);
    @Inject
    ServerEnvironmentImpl env;
    @Param(primary=true)
    String component = null;
    @Param(optional=true)
    String target = "server";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.isRegistered(this.component)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.component}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!Boolean.valueOf(ConfigBeansUtilities.getEnabled((String)this.target, (String)this.component)).booleanValue()) {
            this.logger.fine("The application is already disabled");
            return;
        }
        try {
            DeploymentContextImpl deploymentContext = new DeploymentContextImpl(this.logger, null, context.getCommandParameters(), this.env);
            this.disable(this.component, (DeploymentContext)deploymentContext, report);
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                this.setEnableAttributeInDomainXML(this.component, false);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error during disabling: ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
    }
}

