/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.html_basic.BaseTableRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class GridRenderer
extends BaseTableRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.PANELGRID);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        this.renderTableStart(context, component, writer, ATTRIBUTES);
        this.renderCaption(context, component, writer);
        this.renderHeader(context, component, writer);
        this.renderFooter(context, component, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncodeChildren(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(component);
        int columnCount = info.columns.size();
        boolean open = false;
        int i = 0;
        this.renderTableBodyStart(component, writer);
        Iterator<UIComponent> kids = this.getChildren(component);
        while (kids.hasNext()) {
            UIComponent child = kids.next();
            if (!child.isRendered()) continue;
            if (i % columnCount == 0) {
                if (open) {
                    this.renderRowEnd(component, writer);
                    open = false;
                }
                this.renderRowStart(component, writer);
                open = true;
                info.newRow();
            }
            this.renderRow(context, component, child, writer);
            ++i;
        }
        if (open) {
            this.renderRowEnd(component, writer);
        }
        this.renderTableBodyEnd(component, writer);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        this.renderTableEnd(component, context.getResponseWriter());
        this.clearMetaInfo(component);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderRow(FacesContext context, UIComponent table, UIComponent child, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(table);
        writer.startElement("td", table);
        String columnClass = info.getCurrentColumnClass();
        if (columnClass != null) {
            writer.writeAttribute("class", (Object)columnClass, "columns");
        }
        this.encodeRecursive(context, child);
        writer.endElement("td");
        writer.writeText((Object)"\n", table, null);
    }

    protected void renderHeader(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(table);
        UIComponent header = this.getFacet(table, "header");
        String headerClass = (String)table.getAttributes().get("headerClass");
        if (header != null) {
            writer.startElement("thead", table);
            writer.writeText((Object)"\n", table, null);
            writer.startElement("tr", header);
            writer.startElement("th", header);
            if (headerClass != null) {
                writer.writeAttribute("class", (Object)headerClass, "headerClass");
            }
            writer.writeAttribute("colspan", (Object)String.valueOf(info.columns.size()), null);
            writer.writeAttribute("scope", (Object)"colgroup", null);
            this.encodeRecursive(context, header);
            writer.endElement("th");
            writer.endElement("tr");
            writer.writeText((Object)"\n", table, null);
            writer.endElement("thead");
            writer.writeText((Object)"\n", table, null);
        }
    }

    protected void renderFooter(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(table);
        UIComponent footer = this.getFacet(table, "footer");
        String footerClass = (String)table.getAttributes().get("footerClass");
        if (footer != null) {
            writer.startElement("tfoot", table);
            writer.writeText((Object)"\n", table, null);
            writer.startElement("tr", footer);
            writer.startElement("td", footer);
            if (footerClass != null) {
                writer.writeAttribute("class", (Object)footerClass, "footerClass");
            }
            writer.writeAttribute("colspan", (Object)String.valueOf(info.columns.size()), null);
            this.encodeRecursive(context, footer);
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText((Object)"\n", table, null);
            writer.endElement("tfoot");
            writer.writeText((Object)"\n", table, null);
        }
    }
}

