/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.scripting;

import com.sun.faces.scripting.GroovyHelper;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import groovy.util.GroovyScriptEngine;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroovyHelperImpl
extends GroovyHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String SCRIPT_PATH = "/WEB-INF/groovy/";
    private MojarraGroovyClassLoader loader;

    GroovyHelperImpl() throws Exception {
        FacesContext ctx = FacesContext.getCurrentInstance();
        URL u = ctx.getExternalContext().getResource(SCRIPT_PATH);
        if (u != null) {
            final GroovyScriptEngine engine = new GroovyScriptEngine(new URL[]{u}, Thread.currentThread().getContextClassLoader());
            this.loader = AccessController.doPrivileged(new PrivilegedAction<MojarraGroovyClassLoader>(){

                @Override
                public MojarraGroovyClassLoader run() {
                    return new MojarraGroovyClassLoader(engine);
                }
            });
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Groovy support enabled.");
            }
        } else {
            throw new UnsupportedOperationException();
        }
        ctx.getExternalContext().getApplicationMap().put("com.sun.faces.groovyhelper", this);
    }

    @Override
    public Class<?> loadScript(String name) {
        try {
            String script = name;
            if (script.endsWith(".groovy")) {
                script = script.substring(0, script.indexOf(".groovy"));
            }
            return Util.loadClass(script, this);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    @Override
    public void setClassLoader() {
        Thread.currentThread().setContextClassLoader(this.loader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MojarraGroovyClassLoader
    extends URLClassLoader {
        private GroovyScriptEngine gse;

        public MojarraGroovyClassLoader(GroovyScriptEngine gse) {
            super(new URL[0], (ClassLoader)gse.getGroovyClassLoader());
            this.gse = gse;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class c;
            if (name == null) {
                throw new NullPointerException();
            }
            try {
                c = this.gse.getGroovyClassLoader().getParent().loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    c = this.gse.loadScriptByName(name);
                }
                catch (Exception e) {
                    throw new ClassNotFoundException(name, e);
                }
            }
            if (c == null) {
                throw new ClassNotFoundException(name);
            }
            return c;
        }
    }
}

