/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.resource;

import com.sun.jsftemplating.util.Util;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleManager {
    private static ResourceBundleManager _instance = null;
    private Map<String, ResourceBundle> _cache = new HashMap<String, ResourceBundle>();

    protected ResourceBundleManager() {
    }

    public static ResourceBundleManager getInstance() {
        if (_instance == null) {
            _instance = new ResourceBundleManager();
        }
        return _instance;
    }

    protected ResourceBundle getCachedBundle(String baseName, Locale locale) {
        return this._cache.get(this.getCacheKey(baseName, locale));
    }

    protected String getCacheKey(String baseName, Locale locale) {
        return baseName + "__" + locale.toString();
    }

    protected void addCachedBundle(String baseName, Locale locale, ResourceBundle bundle) {
        HashMap<String, ResourceBundle> map = new HashMap<String, ResourceBundle>(this._cache);
        map.put(this.getCacheKey(baseName, locale), bundle);
        this._cache = map;
    }

    public ResourceBundle getBundle(String baseName, Locale locale) {
        ResourceBundle bundle = this.getCachedBundle(baseName, locale);
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle(baseName, locale, Util.getClassLoader(baseName));
            }
            catch (MissingResourceException ex) {
                System.out.println("Can't find bundle: " + baseName);
                ex.printStackTrace();
            }
            if (bundle != null) {
                this.addCachedBundle(baseName, locale, bundle);
            }
        }
        return bundle;
    }

    public ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        ResourceBundle bundle = this.getCachedBundle(baseName, locale);
        if (bundle == null && (bundle = ResourceBundle.getBundle(baseName, locale, loader)) != null) {
            this.addCachedBundle(baseName, locale, bundle);
        }
        return bundle;
    }
}

