/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaskingClassLoader
extends ClassLoader {
    private final String[] masks;
    private final URLClassLoader delegate;

    public MaskingClassLoader(ClassLoader parent, URL[] urls, String ... masks) {
        super(parent);
        this.delegate = new URLClassLoader(urls, this.getMaskingClassLoader(masks));
        this.masks = masks;
    }

    public MaskingClassLoader(ClassLoader parent, URL[] urls, Collection<String> masks) {
        this(parent, urls, masks.toArray(new String[masks.size()]));
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            for (String mask : this.masks) {
                if (!name.startsWith(mask)) continue;
                Class<?> c = this.delegate.loadClass(name);
                return c;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return super.loadClass(name, resolve);
    }

    public ClassLoader getMaskingClassLoader(final String ... masks) {
        return new ClassLoader(){

            @Override
            protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                for (String mask : masks) {
                    if (!name.startsWith(mask)) continue;
                    throw new ClassNotFoundException(name);
                }
                return super.loadClass(name, resolve);
            }
        };
    }
}

