/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.client;

import com.sun.appserv.management.util.misc.LineReaderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import javax.net.ssl.X509TrustManager;

public class TrustStoreTrustManager
implements X509TrustManager {
    private final File mTrustStoreFile;
    private final char[] mTrustStorePassword;
    private final String mKeyStoreType;
    private KeyStore mTrustStore;
    private boolean mPrompt;
    public static final String TRUSTSTORE_FILE_SPROP = "javax.net.ssl.trustStore";
    public static final String TRUSTSTORE_PASSWORD_SPROP = "javax.net.ssl.trustStorePassword";

    public TrustStoreTrustManager(File trustStoreFile, String keyStoreType, char[] trustStorePassword) {
        if (trustStoreFile == null || keyStoreType == null) {
            throw new IllegalArgumentException();
        }
        this.mTrustStoreFile = trustStoreFile;
        this.mKeyStoreType = keyStoreType;
        this.mTrustStorePassword = trustStorePassword;
        this.mTrustStore = null;
        this.mPrompt = false;
        try {
            this.getTrustStore();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TrustStoreTrustManager(File trustStoreFile, char[] trustStorePassword) {
        this(trustStoreFile, "JKS", trustStorePassword);
    }

    public void setPrompt(boolean prompt) {
        this.mPrompt = prompt;
    }

    public static TrustStoreTrustManager getSystemInstance() {
        File trustStore = TrustStoreTrustManager.getSystemTrustStoreFile();
        char[] trustStorePassword = TrustStoreTrustManager.getSystemTrustStorePassword();
        TrustStoreTrustManager mgr = null;
        if (trustStore != null && trustStorePassword != null) {
            return new TrustStoreTrustManager(trustStore, trustStorePassword);
        }
        return mgr;
    }

    private static char[] toCharArray(String s) {
        return s == null ? null : s.toCharArray();
    }

    public static File getSystemTrustStoreFile() {
        String prop = System.getProperty(TRUSTSTORE_FILE_SPROP);
        File trustStore = prop == null ? null : new File(prop);
        return trustStore;
    }

    public static char[] getSystemTrustStorePassword() {
        return TrustStoreTrustManager.toCharArray(System.getProperty(TRUSTSTORE_PASSWORD_SPROP));
    }

    public final File getTrustStoreFile() {
        return this.mTrustStoreFile;
    }

    protected char[] getTrustStorePassword() {
        return this.mTrustStorePassword;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new UnsupportedOperationException("checkClientTrusted() not supported");
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException();
        }
        this.checkCertificate(chain);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    protected boolean askShouldAddToTrustStore(Certificate c) throws IOException {
        LineReaderImpl reader = new LineReaderImpl(System.in);
        String prompt = c.toString() + "\n\nAdd the above certificate to the truststore [y/n]?";
        String result = reader.readLine(prompt);
        return result.equalsIgnoreCase("y") || result.equalsIgnoreCase("yes");
    }

    protected boolean shouldAddToTrustStore(Certificate c) throws IOException {
        return this.mPrompt ? this.askShouldAddToTrustStore(c) : false;
    }

    protected String getCertificateAlias(Certificate c) {
        DateFormat f = DateFormat.getDateTimeInstance(1, 1);
        return "cert" + f.format(new Date());
    }

    protected void addCertificateToTrustStore(String alias, Certificate c) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.mTrustStore.setCertificateEntry(alias, c);
        this.writeStore();
    }

    protected void addCertificateToTrustStore(Certificate c) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String aliasName = this.getCertificateAlias(c);
        this.addCertificateToTrustStore(aliasName, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStore(KeyStore trustStore, char[] trustStorePassword, File f) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            trustStore.store(out, trustStorePassword);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            out.close();
        }
    }

    protected void writeStore() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.writeStore(this.getTrustStore(), this.getTrustStorePassword(), this.getTrustStoreFile());
    }

    protected void certificateNotInTrustStore(Certificate c) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.shouldAddToTrustStore(c)) {
            throw new CertificateException("Certificate not trusted:\n" + c);
        }
        this.addCertificateToTrustStore(c);
    }

    private void createTrustStoreFile(KeyStore keyStore, char[] pw, File f) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, FileNotFoundException {
        f.createNewFile();
        this.writeStore(keyStore, pw, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized KeyStore getTrustStore() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, FileNotFoundException {
        if (this.mTrustStore == null) {
            this.mTrustStore = KeyStore.getInstance(this.mKeyStoreType);
            File f = this.getTrustStoreFile();
            char[] pw = this.getTrustStorePassword();
            if (!f.exists() || f.length() == 0L) {
                f.delete();
                this.mTrustStore.load(null, pw);
                this.createTrustStoreFile(this.mTrustStore, pw, f);
            } else {
                FileInputStream is = new FileInputStream(f);
                try {
                    this.mTrustStore.load(is, pw);
                }
                finally {
                    is.close();
                }
            }
        }
        return this.mTrustStore;
    }

    protected void checkCertificate(X509Certificate[] chain) throws RuntimeException, CertificateException {
        try {
            for (int i = 0; i < chain.length; ++i) {
                chain[i].checkValidity();
            }
            this.mTrustStore = this.getTrustStore();
            X509Certificate cert = chain[0];
            if (this.mTrustStore.getCertificateAlias(cert) == null) {
                this.certificateNotInTrustStore(cert);
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "TrustStoreTrustManager--trusts certificates found in truststore: " + this.mTrustStore;
    }
}

