/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.cache;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.cache.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.cache.TimeOfDayMetadata;

public class CacheMetadata
extends ORMetadata {
    protected Boolean m_alwaysRefresh;
    protected Boolean m_disableHits;
    protected Boolean m_shared;
    protected Boolean m_refreshOnlyIfNewer;
    protected Enum m_coordinationType;
    protected Enum m_type;
    protected Integer m_expiry;
    protected Integer m_size;
    protected TimeOfDayMetadata m_expiryTimeOfDay;

    public CacheMetadata() {
        super("<cache>");
    }

    public CacheMetadata(Annotation cache, MetadataAccessibleObject accessibleObject) {
        super(cache, accessibleObject);
        this.m_alwaysRefresh = (Boolean)MetadataHelper.invokeMethod("alwaysRefresh", cache);
        this.m_disableHits = (Boolean)MetadataHelper.invokeMethod("disableHits", cache);
        this.m_coordinationType = (Enum)MetadataHelper.invokeMethod("coordinationType", cache);
        this.m_expiry = (Integer)MetadataHelper.invokeMethod("expiry", cache);
        Annotation expiryTimeOfDay = (Annotation)MetadataHelper.invokeMethod("expiryTimeOfDay", cache);
        if (((Boolean)MetadataHelper.invokeMethod("specified", expiryTimeOfDay)).booleanValue()) {
            this.m_expiryTimeOfDay = new TimeOfDayMetadata(expiryTimeOfDay, accessibleObject);
        }
        this.m_shared = (Boolean)MetadataHelper.invokeMethod("shared", cache);
        this.m_size = (Integer)MetadataHelper.invokeMethod("size", cache);
        this.m_type = (Enum)MetadataHelper.invokeMethod("type", cache);
        this.m_refreshOnlyIfNewer = (Boolean)MetadataHelper.invokeMethod("refreshOnlyIfNewer", cache);
    }

    public Boolean getAlwaysRefresh() {
        return this.m_alwaysRefresh;
    }

    public Enum getCoordinationType() {
        return this.m_coordinationType;
    }

    public Boolean getDisableHits() {
        return this.m_disableHits;
    }

    public Integer getExpiry() {
        return this.m_expiry;
    }

    public TimeOfDayMetadata getExpiryTimeOfDay() {
        return this.m_expiryTimeOfDay;
    }

    public Boolean getRefreshOnlyIfNewer() {
        return this.m_refreshOnlyIfNewer;
    }

    public Boolean getShared() {
        return this.m_shared;
    }

    public Integer getSize() {
        return this.m_size;
    }

    public Enum getType() {
        return this.m_type;
    }

    public void process(MetadataDescriptor descriptor, Class javaClass) {
        descriptor.setHasCache();
        ClassDescriptor classDescriptor = descriptor.getClassDescriptor();
        if (this.m_type == null || this.m_type.name().equals(CacheType.SOFT_WEAK.name())) {
            classDescriptor.useSoftCacheWeakIdentityMap();
        } else if (this.m_type.name().equals(CacheType.FULL.name())) {
            classDescriptor.useFullIdentityMap();
        } else if (this.m_type.name().equals(CacheType.WEAK.name())) {
            classDescriptor.useWeakIdentityMap();
        } else if (this.m_type.name().equals(CacheType.SOFT.name())) {
            classDescriptor.useSoftIdentityMap();
        } else if (this.m_type.name().equals(CacheType.HARD_WEAK.name())) {
            classDescriptor.useHardCacheWeakIdentityMap();
        } else if (this.m_type.name().equals(CacheType.CACHE.name())) {
            classDescriptor.useCacheIdentityMap();
        } else if (this.m_type.name().equals(CacheType.NONE.name())) {
            classDescriptor.useNoIdentityMap();
        }
        classDescriptor.setIdentityMapSize(this.m_size == null ? 100 : this.m_size);
        classDescriptor.setIsIsolated(this.m_shared == null ? true : this.m_shared == false);
        if (this.m_expiryTimeOfDay == null) {
            if (this.m_expiry != null && this.m_expiry != -1) {
                classDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy((long)this.m_expiry.intValue()));
            }
        } else if (this.m_expiry == null || this.m_expiry == -1) {
            classDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new DailyCacheInvalidationPolicy(this.m_expiryTimeOfDay.processHour().intValue(), this.m_expiryTimeOfDay.processMinute().intValue(), this.m_expiryTimeOfDay.processSecond().intValue(), this.m_expiryTimeOfDay.processMillisecond().intValue()));
        } else {
            throw ValidationException.cacheExpiryAndExpiryTimeOfDayBothSpecified((Class)javaClass);
        }
        classDescriptor.setShouldAlwaysRefreshCache(this.m_alwaysRefresh == null ? false : this.m_alwaysRefresh);
        classDescriptor.setShouldOnlyRefreshCacheIfNewerVersion(this.m_refreshOnlyIfNewer == null ? false : this.m_refreshOnlyIfNewer);
        classDescriptor.setShouldDisableCacheHits(this.m_disableHits == null ? false : this.m_disableHits);
        if (this.m_coordinationType == null || this.m_coordinationType.equals(CacheCoordinationType.SEND_OBJECT_CHANGES)) {
            classDescriptor.setCacheSynchronizationType(1);
        } else if (this.m_coordinationType.equals(CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS)) {
            classDescriptor.setCacheSynchronizationType(2);
        } else if (this.m_coordinationType.equals(CacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES)) {
            classDescriptor.setCacheSynchronizationType(3);
        } else if (this.m_coordinationType.equals(CacheCoordinationType.NONE)) {
            classDescriptor.setCacheSynchronizationType(4);
        }
    }

    public void setAlwaysRefresh(Boolean alwaysRefresh) {
        this.m_alwaysRefresh = alwaysRefresh;
    }

    public void setCoordinationType(Enum coordinationType) {
        this.m_coordinationType = coordinationType;
    }

    public void setDisableHits(Boolean disableHits) {
        this.m_disableHits = disableHits;
    }

    public void setExpiry(Integer expiry) {
        this.m_expiry = expiry;
    }

    public void setExpiryTimeOfDay(TimeOfDayMetadata expiryTimeOfDay) {
        this.m_expiryTimeOfDay = expiryTimeOfDay;
    }

    public void setRefreshOnlyIfNewer(Boolean refreshOnlyIfNewer) {
        this.m_refreshOnlyIfNewer = refreshOnlyIfNewer;
    }

    public void setShared(Boolean shared) {
        this.m_shared = shared;
    }

    public void setSize(Integer size) {
        this.m_size = size;
    }

    public void setType(Enum type) {
        this.m_type = type;
    }
}

