/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.helper.AMXDebugHelper;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.misc.Timings;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RunnableBase<T>
implements Runnable {
    private volatile Throwable mThrowable;
    private volatile CountDownLatch mLatch;
    private final String mName;
    private volatile boolean mUseRandomSleep;
    private final T mData;
    private volatile long mSubmitNanos;
    private volatile long mRunStartNanos;
    private volatile long mRunDoneNanos;
    private final AMXDebugHelper mDebug;
    private volatile ClassLoader mClassLoader;
    private static final AtomicInteger mThreadsRunning = new AtomicInteger(0);
    private static final ExecutorService _DefaultExecutorService = RunnableBase.createExecutorService();
    private static final long MAX_RANDOM_SLEEP_MILLIS = 500L;
    private static final Timings TIMINGS = Timings.getInstance("RunnableBase");

    private void debug(Object ... args) {
        if (this.mDebug.getDebug()) {
            this.mDebug.println(args);
        }
    }

    private static ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
    }

    public static ExecutorService getDefaultExecutorService() {
        return _DefaultExecutorService;
    }

    protected void runInSeparateThread(Runnable r) {
        this.getExecutorService().submit(r);
    }

    protected ExecutorService getExecutorService() {
        return RunnableBase.getDefaultExecutorService();
    }

    private void _submit(HowToRun howToRun) {
        this.mClassLoader = Thread.currentThread().getContextClassLoader();
        if (howToRun != HowToRun.RUN_IN_CURRENT_THREAD && howToRun != HowToRun.RUN_IN_SEPARATE_THREAD) {
            throw new IllegalArgumentException();
        }
        if (this.mLatch != null) {
            throw new IllegalStateException();
        }
        this.mSubmitNanos = System.nanoTime();
        if (howToRun == HowToRun.RUN_IN_CURRENT_THREAD) {
            this.runSync();
        } else {
            this.mLatch = new CountDownLatch(1);
            this.runInSeparateThread(this);
        }
    }

    public void submit() {
        this._submit(this.getRecommendedSubmitType());
    }

    public void submit(HowToRun howToRun) {
        this._submit(howToRun);
    }

    protected RunnableBase(String name, T data) {
        this.mDebug = new AMXDebugHelper("RunnableBase-" + name);
        this.mDebug.setEchoToStdOut(true);
        this.mName = name == null ? this.getClass().getName() + ".<no_name>" : name;
        this.mData = data;
        this.mThrowable = null;
        this.mSubmitNanos = 0L;
        this.mRunStartNanos = 0L;
        this.mRunDoneNanos = 0L;
        this.mUseRandomSleep = false;
        this.mLatch = null;
    }

    protected RunnableBase(String name) {
        this(name, null);
    }

    public final T getData() {
        return this.mData;
    }

    protected RunnableBase() {
        this(null);
    }

    protected abstract void doRun() throws Exception;

    public String getName() {
        return this.mName == null || this.mName.length() == 0 ? this.getClass().getName() : this.mName;
    }

    protected static void sleepMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setUseRandomSleep(boolean useRandom) {
        this.mUseRandomSleep = useRandom;
    }

    public static Timings getTimings() {
        return TIMINGS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runSync() {
        this.mRunStartNanos = System.nanoTime();
        if (this.mUseRandomSleep) {
            long sleepMillis = (System.currentTimeMillis() >> 4) % 500L;
            this.debug("Random sleep for: " + sleepMillis + "ms");
            RunnableBase.sleepMillis(sleepMillis);
        }
        try {
            this.doRun();
        }
        catch (Throwable t) {
            this.mThrowable = t;
        }
        finally {
            this.mRunDoneNanos = System.nanoTime();
            if (this.mLatch != null) {
                this.mLatch.countDown();
                this.mLatch = null;
            }
            String msg = "RunnableBase-" + StringUtil.quote(this.getName());
            long runTime = this.getNanosFromSubmit();
            RunnableBase.getTimings().add(msg, runTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        int numRunning = mThreadsRunning.incrementAndGet();
        Thread.currentThread().setContextClassLoader(this.mClassLoader);
        try {
            this.runSync();
        }
        finally {
            mThreadsRunning.decrementAndGet();
        }
    }

    public long getNanosFromSubmit() {
        return this.mRunDoneNanos - this.mSubmitNanos;
    }

    public long getNanosFromRunStart() {
        return this.mRunDoneNanos - this.mRunStartNanos;
    }

    public long getRunLatency() {
        return this.mRunStartNanos - this.mSubmitNanos;
    }

    public final Throwable waitDone() {
        CountDownLatch latch = this.mLatch;
        if (latch != null) {
            try {
                latch.await();
            }
            catch (InterruptedException intr) {
                throw new RuntimeException(intr);
            }
        }
        return this.mThrowable;
    }

    public final void waitDoneThrow() {
        Throwable t = this.waitDone();
        if (t != null) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    protected Throwable launderThrowable(Throwable t) {
        return t;
    }

    public HowToRun getRecommendedSubmitType() {
        int numProcessors = Runtime.getRuntime().availableProcessors();
        boolean singleCore = numProcessors == 1;
        HowToRun howToRun = HowToRun.RUN_IN_CURRENT_THREAD;
        if (singleCore) {
            howToRun = mThreadsRunning.intValue() <= 1 ? HowToRun.RUN_IN_SEPARATE_THREAD : HowToRun.RUN_IN_CURRENT_THREAD;
        } else {
            int CUTOFF = numProcessors * 2;
            howToRun = mThreadsRunning.intValue() <= CUTOFF ? HowToRun.RUN_IN_SEPARATE_THREAD : HowToRun.RUN_IN_CURRENT_THREAD;
        }
        return howToRun;
    }

    public String toString() {
        boolean done;
        String delim = ", ";
        boolean started = this.mSubmitNanos != 0L;
        boolean bl = done = this.mRunDoneNanos != 0L;
        long runTimeNanos = started ? (done ? this.mRunDoneNanos - this.mRunStartNanos : System.nanoTime() - this.mRunStartNanos) : 0L;
        String throwable = this.mThrowable == null ? "" : this.mThrowable.toString();
        String runTimeString = StringUtil.getTimingString(runTimeNanos);
        return "Runnable \"" + this.getClass().getName() + "\"" + ", " + "name = " + this.getName() + ", " + "started=" + started + ", " + "done=" + done + ", " + "run-time=" + runTimeString + ", " + throwable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HowToRun {
        RUN_INVALID,
        RUN_IN_CURRENT_THREAD,
        RUN_IN_SEPARATE_THREAD;

    }
}

