/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeCast {
    public static <T> Collection<T> asCollection(Object o) {
        return (Collection)Collection.class.cast(o);
    }

    public static <T extends Serializable> Collection<T> asSerializableCollection(Object c) {
        Collection<T> result = TypeCast.asCollection(c);
        TypeCast.checkSerializable(result);
        return result;
    }

    public static <K, V> Map<K, V> asMap(Object m) {
        return (Map)Map.class.cast(m);
    }

    public static <K extends Serializable, V extends Serializable> Map<K, V> asSerializableMap(Object m) {
        Map<K, V> result = TypeCast.asMap(m);
        TypeCast.checkSerializable(result);
        return result;
    }

    public static <K, V> Hashtable<K, V> asHashtable(Object o) {
        return (Hashtable)Hashtable.class.cast(o);
    }

    public static <T> List<T> asList(Object list) {
        return (List)List.class.cast(list);
    }

    public static <T extends Serializable> List<T> asSerializableList(Object list) {
        List<T> result = TypeCast.asList(list);
        TypeCast.checkSerializable(result);
        return result;
    }

    public static <T> Set<T> asSet(Object s) {
        return (Set)Set.class.cast(s);
    }

    public static <T> SortedSet<T> asSortedSet(Object s) {
        return (SortedSet)Set.class.cast(s);
    }

    public static <T extends Serializable> Set<T> asSerializableSet(Object s) {
        Set<T> result = TypeCast.asSet(s);
        TypeCast.checkSerializable(result);
        return result;
    }

    public static <T> Class<T> asClass(Class<?> c) {
        if (!(c instanceof Class)) {
            throw new IllegalArgumentException("" + c);
        }
        return (Class)Class.class.cast(c);
    }

    public static <T> T[] asArray(Object o) {
        return (Object[])Object[].class.cast(o);
    }

    public static void checkSerializable(Object[] a) {
        for (Object o : a) {
            TypeCast.checkSerializable(o);
        }
    }

    public static void checkSerializableElements(Collection<?> l) {
        for (Object o : l) {
            TypeCast.checkSerializable(o);
        }
    }

    public static Collection<Serializable> checkSerializable(Collection<?> l) {
        TypeCast.checkSerializable(l, true);
        return TypeCast.asCollection(l);
    }

    public static Collection<Serializable> checkSerializable(Collection<?> l, boolean collectionItself) {
        if (collectionItself) {
            TypeCast.checkSerializable(l);
        }
        TypeCast.checkSerializableElements(l);
        return TypeCast.asCollection(l);
    }

    public static Map<Serializable, Serializable> checkSerializable(Map<?, ?> m) {
        TypeCast.checkSerializable(m);
        TypeCast.checkSerializable(m.keySet(), false);
        TypeCast.checkSerializable(m.values(), false);
        return TypeCast.asMap(m);
    }

    public static Serializable checkSerializable(Object o) {
        if (o != null && !(o instanceof Serializable)) {
            throw new ClassCastException("Object not Serializable, class = " + o.getClass().getName());
        }
        return (Serializable)Serializable.class.cast(o);
    }

    public static <T> Collection<T> checkCollection(Collection<?> c, Class<T> theClass) {
        if (c != null) {
            for (Object o : c) {
                TypeCast.checkObject(o, theClass);
            }
        }
        return TypeCast.asCollection(c);
    }

    public static <T> List<T> checkList(List<?> l, Class<T> theClass) {
        if (l != null) {
            for (Object o : l) {
                TypeCast.checkObject(o, theClass);
            }
        }
        return TypeCast.asList(l);
    }

    public static <T> Set<T> checkSet(Set<?> s, Class<T> theClass) {
        if (s != null) {
            for (Object o : s) {
                TypeCast.checkObject(o, theClass);
            }
        }
        return TypeCast.asSet(s);
    }

    public static <K, V> Map<K, V> checkMap(Map<?, ?> m, Class<K> keyClass, Class<V> valueClass) {
        if (m != null) {
            TypeCast.checkSet(m.keySet(), keyClass);
            TypeCast.checkCollection(m.values(), valueClass);
        }
        return TypeCast.asMap(m);
    }

    public static <T> T checkObject(Object o, Class<T> theClass) {
        if (o != null && !theClass.isAssignableFrom(o.getClass())) {
            throw new ClassCastException("Object of class " + o.getClass().getName() + " not assignment compatible with: " + theClass.getName());
        }
        return (T)o;
    }

    public static <T> void checkArray(Object[] a, Class<T> theClass) {
        for (Object o : a) {
            TypeCast.checkObject(o, theClass);
        }
    }

    public static Collection<String> checkedStringCollection(Collection<?> c) {
        return TypeCast.checkedCollection(c, String.class);
    }

    public static Set<String> checkedStringSet(Set<?> s) {
        return TypeCast.checkedSet(s, String.class);
    }

    public static List<String> checkedStringList(List<?> l) {
        return TypeCast.checkedList(l, String.class);
    }

    public static Map<String, String> checkedStringMap(Map<?, ?> m) {
        return TypeCast.checkedMap(m, String.class, String.class);
    }

    public static <T> Collection<T> checkedCollection(Collection<?> c, Class<T> theClass) {
        Collection<T> cc = TypeCast.checkCollection(c, theClass);
        return Collections.checkedCollection(cc, theClass);
    }

    public static <T> Set<T> checkedSet(Set<?> s, Class<T> theClass) {
        Set<T> cs = TypeCast.checkSet(s, theClass);
        return Collections.checkedSet(cs, theClass);
    }

    public static <T> List<T> checkedList(List<?> l, Class<T> theClass) {
        List<T> cl = TypeCast.checkList(l, theClass);
        return Collections.checkedList(cl, theClass);
    }

    public static <K, V> Map<K, V> checkedMap(Map<?, ?> m, Class<K> keyClass, Class<V> valueClass) {
        Map<K, V> cm = TypeCast.checkMap(m, keyClass, valueClass);
        return Collections.checkedMap(cm, keyClass, valueClass);
    }
}

