/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.common_impl.Tokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="list-commands")
public class ListCommandsCommand
implements AdminCommand {
    private static final String DEBUG_PAIR = "mode=debug";
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ActionReport report = context.getActionReport();
        report.setMessage("List of Commands");
        report.getTopMessagePart().setChildrenType("Command");
        for (String name : this.sortedAdminCommands()) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(name);
        }
    }

    private List<String> sortedAdminCommands() {
        ArrayList<String> names = new ArrayList<String>();
        for (AdminCommand command : this.habitat.getAllByContract(AdminCommand.class)) {
            String name = command.getClass().getAnnotation(Service.class).name();
            if (ListCommandsCommand.debugCommand(command)) {
                if (!ListCommandsCommand.debugSet()) continue;
                names.add(name);
                continue;
            }
            names.add(name);
        }
        Collections.sort(names);
        return names;
    }

    private static boolean debugCommand(AdminCommand command) {
        String metadata = command.getClass().getAnnotation(Service.class).metadata();
        boolean dc = false;
        if (metadata != null && ListCommandsCommand.metadataContains(metadata, DEBUG_PAIR)) {
            dc = true;
        }
        return dc;
    }

    private static boolean metadataContains(String md, String nev) {
        boolean contains = false;
        Tokenizer st = new Tokenizer(md, ",");
        for (String pair : st) {
            if (!pair.trim().equals(nev)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private static boolean debugSet() {
        String s = System.getenv("AS_DEBUG");
        return Boolean.valueOf(s);
    }
}

