/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-jvm-options")
@Scoped(value=PerLookup.class)
@I18n(value="list.jvm.options")
public final class ListJvmOptions
implements AdminCommand {
    @Param(name="target", optional=true)
    String target;
    @Inject
    JavaConfig jc;
    private static final StringManager lsm = StringManager.getManager(ListJvmOptions.class);
    private static final Logger logger = Logger.getLogger(ListJvmOptions.class.getPackage().getName());

    public void execute(AdminCommandContext context) {
        ListJvmOptions.logfh("Injected JavaConfig: " + this.jc);
        ArrayList opts = new ArrayList(this.jc.getJvmOptions());
        Collections.sort(opts);
        ActionReport report = context.getActionReport();
        try {
            for (String option : opts) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(option);
            }
        }
        catch (Exception e) {
            report.setMessage(lsm.getStringWithDefault("list.jvm.options.failed", "Command: list-jvm-options failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    public ListJvmOptions() {
        ListJvmOptions.logfh(this);
    }

    private static void logfh(Object o) {
        if (logger.isLoggable(Level.FINE)) {
            if (o == null) {
                logger.fine("null reference passed");
            } else {
                logger.fine("Hashcode of the given object: " + o.hashCode());
            }
        }
    }
}

